/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.ui;

import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.Outline;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewOutlineProvider;
import android.view.WindowManager;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import android.webkit.DownloadListener;
import android.webkit.JavascriptInterface;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ProgressBar;
import com.taptap.sdk.LoginRequest;
import com.taptap.sdk.LoginResponse;
import com.taptap.sdk.R;
import com.taptap.sdk.TapLoginInnerConfig;
import com.taptap.sdk.TapLoginWithCode;
import com.taptap.sdk.Utils;
import com.taptap.sdk.ui.Block;
import com.taptap.sdk.ui.CodeUtil;
import com.tds.common.localize.LocalizeManager;
import com.tds.common.utils.CommonUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class WebBlock
extends Block {
    private FrameLayout container;
    private FrameLayout webContainer;
    private ProgressBar progressBar;
    private WebView mWebView;
    private ImageView mClose;
    private int landscapeWidth = -1;
    private int portraitHeight = -1;
    private IWebLoginCallback callback;
    private String codeVerifier;
    LoginRequest request;
    int cornerRadius;
    ValueAnimator loadingAnimator1;
    ValueAnimator loadingAnimator2;

    public void setLoginCallback(IWebLoginCallback callback) {
        this.callback = callback;
    }

    @Override
    protected View onCreateView(LayoutInflater inflater, ViewGroup container) {
        return inflater.inflate(R.layout.fragment_webview_login, container, false);
    }

    @Override
    protected void onViewCreated(View view) {
        this.cornerRadius = (int)(10.0f * view.getResources().getDisplayMetrics().density + 0.5f);
        this.container = (FrameLayout)view.findViewById(R.id.container);
        this.webContainer = (FrameLayout)view.findViewById(R.id.web_container);
        this.progressBar = (ProgressBar)view.findViewById(R.id.progress);
        this.mWebView = (WebView)view.findViewById(R.id.webview);
        this.mClose = (ImageView)view.findViewById(R.id.close);
        int width = (int)((float)WebBlock.getScreenMax((Context)this.getActivity()) * 0.6f);
        int height = (int)((float)WebBlock.getScreenMax((Context)this.getActivity()) * 0.8f);
        if (width != -1) {
            this.landscapeWidth = width;
        }
        if (height != -1) {
            this.portraitHeight = height;
        }
        this.mClose.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                WebBlock.this.getActivity().finish();
            }
        });
        this.initWebView();
        this.resetLayout(this.getActivity().getResources().getConfiguration());
        this.request = (LoginRequest)this.getArguments().getParcelable("request");
        this.codeVerifier = CodeUtil.getCodeVerifier(128);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("client_id", TapLoginInnerConfig.getClientId());
        params.put("response_type", "code");
        params.put("version", "3.28.3");
        params.put("platform", "android");
        StringBuilder permissions = new StringBuilder();
        if (this.request.getPermissions() != null) {
            for (int i = 0; i < this.request.getPermissions().length; ++i) {
                if (i == this.request.getPermissions().length - 1) {
                    permissions.append(this.request.getPermissions()[i]);
                    continue;
                }
                permissions.append(this.request.getPermissions()[i]).append(",");
            }
        }
        params.put("scope", permissions.toString());
        params.put("redirect_uri", "tapoauth://authorize");
        params.put("state", this.request.getState());
        params.put("code_challenge", CodeUtil.getCodeChallenge(this.codeVerifier));
        params.put("code_challenge_method", "S256");
        JSONObject info = new JSONObject();
        try {
            info.put("device_id", (Object)(Build.MANUFACTURER + " " + Build.MODEL));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        params.put("info", info.toString());
        if (!TextUtils.isEmpty((CharSequence)this.request.getPhoneVerifyToken())) {
            params.put("x_phone_verify_token", this.request.getPhoneVerifyToken());
        }
        if (!TextUtils.isEmpty((CharSequence)this.request.getPreferredLoginType())) {
            params.put("x_login_type", this.request.getPreferredLoginType());
        }
        JSONObject extraObject = new JSONObject();
        try {
            extraObject.put("preapproved", this.request.isPreApproved() ? 1 : 0);
            params.put("extra", extraObject.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        String url = TapLoginInnerConfig.getRegionType().authorizeUrl() + "?" + WebBlock.convertHashMapToParameters(params);
        this.syncCookie();
        this.mWebView.getSettings().setUserAgentString("TapTapAndroidSDK/3.28.3 " + this.mWebView.getSettings().getUserAgentString());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-SDK-UA", this.request.getInfo());
        this.mWebView.loadUrl(url, headers);
        this.startLoadingAnimation();
    }

    private void startLoadingAnimation() {
        this.progressBar.setMax(1000);
        this.loadingAnimator1 = ValueAnimator.ofInt((int[])new int[]{0, 200}).setDuration(800L);
        this.loadingAnimator1.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                int progress = (Integer)animation.getAnimatedValue();
                WebBlock.this.progressBar.setProgress(progress);
                if (progress == 200) {
                    WebBlock.this.startSecondLoadingAnimation();
                }
            }
        });
        this.loadingAnimator1.start();
    }

    private void startSecondLoadingAnimation() {
        this.loadingAnimator2 = ValueAnimator.ofInt((int[])new int[]{this.progressBar.getProgress(), 800}).setDuration(10000L);
        this.loadingAnimator2.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                int progress = (Integer)animation.getAnimatedValue();
                WebBlock.this.progressBar.setProgress(progress);
            }
        });
        this.loadingAnimator2.start();
    }

    private void endLoadingAnimation() {
        if (this.loadingAnimator1 != null && this.loadingAnimator1.isRunning()) {
            this.loadingAnimator1.cancel();
        }
        if (this.loadingAnimator2 != null && this.loadingAnimator2.isRunning()) {
            this.loadingAnimator2.cancel();
        }
        ValueAnimator animator = ValueAnimator.ofInt((int[])new int[]{this.progressBar.getProgress(), 1000}).setDuration(500L);
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                int progress = (Integer)animation.getAnimatedValue();
                WebBlock.this.progressBar.setProgress(progress);
                if (progress == 1000) {
                    WebBlock.this.progressBar.setVisibility(8);
                }
            }
        });
        animator.start();
    }

    private void syncCookie() {
        CookieSyncManager.createInstance((Context)this.getActivity());
        CookieManager cookieManager = CookieManager.getInstance();
        cookieManager.setAcceptCookie(true);
        cookieManager.setCookie("https://www.xdrnd.com/", "skip_captcha=1");
        if (Build.VERSION.SDK_INT >= 21) {
            cookieManager.flush();
        } else {
            CookieSyncManager.getInstance().sync();
        }
    }

    public static String convertHashMapToParameters(HashMap<String, String> params) {
        if (null != params && params.size() > 0) {
            StringBuilder encodedParams = new StringBuilder();
            try {
                Iterator<Map.Entry<String, String>> iterator = params.entrySet().iterator();
                int count = 0;
                while (iterator.hasNext()) {
                    Map.Entry<String, String> uee = iterator.next();
                    encodedParams.append(URLEncoder.encode(uee.getKey(), "UTF-8"));
                    encodedParams.append('=');
                    encodedParams.append(URLEncoder.encode(uee.getValue(), "UTF-8"));
                    if (count != params.size() - 1) {
                        encodedParams.append('&');
                    }
                    ++count;
                }
                return encodedParams.toString();
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private void initWebView() {
        if (TapLoginInnerConfig.roundCorner && Build.VERSION.SDK_INT >= 21) {
            this.mWebView.setOutlineProvider(new ViewOutlineProvider(){

                public void getOutline(View view, Outline outline) {
                    outline.setRoundRect(0, 0, view.getWidth(), view.getHeight(), (float)WebBlock.this.cornerRadius);
                }
            });
            this.mWebView.setClipToOutline(true);
        }
        this.mWebView.setDownloadListener(new DownloadListener(){

            public void onDownloadStart(String url, String userAgent, String contentDisposition, String mimetype, long contentLength) {
                Intent i = new Intent("android.intent.action.VIEW");
                i.setData(Uri.parse((String)url));
                try {
                    WebBlock.this.getActivity().startActivity(i);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.mWebView.setWebViewClient(new WebViewClient(){

            public void onPageStarted(WebView view, String url, Bitmap favicon) {
                super.onPageStarted(view, url, favicon);
            }

            public boolean shouldOverrideUrlLoading(WebView view, final String url) {
                if (url.toLowerCase(Locale.US).startsWith("tapoauth")) {
                    Uri uri = Uri.parse((String)url);
                    String errorMsg = uri.getQueryParameter("error");
                    String code = uri.getQueryParameter("code");
                    String name = uri.getQueryParameter("name");
                    String state = uri.getQueryParameter("state");
                    if (TextUtils.isEmpty((CharSequence)errorMsg)) {
                        TapLoginWithCode.loginWithCode(code, WebBlock.this.codeVerifier, state, name, new TapLoginWithCode.LoginResultCallBack(){

                            @Override
                            public void onLoginResult(LoginResponse response) {
                                if (null != WebBlock.this.callback) {
                                    WebBlock.this.callback.onResponse(response, url);
                                }
                            }
                        });
                        return true;
                    }
                    LoginResponse response = new LoginResponse(null, state, errorMsg, null, false);
                    if (null != WebBlock.this.callback) {
                        WebBlock.this.callback.onResponse(response, url);
                    }
                    return true;
                }
                return false;
            }

            public void onLoadResource(WebView view, String url) {
                super.onLoadResource(view, url);
            }

            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
                WebBlock.this.endLoadingAnimation();
                WebBlock.this.injectJsInterface();
            }

            public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                super.onReceivedError(view, errorCode, description, failingUrl);
            }
        });
        this.mWebView.setWebChromeClient(new WebChromeClient());
        WebSettings settings = this.mWebView.getSettings();
        settings.setAllowUniversalAccessFromFileURLs(false);
        settings.setAllowFileAccessFromFileURLs(false);
        settings.setAllowFileAccess(false);
        settings.setJavaScriptEnabled(true);
        settings.setSavePassword(false);
        settings.setSaveFormData(false);
        settings.setCacheMode(2);
        this.mWebView.removeJavascriptInterface("searchBoxJavaBridge_");
        this.mWebView.removeJavascriptInterface("accessibility");
        this.mWebView.removeJavascriptInterface("accessibilityTraversal");
        this.mWebView.addJavascriptInterface((Object)new urlResource(), "urlResource");
        this.mWebView.setOverScrollMode(2);
        this.mWebView.setVerticalScrollBarEnabled(false);
    }

    private void injectJsInterface() {
        this.mWebView.loadUrl("javascript:window.TapTapAPI = function(action, params) {return window.urlResource.TapTapAPI(action, params);}");
        this.mWebView.loadUrl("javascript:window.TapTapAPI.openBrowser = function(param){return window.TapTapAPI('openBrowser', param)}");
        this.mWebView.loadUrl("javascript:window.TapTapAPI.tapEnv = function(param){return window.TapTapAPI('tapEnv', param)}");
        this.mWebView.loadUrl("javascript:window.TapTapAPI.getSDKInfo = function(param){return window.TapTapAPI('getSDKInfo', param)}");
    }

    private static String getTapEnv() {
        JSONObject object = new JSONObject();
        try {
            object.put("MANUFACTURER", (Object)String.valueOf(Build.MANUFACTURER));
            object.put("MODEL", (Object)String.valueOf(Build.MODEL));
            object.put("VERSION_RELEASE", (Object)String.valueOf(Build.VERSION.RELEASE));
            object.put("VERSION_SDK_INT", (Object)String.valueOf(Build.VERSION.SDK_INT));
            object.put("VN_CODE", (Object)String.valueOf(32803001));
            object.put("VN_NAME", (Object)"3.28.3");
            object.put("LOC", (Object)CommonUtils.getCurrentLocale().getDisplayName());
            object.put("LANG", (Object)LocalizeManager.getPreferredLanguageString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return object.toString();
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.resetLayout(newConfig);
    }

    private void resetLayout(Configuration newConfig) {
        if (newConfig.orientation == 2) {
            if (this.landscapeWidth != -1) {
                ViewGroup.LayoutParams lp = this.container.getLayoutParams();
                lp.width = this.landscapeWidth + Utils.dip2px((Context)this.getActivity(), 84.0f);
                lp.height = -1;
                this.container.setLayoutParams(lp);
                ViewGroup.MarginLayoutParams mlp = (ViewGroup.MarginLayoutParams)this.webContainer.getLayoutParams();
                int margin = Utils.dip2px((Context)this.getActivity(), 16.0f);
                int leftMargin = Utils.dip2px((Context)this.getActivity(), 42.0f);
                mlp.topMargin = margin;
                mlp.leftMargin = leftMargin;
                mlp.rightMargin = leftMargin;
                mlp.bottomMargin = margin;
                this.webContainer.setLayoutParams((ViewGroup.LayoutParams)mlp);
                FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.mClose.getLayoutParams();
                layoutParams.gravity = 53;
                this.mClose.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                ViewGroup.MarginLayoutParams closeMarginLayoutParams = (ViewGroup.MarginLayoutParams)this.mClose.getLayoutParams();
                closeMarginLayoutParams.setMargins(Utils.dip2px((Context)this.getActivity(), 4.0f), margin, 0, 0);
                this.mClose.setLayoutParams((ViewGroup.LayoutParams)closeMarginLayoutParams);
            }
        } else if (newConfig.orientation == 1 && this.portraitHeight != -1) {
            int bottomMargin;
            ViewGroup.LayoutParams lp = this.container.getLayoutParams();
            lp.height = this.portraitHeight + Utils.dip2px((Context)this.getActivity(), 38.0f);
            lp.width = -1;
            this.container.setLayoutParams(lp);
            ViewGroup.MarginLayoutParams mlp = (ViewGroup.MarginLayoutParams)this.webContainer.getLayoutParams();
            int margin = Utils.dip2px((Context)this.getActivity(), 20.0f);
            mlp.topMargin = bottomMargin = Utils.dip2px((Context)this.getActivity(), 38.0f);
            mlp.leftMargin = margin;
            mlp.rightMargin = margin;
            mlp.bottomMargin = margin;
            this.webContainer.setLayoutParams((ViewGroup.LayoutParams)mlp);
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.mClose.getLayoutParams();
            layoutParams.gravity = 53;
            this.mClose.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            ViewGroup.MarginLayoutParams closeMarginLayoutParams = (ViewGroup.MarginLayoutParams)this.mClose.getLayoutParams();
            closeMarginLayoutParams.setMargins(0, 0, margin, 0);
            this.mClose.setLayoutParams((ViewGroup.LayoutParams)closeMarginLayoutParams);
        }
    }

    public static int getScreenMax(Context context) {
        WindowManager wm = (WindowManager)context.getSystemService("window");
        DisplayMetrics outMetrics = new DisplayMetrics();
        if (wm != null) {
            wm.getDefaultDisplay().getMetrics(outMetrics);
            return Math.max(outMetrics.heightPixels, outMetrics.widthPixels);
        }
        return -1;
    }

    public static interface IWebLoginCallback {
        public void onResponse(LoginResponse var1, String var2);
    }

    final class urlResource {
        urlResource() {
        }

        @JavascriptInterface
        public String TapTapAPI(String action, final String params) {
            if (TextUtils.isEmpty((CharSequence)action) || null == WebBlock.this.mWebView) {
                return null;
            }
            if ("openBrowser".equals(action)) {
                WebBlock.this.mWebView.post(new Runnable(){

                    @Override
                    public void run() {
                        Uri uri = Uri.parse((String)params);
                        Intent intent = new Intent("android.intent.action.VIEW", uri);
                        try {
                            WebBlock.this.getActivity().startActivity(intent);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            } else {
                if ("tapEnv".equals(action)) {
                    return WebBlock.getTapEnv();
                }
                if ("getSDKInfo".equals(action)) {
                    return WebBlock.this.request == null ? "" : WebBlock.this.request.getInfo();
                }
            }
            return null;
        }
    }
}

