/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.wrapper;

import android.app.Activity;
import android.content.Context;
import com.taptap.sdk.AccessToken;
import com.taptap.sdk.AccountGlobalError;
import com.taptap.sdk.LoginSdkConfig;
import com.taptap.sdk.Profile;
import com.taptap.sdk.RegionType;
import com.taptap.sdk.TapLoginHelper;
import com.taptap.sdk.net.Api;
import com.taptap.sdk.wrapper.LoginWrapperBean;
import com.taptap.sdk.wrapper.TDSLoginService;
import com.tds.common.annotation.Keep;
import com.tds.common.bridge.BridgeCallback;
import com.tds.common.bridge.utils.BridgeJsonHelper;
import com.tds.common.log.Logger;
import java.util.HashMap;

@Keep
public class TDSLoginServiceImpl
implements TDSLoginService {
    private static final String TAG = TDSLoginServiceImpl.class.getSimpleName();
    private final Logger logger = Logger.getCommonLogger();

    @Override
    public void init(Activity activity, String clientID) {
        this.init(activity, clientID, true, true);
    }

    @Override
    public void init(Activity activity, String clientID, boolean isCN, boolean roundCorner) {
        this.logger.i(TAG, "init");
        LoginSdkConfig config = new LoginSdkConfig();
        config.regionType = isCN ? RegionType.CN : RegionType.IO;
        config.roundCorner = roundCorner;
        TapLoginHelper.init((Context)activity, clientID, config);
    }

    @Override
    public void changeConfig(boolean roundCorner, boolean isPortrait) {
        this.logger.i(TAG, "changeConfig");
        LoginSdkConfig config = new LoginSdkConfig();
        config.roundCorner = roundCorner;
        config.isPortrait = isPortrait;
        TapLoginHelper.changeTapLoginConfig(config);
    }

    @Override
    public void registerLoginCallback(final BridgeCallback callback) {
        this.logger.i(TAG, "registerLoginCallback");
        TapLoginHelper.registerLoginCallback(new TapLoginHelper.TapLoginResultCallback(){

            @Override
            public void onLoginSuccess(AccessToken token) {
                callback.onResult(BridgeJsonHelper.object2JsonString(new LoginWrapperBean<String>(token.toJsonString(), 0)));
            }

            @Override
            public void onLoginCancel() {
                callback.onResult(BridgeJsonHelper.object2JsonString(new LoginWrapperBean(1)));
            }

            @Override
            public void onLoginError(AccountGlobalError accountGlobalError) {
                callback.onResult(BridgeJsonHelper.object2JsonString(new LoginWrapperBean<String>(accountGlobalError.toJsonString(), 2)));
            }
        });
    }

    @Override
    public void unregisterLoginCallback() {
        this.logger.i(TAG, "unregisterLoginCallback");
        TapLoginHelper.unregisterLoginCallback();
    }

    @Override
    public void startTapLogin(Activity activity, String[] permissions) {
        this.logger.i(TAG, "startTapLogin");
        TapLoginHelper.startTapLogin(activity, permissions);
    }

    @Override
    public void currentAccessToken(BridgeCallback callback) {
        this.logger.i(TAG, "getCurrentAccessToken");
        AccessToken token = TapLoginHelper.getCurrentAccessToken();
        if (token != null) {
            callback.onResult(token.toJsonString());
        } else {
            callback.onResult(null);
        }
    }

    @Override
    public void currentProfile(BridgeCallback callback) {
        this.logger.i(TAG, "getCurrentProfile");
        Profile profile = TapLoginHelper.getCurrentProfile();
        if (profile != null) {
            callback.onResult(profile.toJsonString());
        } else {
            callback.onResult(null);
        }
    }

    @Override
    public void fetchProfileForCurrentAccessToken(final BridgeCallback callback) {
        this.logger.i(TAG, "fetchProfileForCurrentAccessToken");
        TapLoginHelper.fetchProfileForCurrentAccessToken(new Api.ApiCallback<Profile>(){

            @Override
            public void onSuccess(Profile data) {
                callback.onResult(BridgeJsonHelper.object2JsonString(new LoginWrapperBean<String>(data.toJsonString(), 0)));
            }

            @Override
            public void onError(Throwable error) {
                callback.onResult(BridgeJsonHelper.object2JsonString(new LoginWrapperBean<String>(error.getMessage(), 1)));
            }
        });
    }

    @Override
    public void getTestQualification(final BridgeCallback callback) {
        final HashMap params = new HashMap(1);
        TapLoginHelper.getTestQualification(new Api.ApiCallback<Boolean>(){

            @Override
            public void onSuccess(Boolean result) {
                params.put("userTestQualification", result != false ? 1 : 0);
                callback.onResult(BridgeJsonHelper.object2JsonString((Object)params));
            }

            @Override
            public void onError(Throwable error) {
                params.put("userTestQualification", 0);
                callback.onResult(BridgeJsonHelper.object2JsonString((Object)params));
            }
        });
    }

    @Override
    public void logout() {
        this.logger.i(TAG, "logout");
        TapLoginHelper.logout();
    }

    @Override
    public void appendPermission(String permission2) {
        this.logger.i(TAG, "appendPermission");
        TapLoginHelper.appendPermission(permission2);
    }
}

