/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.wrapper;

import com.taptap.sdk.friends.TapFriendResult;
import com.taptap.sdk.friends.TapFriends;
import com.taptap.sdk.friends.TapFriendsCallback;
import com.taptap.sdk.wrapper.TapFriendResponse;
import com.taptap.sdk.wrapper.TapFriendsService;
import com.tds.common.annotation.Keep;
import com.tds.common.bridge.BridgeCallback;
import com.tds.common.log.Logger;
import org.json.JSONException;
import org.json.JSONObject;

@Keep
public class TapFriendsServiceImpl
implements TapFriendsService {
    private final Logger mFriendLogger = Logger.get((String)"TapFriends");

    @Override
    public void queryMutualList(String cursor, int size, final BridgeCallback callback) {
        this.mFriendLogger.i("TapFriend queryMutualList pageSize:" + size + " cursor:" + cursor);
        TapFriends.queryMutualList(cursor, size, new TapFriendsCallback<TapFriendResult>(){

            @Override
            public void onSuccess(TapFriendResult tapFriendResult) {
                callback.onResult(new TapFriendResponse(true, tapFriendResult.toJson().toString()).toJson());
            }

            @Override
            public void onFail(Throwable throwable) {
                JSONObject error = new JSONObject();
                try {
                    error.put("error_description", (Object)throwable.getMessage());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                callback.onResult(new TapFriendResponse(false, error.toString()).toJson());
            }
        });
    }
}

