/*
 * Decompiled with CFR 0.152.
 */
package com.tapsdk.lc;

import android.os.Parcel;
import android.os.Parcelable;
import com.tapsdk.lc.ArchivedRequests;
import com.tapsdk.lc.LCLogger;
import com.tapsdk.lc.LCObject;
import com.tapsdk.lc.Transformer;
import com.tapsdk.lc.utils.LogUtil;

public class LCParcelableObject
implements Parcelable {
    private static final LCLogger LOGGER = LogUtil.getLogger(LCParcelableObject.class);
    private LCObject instance = null;
    public static final transient Parcelable.Creator<LCParcelableObject> CREATOR = LCObjectCreator.instance;

    public LCParcelableObject(LCObject object) {
        this.instance = object;
    }

    public LCParcelableObject() {
    }

    public LCObject object() {
        return this.instance;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int i) {
        String archivedContent = ArchivedRequests.getArchiveContent((LCObject)this.instance, (boolean)false);
        out.writeString(this.instance.getClassName());
        out.writeString(archivedContent);
        LOGGER.d("writeToParcel with archivedContent: " + archivedContent);
    }

    public static class LCObjectCreator
    implements Parcelable.Creator<LCParcelableObject> {
        public static LCObjectCreator instance = new LCObjectCreator();

        private LCObjectCreator() {
        }

        public LCParcelableObject createFromParcel(Parcel parcel) {
            String className = parcel.readString();
            String content = parcel.readString();
            LOGGER.d("createFromParcel with archivedContent: " + content + ", className: " + className);
            LCObject rawObject = ArchivedRequests.parseAVObject((String)content);
            return new LCParcelableObject(Transformer.transform((LCObject)rawObject, (String)className));
        }

        public LCParcelableObject[] newArray(int i) {
            return new LCParcelableObject[i];
        }
    }
}

