/*
 * Decompiled with CFR 0.152.
 */
package com.tapsdk.lc;

import android.content.Context;
import android.os.Handler;
import com.tapsdk.lc.LCLogger;
import com.tapsdk.lc.cache.AndroidSystemSetting;
import com.tapsdk.lc.cache.SystemSetting;
import com.tapsdk.lc.callback.LCCallback;
import com.tapsdk.lc.core.AppConfiguration;
import com.tapsdk.lc.core.AppRouter;
import com.tapsdk.lc.core.LeanCloud;
import com.tapsdk.lc.core.RequestPaddingInterceptor;
import com.tapsdk.lc.core.RequestSignature;
import com.tapsdk.lc.internal.ThreadModel;
import com.tapsdk.lc.logging.DefaultLoggerAdapter;
import com.tapsdk.lc.logging.InternalLoggerAdapter;
import com.tapsdk.lc.network.AndroidNetworkingDetector;
import com.tapsdk.lc.network.NetworkingDetector;
import com.tapsdk.lc.sign.NativeSignHelper;
import com.tapsdk.lc.sign.SecureRequestSignature;
import com.tapsdk.lc.util.AndroidMimeTypeDetector;
import com.tapsdk.lc.util.AndroidUtil;
import com.tapsdk.lc.utils.FileUtil;
import com.tapsdk.lc.utils.LogUtil;
import com.tapsdk.lc.utils.StringUtil;
import io.reactivex.Scheduler;
import io.reactivex.android.schedulers.AndroidSchedulers;
import java.lang.reflect.Method;

public class LeanCloud
extends com.tapsdk.lc.core.LeanCloud {
    private static Context context = null;
    protected static Handler handler = null;

    public static Context getContext() {
        return context;
    }

    public static void setContext(Context context) {
        LeanCloud.context = context;
    }

    public static Handler getHandler() {
        return handler;
    }

    public static void initialize(Context context, String appId, String appKey) {
        if (!LeanCloud.hasCustomizedServerURL(appId)) {
            throw new IllegalStateException("Please call AVOSCloud#initialize(context, appid, appkey, serverURL) instead of AVOSCloud#initialize(context, appid, appkey), or call AVOSCloud#setServer(service, host) at first.");
        }
        if (null == handler && !AndroidUtil.isMainThread()) {
            throw new IllegalStateException("Please call AVOSCloud#initialize() in main thread.");
        }
        if (null == handler) {
            handler = new Handler();
        }
        AppConfiguration.setLogAdapter((InternalLoggerAdapter)new DefaultLoggerAdapter());
        AppConfiguration.setGlobalNetworkingDetector((NetworkingDetector)new AndroidNetworkingDetector(context));
        AppConfiguration.setMimeTypeDetector((FileUtil.MimeTypeDetector)new AndroidMimeTypeDetector());
        ThreadModel.MainThreadChecker checker = new ThreadModel.MainThreadChecker(){

            public boolean isMainThread() {
                return AndroidUtil.isMainThread();
            }
        };
        ThreadModel.ThreadShuttle shuttle = new ThreadModel.ThreadShuttle(){

            public void launch(Runnable runnable) {
                LeanCloud.getHandler().post(runnable);
            }
        };
        LCCallback.setMainThreadChecker((ThreadModel.MainThreadChecker)checker, (ThreadModel.ThreadShuttle)shuttle);
        LCLogger logger = LogUtil.getLogger(LeanCloud.class);
        logger.i("[LeanCloud] initialize mainThreadChecker and threadShuttle within AVCallback.");
        String appIdPrefix = StringUtil.isEmpty((String)appId) ? "" : appId.substring(0, 8);
        String importantFileDir = context.getFilesDir().getAbsolutePath();
        String baseDir = context.getCacheDir().getAbsolutePath();
        String documentDir = context.getDir(appIdPrefix + "Paas", 0).getAbsolutePath();
        String fileCacheDir = baseDir + "/" + appIdPrefix + "avfile";
        String commandCacheDir = baseDir + "/" + appIdPrefix + "CommandCache";
        String analyticsDir = baseDir + "/" + appIdPrefix + "Analysis";
        String queryResultCacheDir = baseDir + "/" + appIdPrefix + "PaasKeyValueCache";
        AndroidSystemSetting defaultSetting = new AndroidSystemSetting(context);
        AppConfiguration.configCacheSettings((String)importantFileDir, (String)documentDir, (String)fileCacheDir, (String)queryResultCacheDir, (String)commandCacheDir, (String)analyticsDir, (SystemSetting)defaultSetting);
        AppConfiguration.setApplicationPackageName((String)context.getPackageName());
        logger.d("docDir=" + documentDir + ", fileDir=" + fileCacheDir + ", cmdDir=" + commandCacheDir + ", statDir=" + analyticsDir);
        AppConfiguration.config((boolean)true, (AppConfiguration.SchedulerCreator)new AppConfiguration.SchedulerCreator(){

            public Scheduler create() {
                return AndroidSchedulers.mainThread();
            }
        });
        com.tapsdk.lc.core.LeanCloud.initialize((String)appId, (String)appKey);
        try {
            Class<?> androidInit = context.getClassLoader().loadClass("com.tapsdk.lc.im.AndroidInitializer");
            Method initMethod = androidInit.getDeclaredMethod("init", Context.class);
            initMethod.invoke(null, context);
            logger.d("succeed to call com.tapsdk.storage.im.AndroidInitializer#init(Context)");
        }
        catch (ClassNotFoundException ex) {
            logger.d("not found class: com.tapsdk.storage.im.AndroidInitializer.");
        }
        catch (NoSuchMethodException ex) {
            logger.d("invalid AndroidInitializer, init(Context) method not found.");
        }
        catch (Exception ex) {
            logger.d("failed to call AndroidInitializer#init(Context), cause:" + ex.getMessage());
        }
        LeanCloud.setContext(context);
    }

    public static void initialize(Context context, String appId, String appKey, String serverURL) {
        LeanCloud.setServerURLs((String)serverURL);
        LeanCloud.initialize(context, appId, appKey);
    }

    public static void initializeSecurely(Context context, String appId, String serverURL) {
        LeanCloud.setServerURLs((String)serverURL);
        NativeSignHelper.initialize(context);
        RequestPaddingInterceptor.changeRequestSignature((RequestSignature)new SecureRequestSignature());
        LeanCloud.initialize(context, appId, null);
    }

    protected static boolean hasCustomizedServerURL(String applicationId) {
        LeanCloud.REGION region = AppRouter.getAppRegion((String)applicationId);
        if (LeanCloud.REGION.NorthAmerica == region || LeanCloud.REGION.NorthAmerica == LeanCloud.getRegion()) {
            return true;
        }
        return AppRouter.getInstance().hasFrozenEndpoint();
    }
}

