/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.flowlayout;

import android.util.Log;
import android.view.View;
import com.taptap.sdk.flowlayout.FlowLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class TagAdapter<T> {
    private List<T> mTagDatas;
    private OnDataChangedListener mOnDataChangedListener;
    @Deprecated
    private HashSet<Integer> mCheckedPosList = new HashSet();

    public TagAdapter(List<T> datas) {
        this.mTagDatas = datas;
    }

    @Deprecated
    public TagAdapter(T[] datas) {
        this.mTagDatas = new ArrayList<T>(Arrays.asList(datas));
    }

    public void setOnDataChangedListener(OnDataChangedListener listener) {
        this.mOnDataChangedListener = listener;
    }

    @Deprecated
    public void setSelectedList(int ... poses) {
        HashSet<Integer> set = new HashSet<Integer>();
        for (int pos : poses) {
            set.add(pos);
        }
        this.setSelectedList(set);
    }

    @Deprecated
    public void setSelectedList(Set<Integer> set) {
        this.mCheckedPosList.clear();
        if (set != null) {
            this.mCheckedPosList.addAll(set);
        }
        this.notifyDataChanged();
    }

    @Deprecated
    public HashSet<Integer> getPreCheckedList() {
        return this.mCheckedPosList;
    }

    public int getCount() {
        return this.mTagDatas == null ? 0 : this.mTagDatas.size();
    }

    public void notifyDataChanged() {
        if (this.mOnDataChangedListener != null) {
            this.mOnDataChangedListener.onChanged();
        }
    }

    public T getItem(int position) {
        return this.mTagDatas.get(position);
    }

    public abstract View getView(FlowLayout var1, int var2, T var3);

    public void onSelected(int position, View view) {
        Log.d((String)"zhy", (String)("onSelected " + position));
    }

    public void unSelected(int position, View view) {
        Log.d((String)"zhy", (String)("unSelected " + position));
    }

    public boolean setSelected(int position, T t) {
        return false;
    }

    static interface OnDataChangedListener {
        public void onChanged();
    }
}

