/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.flowlayout;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import com.taptap.sdk.flowlayout.FlowLayout;
import com.taptap.sdk.flowlayout.R;
import com.taptap.sdk.flowlayout.TagAdapter;
import com.taptap.sdk.flowlayout.TagView;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class TagFlowLayout
extends FlowLayout
implements TagAdapter.OnDataChangedListener {
    private TagAdapter mTagAdapter;
    private int mSelectedMax = -1;
    private static final String TAG = "TagFlowLayout";
    private Set<Integer> mSelectedView = new HashSet<Integer>();
    private OnSelectListener mOnSelectListener;
    private OnTagClickListener mOnTagClickListener;
    private static final String KEY_CHOOSE_POS = "key_choose_pos";
    private static final String KEY_DEFAULT = "key_default";

    public TagFlowLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.TagFlowLayout);
        this.mSelectedMax = ta.getInt(R.styleable.TagFlowLayout_max_select, -1);
        ta.recycle();
    }

    public TagFlowLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TagFlowLayout(Context context) {
        this(context, null);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int cCount = this.getChildCount();
        for (int i = 0; i < cCount; ++i) {
            TagView tagView = (TagView)this.getChildAt(i);
            if (tagView.getVisibility() == 8 || tagView.getTagView().getVisibility() != 8) continue;
            tagView.setVisibility(8);
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    public void setOnSelectListener(OnSelectListener onSelectListener) {
        this.mOnSelectListener = onSelectListener;
    }

    public void setOnTagClickListener(OnTagClickListener onTagClickListener) {
        this.mOnTagClickListener = onTagClickListener;
    }

    public void setAdapter(TagAdapter adapter) {
        this.mTagAdapter = adapter;
        this.mTagAdapter.setOnDataChangedListener(this);
        this.mSelectedView.clear();
        this.changeAdapter();
    }

    private void changeAdapter() {
        this.removeAllViews();
        TagAdapter adapter = this.mTagAdapter;
        TagView tagViewContainer = null;
        HashSet<Integer> preCheckedList = this.mTagAdapter.getPreCheckedList();
        int i = 0;
        while (i < adapter.getCount()) {
            ViewGroup.MarginLayoutParams lp;
            View tagView = adapter.getView(this, i, adapter.getItem(i));
            tagViewContainer = new TagView(this.getContext());
            tagView.setDuplicateParentStateEnabled(true);
            if (tagView.getLayoutParams() != null) {
                tagViewContainer.setLayoutParams(tagView.getLayoutParams());
            } else {
                lp = new ViewGroup.MarginLayoutParams(-2, -2);
                lp.setMargins(TagFlowLayout.dip2px(this.getContext(), 5.0f), TagFlowLayout.dip2px(this.getContext(), 5.0f), TagFlowLayout.dip2px(this.getContext(), 5.0f), TagFlowLayout.dip2px(this.getContext(), 5.0f));
                tagViewContainer.setLayoutParams((ViewGroup.LayoutParams)lp);
            }
            lp = new ViewGroup.LayoutParams(-1, -1);
            tagView.setLayoutParams((ViewGroup.LayoutParams)lp);
            tagViewContainer.addView(tagView);
            this.addView((View)tagViewContainer);
            if (preCheckedList.contains(i)) {
                this.setChildChecked(i, tagViewContainer);
            }
            if (this.mTagAdapter.setSelected(i, adapter.getItem(i))) {
                this.setChildChecked(i, tagViewContainer);
            }
            tagView.setClickable(false);
            final TagView finalTagViewContainer = tagViewContainer;
            final int position = i++;
            tagViewContainer.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    TagFlowLayout.this.doSelect(finalTagViewContainer, position);
                    if (TagFlowLayout.this.mOnTagClickListener != null) {
                        TagFlowLayout.this.mOnTagClickListener.onTagClick((View)finalTagViewContainer, position, TagFlowLayout.this);
                    }
                }
            });
        }
        this.mSelectedView.addAll(preCheckedList);
    }

    public void setMaxSelectCount(int count) {
        if (this.mSelectedView.size() > count) {
            Log.w((String)TAG, (String)("you has already select more than " + count + " views , so it will be clear ."));
            this.mSelectedView.clear();
        }
        this.mSelectedMax = count;
    }

    public Set<Integer> getSelectedList() {
        return new HashSet<Integer>(this.mSelectedView);
    }

    private void setChildChecked(int position, TagView view) {
        view.setChecked(true);
        this.mTagAdapter.onSelected(position, view.getTagView());
    }

    private void setChildUnChecked(int position, TagView view) {
        view.setChecked(false);
        this.mTagAdapter.unSelected(position, view.getTagView());
    }

    private void doSelect(TagView child, int position) {
        if (!child.isChecked()) {
            if (this.mSelectedMax == 1 && this.mSelectedView.size() == 1) {
                Iterator<Integer> iterator = this.mSelectedView.iterator();
                Integer preIndex = iterator.next();
                TagView pre = (TagView)this.getChildAt(preIndex);
                this.setChildUnChecked(preIndex, pre);
                this.setChildChecked(position, child);
                this.mSelectedView.remove(preIndex);
                this.mSelectedView.add(position);
            } else {
                if (this.mSelectedMax > 0 && this.mSelectedView.size() >= this.mSelectedMax) {
                    return;
                }
                this.setChildChecked(position, child);
                this.mSelectedView.add(position);
            }
        } else {
            this.setChildUnChecked(position, child);
            this.mSelectedView.remove(position);
        }
        if (this.mOnSelectListener != null) {
            this.mOnSelectListener.onSelected(new HashSet<Integer>(this.mSelectedView));
        }
    }

    public TagAdapter getAdapter() {
        return this.mTagAdapter;
    }

    protected Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable(KEY_DEFAULT, super.onSaveInstanceState());
        String selectPos = "";
        if (this.mSelectedView.size() > 0) {
            for (int key : this.mSelectedView) {
                selectPos = selectPos + key + "|";
            }
            selectPos = selectPos.substring(0, selectPos.length() - 1);
        }
        bundle.putString(KEY_CHOOSE_POS, selectPos);
        return bundle;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            String mSelectPos = bundle.getString(KEY_CHOOSE_POS);
            if (!TextUtils.isEmpty((CharSequence)mSelectPos)) {
                String[] split;
                for (String pos : split = mSelectPos.split("\\|")) {
                    int index = Integer.parseInt(pos);
                    this.mSelectedView.add(index);
                    TagView tagView = (TagView)this.getChildAt(index);
                    if (tagView == null) continue;
                    this.setChildChecked(index, tagView);
                }
            }
            super.onRestoreInstanceState(bundle.getParcelable(KEY_DEFAULT));
            return;
        }
        super.onRestoreInstanceState(state);
    }

    @Override
    public void onChanged() {
        this.mSelectedView.clear();
        this.changeAdapter();
    }

    public static int dip2px(Context context, float dpValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public static interface OnTagClickListener {
        public boolean onTagClick(View var1, int var2, FlowLayout var3);
    }

    public static interface OnSelectListener {
        public void onSelected(Set<Integer> var1);
    }
}

