/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.retrofit2;

import com.taptap.sdk.retrofit2.Response;
import java.util.Objects;
import javax.annotation.Nullable;

public class HttpException
extends RuntimeException {
    private final int code;
    private final String message;
    private final transient Response<?> response;

    private static String getMessage(Response<?> response) {
        Objects.requireNonNull(response, "response == null");
        return "HTTP " + response.code() + " " + response.message();
    }

    public HttpException(Response<?> response) {
        super(HttpException.getMessage(response));
        this.code = response.code();
        this.message = response.message();
        this.response = response;
    }

    public int code() {
        return this.code;
    }

    public String message() {
        return this.message;
    }

    @Nullable
    public Response<?> response() {
        return this.response;
    }
}

