/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.retrofit2;

import com.taptap.sdk.okhttp3.Call;
import com.taptap.sdk.okhttp3.ResponseBody;
import com.taptap.sdk.retrofit2.Call;
import com.taptap.sdk.retrofit2.CallAdapter;
import com.taptap.sdk.retrofit2.Converter;
import com.taptap.sdk.retrofit2.KotlinExtensions;
import com.taptap.sdk.retrofit2.OkHttpCall;
import com.taptap.sdk.retrofit2.RequestFactory;
import com.taptap.sdk.retrofit2.Response;
import com.taptap.sdk.retrofit2.Retrofit;
import com.taptap.sdk.retrofit2.ServiceMethod;
import com.taptap.sdk.retrofit2.SkipCallbackExecutorImpl;
import com.taptap.sdk.retrofit2.Utils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.annotation.Nullable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

abstract class HttpServiceMethod<ResponseT, ReturnT>
extends ServiceMethod<ReturnT> {
    private final RequestFactory requestFactory;
    private final Call.Factory callFactory;
    private final Converter<ResponseBody, ResponseT> responseConverter;

    static <ResponseT, ReturnT> HttpServiceMethod<ResponseT, ReturnT> parseAnnotations(Retrofit retrofit, Method method, RequestFactory requestFactory) {
        Type adapterType;
        Type responseType;
        boolean isKotlinSuspendFunction = requestFactory.isKotlinSuspendFunction;
        boolean continuationWantsResponse = false;
        boolean continuationBodyNullable = false;
        boolean continuationIsUnit = false;
        Annotation[] annotations = method.getAnnotations();
        if (isKotlinSuspendFunction) {
            Type[] parameterTypes = method.getGenericParameterTypes();
            responseType = Utils.getParameterLowerBound(0, (ParameterizedType)parameterTypes[parameterTypes.length - 1]);
            if (Utils.getRawType(responseType) == Response.class && responseType instanceof ParameterizedType) {
                responseType = Utils.getParameterUpperBound(0, (ParameterizedType)responseType);
                continuationWantsResponse = true;
            } else {
                if (Utils.getRawType(responseType) == Call.class) {
                    throw Utils.methodError(method, "Suspend functions should not return Call, as they already execute asynchronously.\nChange its return type to %s", Utils.getParameterUpperBound(0, (ParameterizedType)responseType));
                }
                continuationIsUnit = Utils.isUnit(responseType);
            }
            adapterType = new Utils.ParameterizedTypeImpl(null, (Type)((Object)Call.class), responseType);
            annotations = SkipCallbackExecutorImpl.ensurePresent(annotations);
        } else {
            adapterType = method.getGenericReturnType();
        }
        CallAdapter<ResponseT, ReturnT> callAdapter = HttpServiceMethod.createCallAdapter(retrofit, method, adapterType, annotations);
        responseType = callAdapter.responseType();
        if (responseType == com.taptap.sdk.okhttp3.Response.class) {
            throw Utils.methodError(method, "'" + Utils.getRawType(responseType).getName() + "' is not a valid response body type. Did you mean ResponseBody?", new Object[0]);
        }
        if (responseType == Response.class) {
            throw Utils.methodError(method, "Response must include generic type (e.g., Response<String>)", new Object[0]);
        }
        if (requestFactory.httpMethod.equals("HEAD") && !Void.class.equals((Object)responseType) && !Utils.isUnit(responseType)) {
            throw Utils.methodError(method, "HEAD method must use Void or Unit as response type.", new Object[0]);
        }
        Converter<ResponseBody, ResponseT> responseConverter = HttpServiceMethod.createResponseConverter(retrofit, method, responseType);
        Call.Factory callFactory = retrofit.callFactory;
        if (!isKotlinSuspendFunction) {
            return new CallAdapted<ResponseT, ReturnT>(requestFactory, callFactory, responseConverter, callAdapter);
        }
        if (continuationWantsResponse) {
            return new SuspendForResponse<ResponseT>(requestFactory, callFactory, responseConverter, callAdapter);
        }
        return new SuspendForBody<ResponseT>(requestFactory, callFactory, responseConverter, callAdapter, continuationBodyNullable, continuationIsUnit);
    }

    private static <ResponseT, ReturnT> CallAdapter<ResponseT, ReturnT> createCallAdapter(Retrofit retrofit, Method method, Type returnType, Annotation[] annotations) {
        try {
            return retrofit.callAdapter(returnType, annotations);
        }
        catch (RuntimeException e) {
            throw Utils.methodError(method, e, "Unable to create call adapter for %s", returnType);
        }
    }

    private static <ResponseT> Converter<ResponseBody, ResponseT> createResponseConverter(Retrofit retrofit, Method method, Type responseType) {
        Annotation[] annotations = method.getAnnotations();
        try {
            return retrofit.responseBodyConverter(responseType, annotations);
        }
        catch (RuntimeException e) {
            throw Utils.methodError(method, e, "Unable to create converter for %s", responseType);
        }
    }

    HttpServiceMethod(RequestFactory requestFactory, Call.Factory callFactory, Converter<ResponseBody, ResponseT> responseConverter) {
        this.requestFactory = requestFactory;
        this.callFactory = callFactory;
        this.responseConverter = responseConverter;
    }

    @Override
    @Nullable
    final ReturnT invoke(Object instance, Object[] args) {
        OkHttpCall<ResponseT> call = new OkHttpCall<ResponseT>(this.requestFactory, instance, args, this.callFactory, this.responseConverter);
        return this.adapt(call, args);
    }

    @Nullable
    protected abstract ReturnT adapt(Call<ResponseT> var1, Object[] var2);

    static final class SuspendForBody<ResponseT>
    extends HttpServiceMethod<ResponseT, Object> {
        private final CallAdapter<ResponseT, Call<ResponseT>> callAdapter;
        private final boolean isNullable;
        private final boolean isUnit;

        SuspendForBody(RequestFactory requestFactory, Call.Factory callFactory, Converter<ResponseBody, ResponseT> responseConverter, CallAdapter<ResponseT, Call<ResponseT>> callAdapter, boolean isNullable, boolean isUnit) {
            super(requestFactory, callFactory, responseConverter);
            this.callAdapter = callAdapter;
            this.isNullable = isNullable;
            this.isUnit = isUnit;
        }

        @Override
        protected Object adapt(Call<ResponseT> call, Object[] args) {
            call = this.callAdapter.adapt(call);
            Continuation continuation = (Continuation)args[args.length - 1];
            try {
                if (this.isUnit) {
                    return KotlinExtensions.awaitUnit(call, (Continuation<? super Unit>)continuation);
                }
                if (this.isNullable) {
                    return KotlinExtensions.awaitNullable(call, continuation);
                }
                return KotlinExtensions.await(call, continuation);
            }
            catch (LinkageError | ThreadDeath | VirtualMachineError e) {
                throw e;
            }
            catch (Throwable e) {
                return KotlinExtensions.suspendAndThrow(e, continuation);
            }
        }
    }

    static final class SuspendForResponse<ResponseT>
    extends HttpServiceMethod<ResponseT, Object> {
        private final CallAdapter<ResponseT, Call<ResponseT>> callAdapter;

        SuspendForResponse(RequestFactory requestFactory, Call.Factory callFactory, Converter<ResponseBody, ResponseT> responseConverter, CallAdapter<ResponseT, Call<ResponseT>> callAdapter) {
            super(requestFactory, callFactory, responseConverter);
            this.callAdapter = callAdapter;
        }

        @Override
        protected Object adapt(Call<ResponseT> call, Object[] args) {
            call = this.callAdapter.adapt(call);
            Continuation continuation = (Continuation)args[args.length - 1];
            try {
                return KotlinExtensions.awaitResponse(call, continuation);
            }
            catch (Exception e) {
                return KotlinExtensions.suspendAndThrow(e, continuation);
            }
        }
    }

    static final class CallAdapted<ResponseT, ReturnT>
    extends HttpServiceMethod<ResponseT, ReturnT> {
        private final CallAdapter<ResponseT, ReturnT> callAdapter;

        CallAdapted(RequestFactory requestFactory, Call.Factory callFactory, Converter<ResponseBody, ResponseT> responseConverter, CallAdapter<ResponseT, ReturnT> callAdapter) {
            super(requestFactory, callFactory, responseConverter);
            this.callAdapter = callAdapter;
        }

        @Override
        protected ReturnT adapt(Call<ResponseT> call, Object[] args) {
            return this.callAdapter.adapt(call);
        }
    }
}

