/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.retrofit2;

import com.taptap.sdk.retrofit2.HttpServiceMethod;
import com.taptap.sdk.retrofit2.RequestFactory;
import com.taptap.sdk.retrofit2.Retrofit;
import com.taptap.sdk.retrofit2.Utils;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import javax.annotation.Nullable;

abstract class ServiceMethod<T> {
    ServiceMethod() {
    }

    static <T> ServiceMethod<T> parseAnnotations(Retrofit retrofit, Class<?> service, Method method) {
        RequestFactory requestFactory = RequestFactory.parseAnnotations(retrofit, service, method);
        Type returnType = method.getGenericReturnType();
        if (Utils.hasUnresolvableType(returnType)) {
            throw Utils.methodError(method, "Method return type must not include a type variable or wildcard: %s", returnType);
        }
        if (returnType == Void.TYPE) {
            throw Utils.methodError(method, "Service methods cannot return void.", new Object[0]);
        }
        return HttpServiceMethod.parseAnnotations(retrofit, method, requestFactory);
    }

    @Nullable
    abstract T invoke(Object var1, Object[] var2);
}

