/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.base.utils.lifecycle;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import com.taptap.sdk.base.utils.lifecycle.TapActivityLifecycleCallbacks;
import com.taptap.sdk.base.utils.lifecycle.TapActivityUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joor.Reflect;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u0014H\u0002\u00a2\u0006\u0002\u0010\u0015J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\f0\u0017H\u0002J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u0017H\u0002J\n\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u0002J\n\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u0002J\n\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u0002J\n\u0010\u001c\u001a\u0004\u0018\u00010\fH\u0007J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 J\u0006\u0010!\u001a\u00020\u0011J\u000e\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\tJ\u0010\u0010$\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\fH\u0002J\u000e\u0010&\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\tJ\u001a\u0010'\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0001\u0018\u00010(*\u00020\u0001H\u0002J\u000e\u0010)\u001a\u0004\u0018\u00010\f*\u00020\u0001H\u0002J\f\u0010*\u001a\u00020\u0011*\u00020\u0001H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/taptap/sdk/base/utils/lifecycle/TapActivityLifecycleTracker;", "", "()V", "DEFAULT_CALLBACKS", "Landroid/app/Application$ActivityLifecycleCallbacks;", "TAG", "", "activityLifecycleCallbacks", "", "Lcom/taptap/sdk/base/utils/lifecycle/TapActivityLifecycleCallbacks;", "activityList", "Ljava/util/LinkedList;", "Landroid/app/Activity;", "configCount", "", "foregroundCount", "isBackground", "", "isInitialized", "collectActivityLifecycleCallbacks", "", "()[Lcom/taptap/sdk/base/utils/lifecycle/TapActivityLifecycleCallbacks;", "getActivitiesByReflect", "", "getActivityList", "getActivityThread", "getActivityThreadInActivityThreadStaticField", "getActivityThreadInActivityThreadStaticMethod", "getTopActivity", "initialize", "", "context", "Landroid/content/Context;", "isAppForeground", "registerActivityLifecycleCallbacks", "callback", "setTopActivity", "activity", "unregisterActivityLifecycleCallbacks", "getActivitiesField", "", "getActivityField", "getActivityPausedField", "tap-base_release"})
public final class TapActivityLifecycleTracker {
    @NotNull
    public static final TapActivityLifecycleTracker INSTANCE = new TapActivityLifecycleTracker();
    @NotNull
    private static final String TAG = "ActivityLifecycle";
    private static boolean isInitialized;
    @NotNull
    private static final List<TapActivityLifecycleCallbacks> activityLifecycleCallbacks;
    @NotNull
    private static final LinkedList<Activity> activityList;
    private static int foregroundCount;
    private static int configCount;
    private static boolean isBackground;
    @NotNull
    private static final Application.ActivityLifecycleCallbacks DEFAULT_CALLBACKS;

    private TapActivityLifecycleTracker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void initialize(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        TapActivityLifecycleTracker tapActivityLifecycleTracker = this;
        synchronized (tapActivityLifecycleTracker) {
            Unit unit;
            boolean bl = false;
            if (isInitialized) {
                Log.d((String)TAG, (String)"TapActivityLifecycleTracker already initialized, skipping.");
                return;
            }
            isInitialized = true;
            Log.d((String)TAG, (String)"Initializing TapActivityLifecycleTracker");
            Application application = context instanceof Application ? (Application)context : null;
            if (application != null) {
                Application application2 = application;
                boolean bl2 = false;
                application2.registerActivityLifecycleCallbacks(DEFAULT_CALLBACKS);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Unit unit2 = unit;
        }
    }

    public final boolean isAppForeground() {
        return !isBackground;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerActivityLifecycleCallbacks(@NotNull TapActivityLifecycleCallbacks callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        List<TapActivityLifecycleCallbacks> list = activityLifecycleCallbacks;
        synchronized (list) {
            boolean bl = false;
            if (!activityLifecycleCallbacks.contains(callback)) {
                activityLifecycleCallbacks.add(callback);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unregisterActivityLifecycleCallbacks(@NotNull TapActivityLifecycleCallbacks callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        List<TapActivityLifecycleCallbacks> list = activityLifecycleCallbacks;
        synchronized (list) {
            boolean bl = false;
            boolean bl2 = activityLifecycleCallbacks.remove(callback);
        }
    }

    @JvmStatic
    @Nullable
    public static final Activity getTopActivity() {
        List<Activity> activityList = INSTANCE.getActivityList();
        for (Activity activity : activityList) {
            if (!TapActivityUtils.INSTANCE.isActivityAlive(activity)) continue;
            return activity;
        }
        return null;
    }

    private final void setTopActivity(Activity activity) {
        if (activityList.contains(activity)) {
            if (!activityList.getFirst().equals((Object)activity)) {
                activityList.remove(activity);
                activityList.addFirst(activity);
            }
        } else {
            activityList.addFirst(activity);
        }
    }

    private final List<Activity> getActivityList() {
        if (!activityList.isEmpty()) {
            return new LinkedList(activityList);
        }
        List<Activity> reflectActivities = this.getActivitiesByReflect();
        activityList.addAll((Collection<Activity>)reflectActivities);
        return new LinkedList(activityList);
    }

    private final List<Activity> getActivitiesByReflect() {
        LinkedList<Activity> list;
        block8: {
            list = new LinkedList<Activity>();
            Activity topActivity = null;
            try {
                Map<Object, Object> mActivities;
                Object object = this.getActivityThread();
                if (object == null) {
                    return list;
                }
                Object activityThread = object;
                Map<Object, Object> map = this.getActivitiesField(activityThread);
                if (map == null) {
                    return list;
                }
                Map<Object, Object> $this$forEach$iv = mActivities = map;
                boolean $i$f$forEach = false;
                Iterator<Map.Entry<Object, Object>> iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Activity it;
                    Map.Entry<Object, Object> element$iv;
                    Map.Entry<Object, Object> entry = element$iv = iterator.next();
                    boolean bl = false;
                    Object activityRecord = entry.getValue();
                    Activity activity = INSTANCE.getActivityField(activityRecord);
                    if (topActivity == null) {
                        boolean paused = INSTANCE.getActivityPausedField(activityRecord);
                        if (!paused) {
                            topActivity = activity;
                            continue;
                        }
                        if (activity != null) {
                            Activity it2;
                            boolean bl2 = false;
                            list.addFirst(it2);
                        }
                        continue;
                    }
                    if (activity == null) continue;
                    boolean bl3 = false;
                    list.addFirst(it);
                }
            }
            catch (Exception e) {
                Log.d((String)TAG, (String)"getActivitiesByReflect", (Throwable)e);
            }
            Activity activity = topActivity;
            if (activity == null) break block8;
            Activity it = activity;
            boolean bl = false;
            list.addFirst(it);
        }
        return list;
    }

    private final Object getActivityThread() {
        Object activityThread = this.getActivityThreadInActivityThreadStaticField();
        if (activityThread != null) {
            return activityThread;
        }
        return this.getActivityThreadInActivityThreadStaticMethod();
    }

    private final Map<Object, Object> getActivitiesField(Object $this$getActivitiesField) {
        return (Map)Reflect.on((Object)$this$getActivitiesField).field("mActivities").get();
    }

    private final Activity getActivityField(Object $this$getActivityField) {
        return (Activity)Reflect.on((Object)$this$getActivityField).field("activity").get();
    }

    private final boolean getActivityPausedField(Object $this$getActivityPausedField) {
        Object object = Reflect.on((Object)$this$getActivityPausedField).field("paused").get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"on(this)\n            .fi\u2026used\")\n            .get()");
        return (Boolean)object;
    }

    private final Object getActivityThreadInActivityThreadStaticField() {
        try {
            return Reflect.onClass((String)"android.app.ActivityThread").field("sCurrentActivityThread").get();
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)"getActivityThreadInActivityThreadStaticField: ", (Throwable)e);
            return null;
        }
    }

    private final Object getActivityThreadInActivityThreadStaticMethod() {
        try {
            return Reflect.onClass((String)"android.app.ActivityThread").call("currentActivityThread").get();
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)"getActivityThreadInActivityThreadStaticMethod: ", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final TapActivityLifecycleCallbacks[] collectActivityLifecycleCallbacks() {
        TapActivityLifecycleCallbacks[] callbacks = null;
        List<TapActivityLifecycleCallbacks> list = activityLifecycleCallbacks;
        synchronized (list) {
            boolean bl = false;
            if (!((Collection)activityLifecycleCallbacks).isEmpty()) {
                Collection $this$toTypedArray$iv = activityLifecycleCallbacks;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                callbacks = thisCollection$iv.toArray(new TapActivityLifecycleCallbacks[0]);
            }
            Unit unit = Unit.INSTANCE;
        }
        return callbacks;
    }

    public static final /* synthetic */ void access$setTopActivity(TapActivityLifecycleTracker $this, Activity activity) {
        $this.setTopActivity(activity);
    }

    public static final /* synthetic */ TapActivityLifecycleCallbacks[] access$collectActivityLifecycleCallbacks(TapActivityLifecycleTracker $this) {
        return $this.collectActivityLifecycleCallbacks();
    }

    public static final /* synthetic */ boolean access$isBackground$p() {
        return isBackground;
    }

    public static final /* synthetic */ int access$getConfigCount$p() {
        return configCount;
    }

    public static final /* synthetic */ void access$setConfigCount$p(int n) {
        configCount = n;
    }

    public static final /* synthetic */ void access$setForegroundCount$p(int n) {
        foregroundCount = n;
    }

    public static final /* synthetic */ int access$getForegroundCount$p() {
        return foregroundCount;
    }

    public static final /* synthetic */ void access$setBackground$p(boolean bl) {
        isBackground = bl;
    }

    public static final /* synthetic */ LinkedList access$getActivityList$p() {
        return activityList;
    }

    static {
        activityLifecycleCallbacks = new ArrayList();
        activityList = new LinkedList();
        DEFAULT_CALLBACKS = new Application.ActivityLifecycleCallbacks(){

            public void onActivityCreated(@NotNull Activity activity, @Nullable Bundle savedInstanceState) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                    Log.d((String)"ActivityLifecycle", (String)("onActivityCreated [" + activity.getClass().getName() + ']'));
                    TapActivityLifecycleTracker.access$setTopActivity(TapActivityLifecycleTracker.INSTANCE, activity);
                    TapActivityLifecycleCallbacks[] tapActivityLifecycleCallbacksArray = TapActivityLifecycleTracker.access$collectActivityLifecycleCallbacks(TapActivityLifecycleTracker.INSTANCE);
                    if (tapActivityLifecycleCallbacksArray == null) break block1;
                    TapActivityLifecycleCallbacks[] $this$forEach$iv = tapActivityLifecycleCallbacksArray;
                    boolean $i$f$forEach = false;
                    int n = $this$forEach$iv.length;
                    for (int i = 0; i < n; ++i) {
                        TapActivityLifecycleCallbacks element$iv;
                        TapActivityLifecycleCallbacks it = element$iv = $this$forEach$iv[i];
                        boolean bl = false;
                        it.onActivityCreated(activity, savedInstanceState);
                    }
                }
            }

            public void onActivityStarted(@NotNull Activity activity) {
                block4: {
                    Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                    Log.d((String)"ActivityLifecycle", (String)("onActivityStarted [" + activity.getClass().getName() + ']'));
                    if (!TapActivityLifecycleTracker.access$isBackground$p()) {
                        TapActivityLifecycleTracker.access$setTopActivity(TapActivityLifecycleTracker.INSTANCE, activity);
                    }
                    if (TapActivityLifecycleTracker.access$getConfigCount$p() < 0) {
                        TapActivityLifecycleTracker.access$setConfigCount$p(TapActivityLifecycleTracker.INSTANCE.access$getConfigCount$p() + 1);
                        TapActivityLifecycleTracker.access$getConfigCount$p();
                    } else {
                        TapActivityLifecycleTracker.access$setForegroundCount$p(TapActivityLifecycleTracker.INSTANCE.access$getForegroundCount$p() + 1);
                        TapActivityLifecycleTracker.access$getForegroundCount$p();
                    }
                    TapActivityLifecycleCallbacks[] tapActivityLifecycleCallbacksArray = TapActivityLifecycleTracker.access$collectActivityLifecycleCallbacks(TapActivityLifecycleTracker.INSTANCE);
                    if (tapActivityLifecycleCallbacksArray == null) break block4;
                    TapActivityLifecycleCallbacks[] $this$forEach$iv = tapActivityLifecycleCallbacksArray;
                    boolean $i$f$forEach = false;
                    int n = $this$forEach$iv.length;
                    for (int i = 0; i < n; ++i) {
                        TapActivityLifecycleCallbacks element$iv;
                        TapActivityLifecycleCallbacks it = element$iv = $this$forEach$iv[i];
                        boolean bl = false;
                        it.onActivityStarted(activity);
                    }
                }
            }

            public void onActivityResumed(@NotNull Activity activity) {
                block4: {
                    TapActivityLifecycleCallbacks it;
                    TapActivityLifecycleCallbacks element$iv;
                    int n;
                    int n2;
                    boolean $i$f$forEach;
                    TapActivityLifecycleCallbacks[] $this$forEach$iv;
                    Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                    Log.d((String)"ActivityLifecycle", (String)("onActivityResumed [" + activity.getClass().getName() + ']'));
                    TapActivityLifecycleTracker.access$setTopActivity(TapActivityLifecycleTracker.INSTANCE, activity);
                    if (TapActivityLifecycleTracker.access$isBackground$p()) {
                        Log.d((String)"ActivityLifecycle", (String)"App onForeground");
                        TapActivityLifecycleTracker.access$setBackground$p(false);
                        TapActivityLifecycleCallbacks[] tapActivityLifecycleCallbacksArray = TapActivityLifecycleTracker.access$collectActivityLifecycleCallbacks(TapActivityLifecycleTracker.INSTANCE);
                        if (tapActivityLifecycleCallbacksArray != null) {
                            $this$forEach$iv = tapActivityLifecycleCallbacksArray;
                            $i$f$forEach = false;
                            n2 = $this$forEach$iv.length;
                            for (n = 0; n < n2; ++n) {
                                it = element$iv = $this$forEach$iv[n];
                                boolean bl = false;
                                it.onForeground((Context)activity);
                            }
                        }
                    }
                    TapActivityLifecycleCallbacks[] tapActivityLifecycleCallbacksArray = TapActivityLifecycleTracker.access$collectActivityLifecycleCallbacks(TapActivityLifecycleTracker.INSTANCE);
                    if (tapActivityLifecycleCallbacksArray == null) break block4;
                    $this$forEach$iv = tapActivityLifecycleCallbacksArray;
                    $i$f$forEach = false;
                    n2 = $this$forEach$iv.length;
                    for (n = 0; n < n2; ++n) {
                        it = element$iv = $this$forEach$iv[n];
                        boolean bl = false;
                        it.onActivityResumed(activity);
                    }
                }
            }

            public void onActivityPaused(@NotNull Activity activity) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                    Log.d((String)"ActivityLifecycle", (String)("onActivityPaused [" + activity.getClass().getName() + ']'));
                    TapActivityLifecycleCallbacks[] tapActivityLifecycleCallbacksArray = TapActivityLifecycleTracker.access$collectActivityLifecycleCallbacks(TapActivityLifecycleTracker.INSTANCE);
                    if (tapActivityLifecycleCallbacksArray == null) break block1;
                    TapActivityLifecycleCallbacks[] $this$forEach$iv = tapActivityLifecycleCallbacksArray;
                    boolean $i$f$forEach = false;
                    int n = $this$forEach$iv.length;
                    for (int i = 0; i < n; ++i) {
                        TapActivityLifecycleCallbacks element$iv;
                        TapActivityLifecycleCallbacks it = element$iv = $this$forEach$iv[i];
                        boolean bl = false;
                        it.onActivityPaused(activity);
                    }
                }
            }

            public void onActivityStopped(@NotNull Activity activity) {
                block6: {
                    TapActivityLifecycleCallbacks it;
                    TapActivityLifecycleCallbacks element$iv;
                    int n;
                    int n2;
                    boolean $i$f$forEach;
                    TapActivityLifecycleCallbacks[] $this$forEach$iv;
                    Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                    Log.d((String)"ActivityLifecycle", (String)("onActivityStopped [" + activity.getClass().getName() + ']'));
                    if (activity.isChangingConfigurations()) {
                        TapActivityLifecycleTracker.access$setConfigCount$p(TapActivityLifecycleTracker.INSTANCE.access$getConfigCount$p() + -1);
                        TapActivityLifecycleTracker.access$getConfigCount$p();
                    } else {
                        TapActivityLifecycleTracker.access$setForegroundCount$p(TapActivityLifecycleTracker.INSTANCE.access$getForegroundCount$p() + -1);
                        TapActivityLifecycleTracker.access$getForegroundCount$p();
                        if (TapActivityLifecycleTracker.access$getForegroundCount$p() <= 0) {
                            TapActivityLifecycleTracker.access$setBackground$p(true);
                            TapActivityLifecycleCallbacks[] tapActivityLifecycleCallbacksArray = TapActivityLifecycleTracker.access$collectActivityLifecycleCallbacks(TapActivityLifecycleTracker.INSTANCE);
                            if (tapActivityLifecycleCallbacksArray != null) {
                                $this$forEach$iv = tapActivityLifecycleCallbacksArray;
                                $i$f$forEach = false;
                                n2 = $this$forEach$iv.length;
                                for (n = 0; n < n2; ++n) {
                                    it = element$iv = $this$forEach$iv[n];
                                    boolean bl = false;
                                    it.onBackground((Context)activity);
                                }
                            }
                        }
                    }
                    TapActivityLifecycleCallbacks[] tapActivityLifecycleCallbacksArray = TapActivityLifecycleTracker.access$collectActivityLifecycleCallbacks(TapActivityLifecycleTracker.INSTANCE);
                    if (tapActivityLifecycleCallbacksArray == null) break block6;
                    $this$forEach$iv = tapActivityLifecycleCallbacksArray;
                    $i$f$forEach = false;
                    n2 = $this$forEach$iv.length;
                    for (n = 0; n < n2; ++n) {
                        it = element$iv = $this$forEach$iv[n];
                        boolean bl = false;
                        it.onActivityStopped(activity);
                    }
                }
            }

            public void onActivitySaveInstanceState(@NotNull Activity activity, @NotNull Bundle outState) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                    Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
                    TapActivityLifecycleCallbacks[] tapActivityLifecycleCallbacksArray = TapActivityLifecycleTracker.access$collectActivityLifecycleCallbacks(TapActivityLifecycleTracker.INSTANCE);
                    if (tapActivityLifecycleCallbacksArray == null) break block1;
                    TapActivityLifecycleCallbacks[] $this$forEach$iv = tapActivityLifecycleCallbacksArray;
                    boolean $i$f$forEach = false;
                    int n = $this$forEach$iv.length;
                    for (int i = 0; i < n; ++i) {
                        TapActivityLifecycleCallbacks element$iv;
                        TapActivityLifecycleCallbacks it = element$iv = $this$forEach$iv[i];
                        boolean bl = false;
                        it.onActivitySaveInstanceState(activity, outState);
                    }
                }
            }

            public void onActivityDestroyed(@NotNull Activity activity) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                    TapActivityLifecycleTracker.access$getActivityList$p().remove(activity);
                    TapActivityLifecycleCallbacks[] tapActivityLifecycleCallbacksArray = TapActivityLifecycleTracker.access$collectActivityLifecycleCallbacks(TapActivityLifecycleTracker.INSTANCE);
                    if (tapActivityLifecycleCallbacksArray == null) break block1;
                    TapActivityLifecycleCallbacks[] $this$forEach$iv = tapActivityLifecycleCallbacksArray;
                    boolean $i$f$forEach = false;
                    int n = $this$forEach$iv.length;
                    for (int i = 0; i < n; ++i) {
                        TapActivityLifecycleCallbacks element$iv;
                        TapActivityLifecycleCallbacks it = element$iv = $this$forEach$iv[i];
                        boolean bl = false;
                        it.onActivityDestroyed(activity);
                    }
                }
            }

            public void onActivityPreCreated(@NotNull Activity activity, @Nullable Bundle savedInstanceState) {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                    if (Build.VERSION.SDK_INT < 29) break block2;
                    TapActivityLifecycleCallbacks[] tapActivityLifecycleCallbacksArray = TapActivityLifecycleTracker.access$collectActivityLifecycleCallbacks(TapActivityLifecycleTracker.INSTANCE);
                    if (tapActivityLifecycleCallbacksArray != null) {
                        TapActivityLifecycleCallbacks[] $this$forEach$iv = tapActivityLifecycleCallbacksArray;
                        boolean $i$f$forEach = false;
                        int n = $this$forEach$iv.length;
                        for (int i = 0; i < n; ++i) {
                            TapActivityLifecycleCallbacks element$iv;
                            TapActivityLifecycleCallbacks it = element$iv = $this$forEach$iv[i];
                            boolean bl = false;
                            it.onActivityPreCreated(activity, savedInstanceState);
                        }
                    }
                }
            }

            public void onActivityPostCreated(@NotNull Activity activity, @Nullable Bundle savedInstanceState) {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                    if (Build.VERSION.SDK_INT < 29) break block2;
                    TapActivityLifecycleCallbacks[] tapActivityLifecycleCallbacksArray = TapActivityLifecycleTracker.access$collectActivityLifecycleCallbacks(TapActivityLifecycleTracker.INSTANCE);
                    if (tapActivityLifecycleCallbacksArray != null) {
                        TapActivityLifecycleCallbacks[] $this$forEach$iv = tapActivityLifecycleCallbacksArray;
                        boolean $i$f$forEach = false;
                        int n = $this$forEach$iv.length;
                        for (int i = 0; i < n; ++i) {
                            TapActivityLifecycleCallbacks element$iv;
                            TapActivityLifecycleCallbacks it = element$iv = $this$forEach$iv[i];
                            boolean bl = false;
                            it.onActivityPostCreated(activity, savedInstanceState);
                        }
                    }
                }
            }

            public void onActivityPreStarted(@NotNull Activity activity) {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                    if (Build.VERSION.SDK_INT < 29) break block2;
                    TapActivityLifecycleCallbacks[] tapActivityLifecycleCallbacksArray = TapActivityLifecycleTracker.access$collectActivityLifecycleCallbacks(TapActivityLifecycleTracker.INSTANCE);
                    if (tapActivityLifecycleCallbacksArray != null) {
                        TapActivityLifecycleCallbacks[] $this$forEach$iv = tapActivityLifecycleCallbacksArray;
                        boolean $i$f$forEach = false;
                        int n = $this$forEach$iv.length;
                        for (int i = 0; i < n; ++i) {
                            TapActivityLifecycleCallbacks element$iv;
                            TapActivityLifecycleCallbacks it = element$iv = $this$forEach$iv[i];
                            boolean bl = false;
                            it.onActivityPreStarted(activity);
                        }
                    }
                }
            }

            public void onActivityPostStarted(@NotNull Activity activity) {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                    if (Build.VERSION.SDK_INT < 29) break block2;
                    TapActivityLifecycleCallbacks[] tapActivityLifecycleCallbacksArray = TapActivityLifecycleTracker.access$collectActivityLifecycleCallbacks(TapActivityLifecycleTracker.INSTANCE);
                    if (tapActivityLifecycleCallbacksArray != null) {
                        TapActivityLifecycleCallbacks[] $this$forEach$iv = tapActivityLifecycleCallbacksArray;
                        boolean $i$f$forEach = false;
                        int n = $this$forEach$iv.length;
                        for (int i = 0; i < n; ++i) {
                            TapActivityLifecycleCallbacks element$iv;
                            TapActivityLifecycleCallbacks it = element$iv = $this$forEach$iv[i];
                            boolean bl = false;
                            it.onActivityPostStarted(activity);
                        }
                    }
                }
            }

            public void onActivityPreResumed(@NotNull Activity activity) {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                    if (Build.VERSION.SDK_INT < 29) break block2;
                    TapActivityLifecycleCallbacks[] tapActivityLifecycleCallbacksArray = TapActivityLifecycleTracker.access$collectActivityLifecycleCallbacks(TapActivityLifecycleTracker.INSTANCE);
                    if (tapActivityLifecycleCallbacksArray != null) {
                        TapActivityLifecycleCallbacks[] $this$forEach$iv = tapActivityLifecycleCallbacksArray;
                        boolean $i$f$forEach = false;
                        int n = $this$forEach$iv.length;
                        for (int i = 0; i < n; ++i) {
                            TapActivityLifecycleCallbacks element$iv;
                            TapActivityLifecycleCallbacks it = element$iv = $this$forEach$iv[i];
                            boolean bl = false;
                            it.onActivityPreResumed(activity);
                        }
                    }
                }
            }

            public void onActivityPostResumed(@NotNull Activity activity) {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                    if (Build.VERSION.SDK_INT < 29) break block2;
                    TapActivityLifecycleCallbacks[] tapActivityLifecycleCallbacksArray = TapActivityLifecycleTracker.access$collectActivityLifecycleCallbacks(TapActivityLifecycleTracker.INSTANCE);
                    if (tapActivityLifecycleCallbacksArray != null) {
                        TapActivityLifecycleCallbacks[] $this$forEach$iv = tapActivityLifecycleCallbacksArray;
                        boolean $i$f$forEach = false;
                        int n = $this$forEach$iv.length;
                        for (int i = 0; i < n; ++i) {
                            TapActivityLifecycleCallbacks element$iv;
                            TapActivityLifecycleCallbacks it = element$iv = $this$forEach$iv[i];
                            boolean bl = false;
                            it.onActivityPostResumed(activity);
                        }
                    }
                }
            }

            public void onActivityPrePaused(@NotNull Activity activity) {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                    if (Build.VERSION.SDK_INT < 29) break block2;
                    TapActivityLifecycleCallbacks[] tapActivityLifecycleCallbacksArray = TapActivityLifecycleTracker.access$collectActivityLifecycleCallbacks(TapActivityLifecycleTracker.INSTANCE);
                    if (tapActivityLifecycleCallbacksArray != null) {
                        TapActivityLifecycleCallbacks[] $this$forEach$iv = tapActivityLifecycleCallbacksArray;
                        boolean $i$f$forEach = false;
                        int n = $this$forEach$iv.length;
                        for (int i = 0; i < n; ++i) {
                            TapActivityLifecycleCallbacks element$iv;
                            TapActivityLifecycleCallbacks it = element$iv = $this$forEach$iv[i];
                            boolean bl = false;
                            it.onActivityPrePaused(activity);
                        }
                    }
                }
            }

            public void onActivityPostPaused(@NotNull Activity activity) {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                    if (Build.VERSION.SDK_INT < 29) break block2;
                    TapActivityLifecycleCallbacks[] tapActivityLifecycleCallbacksArray = TapActivityLifecycleTracker.access$collectActivityLifecycleCallbacks(TapActivityLifecycleTracker.INSTANCE);
                    if (tapActivityLifecycleCallbacksArray != null) {
                        TapActivityLifecycleCallbacks[] $this$forEach$iv = tapActivityLifecycleCallbacksArray;
                        boolean $i$f$forEach = false;
                        int n = $this$forEach$iv.length;
                        for (int i = 0; i < n; ++i) {
                            TapActivityLifecycleCallbacks element$iv;
                            TapActivityLifecycleCallbacks it = element$iv = $this$forEach$iv[i];
                            boolean bl = false;
                            it.onActivityPostPaused(activity);
                        }
                    }
                }
            }

            public void onActivityPreStopped(@NotNull Activity activity) {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                    if (Build.VERSION.SDK_INT < 29) break block2;
                    TapActivityLifecycleCallbacks[] tapActivityLifecycleCallbacksArray = TapActivityLifecycleTracker.access$collectActivityLifecycleCallbacks(TapActivityLifecycleTracker.INSTANCE);
                    if (tapActivityLifecycleCallbacksArray != null) {
                        TapActivityLifecycleCallbacks[] $this$forEach$iv = tapActivityLifecycleCallbacksArray;
                        boolean $i$f$forEach = false;
                        int n = $this$forEach$iv.length;
                        for (int i = 0; i < n; ++i) {
                            TapActivityLifecycleCallbacks element$iv;
                            TapActivityLifecycleCallbacks it = element$iv = $this$forEach$iv[i];
                            boolean bl = false;
                            it.onActivityPreStopped(activity);
                        }
                    }
                }
            }

            public void onActivityPostStopped(@NotNull Activity activity) {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                    if (Build.VERSION.SDK_INT < 29) break block2;
                    TapActivityLifecycleCallbacks[] tapActivityLifecycleCallbacksArray = TapActivityLifecycleTracker.access$collectActivityLifecycleCallbacks(TapActivityLifecycleTracker.INSTANCE);
                    if (tapActivityLifecycleCallbacksArray != null) {
                        TapActivityLifecycleCallbacks[] $this$forEach$iv = tapActivityLifecycleCallbacksArray;
                        boolean $i$f$forEach = false;
                        int n = $this$forEach$iv.length;
                        for (int i = 0; i < n; ++i) {
                            TapActivityLifecycleCallbacks element$iv;
                            TapActivityLifecycleCallbacks it = element$iv = $this$forEach$iv[i];
                            boolean bl = false;
                            it.onActivityPostStopped(activity);
                        }
                    }
                }
            }

            public void onActivityPreSaveInstanceState(@NotNull Activity activity, @NotNull Bundle outState) {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                    Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
                    if (Build.VERSION.SDK_INT < 29) break block2;
                    TapActivityLifecycleCallbacks[] tapActivityLifecycleCallbacksArray = TapActivityLifecycleTracker.access$collectActivityLifecycleCallbacks(TapActivityLifecycleTracker.INSTANCE);
                    if (tapActivityLifecycleCallbacksArray != null) {
                        TapActivityLifecycleCallbacks[] $this$forEach$iv = tapActivityLifecycleCallbacksArray;
                        boolean $i$f$forEach = false;
                        int n = $this$forEach$iv.length;
                        for (int i = 0; i < n; ++i) {
                            TapActivityLifecycleCallbacks element$iv;
                            TapActivityLifecycleCallbacks it = element$iv = $this$forEach$iv[i];
                            boolean bl = false;
                            it.onActivityPreSaveInstanceState(activity, outState);
                        }
                    }
                }
            }

            public void onActivityPostSaveInstanceState(@NotNull Activity activity, @NotNull Bundle outState) {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                    Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
                    if (Build.VERSION.SDK_INT < 29) break block2;
                    TapActivityLifecycleCallbacks[] tapActivityLifecycleCallbacksArray = TapActivityLifecycleTracker.access$collectActivityLifecycleCallbacks(TapActivityLifecycleTracker.INSTANCE);
                    if (tapActivityLifecycleCallbacksArray != null) {
                        TapActivityLifecycleCallbacks[] $this$forEach$iv = tapActivityLifecycleCallbacksArray;
                        boolean $i$f$forEach = false;
                        int n = $this$forEach$iv.length;
                        for (int i = 0; i < n; ++i) {
                            TapActivityLifecycleCallbacks element$iv;
                            TapActivityLifecycleCallbacks it = element$iv = $this$forEach$iv[i];
                            boolean bl = false;
                            it.onActivityPostSaveInstanceState(activity, outState);
                        }
                    }
                }
            }

            public void onActivityPreDestroyed(@NotNull Activity activity) {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                    if (Build.VERSION.SDK_INT < 29) break block2;
                    TapActivityLifecycleCallbacks[] tapActivityLifecycleCallbacksArray = TapActivityLifecycleTracker.access$collectActivityLifecycleCallbacks(TapActivityLifecycleTracker.INSTANCE);
                    if (tapActivityLifecycleCallbacksArray != null) {
                        TapActivityLifecycleCallbacks[] $this$forEach$iv = tapActivityLifecycleCallbacksArray;
                        boolean $i$f$forEach = false;
                        int n = $this$forEach$iv.length;
                        for (int i = 0; i < n; ++i) {
                            TapActivityLifecycleCallbacks element$iv;
                            TapActivityLifecycleCallbacks it = element$iv = $this$forEach$iv[i];
                            boolean bl = false;
                            it.onActivityPreDestroyed(activity);
                        }
                    }
                }
            }

            public void onActivityPostDestroyed(@NotNull Activity activity) {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                    if (Build.VERSION.SDK_INT < 29) break block2;
                    TapActivityLifecycleCallbacks[] tapActivityLifecycleCallbacksArray = TapActivityLifecycleTracker.access$collectActivityLifecycleCallbacks(TapActivityLifecycleTracker.INSTANCE);
                    if (tapActivityLifecycleCallbacksArray != null) {
                        TapActivityLifecycleCallbacks[] $this$forEach$iv = tapActivityLifecycleCallbacksArray;
                        boolean $i$f$forEach = false;
                        int n = $this$forEach$iv.length;
                        for (int i = 0; i < n; ++i) {
                            TapActivityLifecycleCallbacks element$iv;
                            TapActivityLifecycleCallbacks it = element$iv = $this$forEach$iv[i];
                            boolean bl = false;
                            it.onActivityPostDestroyed(activity);
                        }
                    }
                }
            }
        };
    }
}

