/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.common.network;

import com.taptap.sdk.common.network.NetworkClientKt;
import com.taptap.sdk.common.network.convert.BizConverterFactory;
import com.taptap.sdk.common.network.convert.ErrorHandlerCallFactory;
import com.taptap.sdk.common.network.interceptor.DefaultCommonArgsInterceptor;
import com.taptap.sdk.common.network.interceptor.RequestSignInterceptor;
import com.taptap.sdk.common.network.sign.DefaultSignStrategy;
import com.taptap.sdk.common.network.utils.RandomUtils;
import com.taptap.sdk.initializer.api.option.TapTapSdkOptions;
import com.taptap.sdk.kit.internal.identifier.TapIdentifierUtil;
import com.taptap.sdk.kit.internal.utils.localize.TapLocalizeUtil;
import com.taptap.sdk.okhttp3.Interceptor;
import com.taptap.sdk.okhttp3.MediaType;
import com.taptap.sdk.okhttp3.OkHttpClient;
import com.taptap.sdk.retrofit2.Retrofit;
import com.taptap.sdk.retrofit2.converter.kotlinx.serialization.KotlinSerializationConverterFactory;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001a\u000e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\n"}, d2={"provideJson", "Lkotlinx/serialization/json/Json;", "provideOkHttpClient", "Lcom/taptap/sdk/okhttp3/OkHttpClient;", "options", "Lcom/taptap/sdk/initializer/api/option/TapTapSdkOptions;", "provideRetrofit", "Lcom/taptap/sdk/retrofit2/Retrofit;", "baseUrl", "", "tap-common_release"})
public final class NetworkClientKt {
    @NotNull
    public static final Retrofit provideRetrofit(@NotNull String baseUrl, @NotNull TapTapSdkOptions options) {
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Retrofit.Builder builder = new Retrofit.Builder().baseUrl(baseUrl).client(NetworkClientKt.provideOkHttpClient(options)).addCallAdapterFactory(ErrorHandlerCallFactory.Companion.create()).addConverterFactory(BizConverterFactory.Companion.create());
        StringFormat stringFormat = (StringFormat)NetworkClientKt.provideJson();
        MediaType mediaType = MediaType.parse((String)"application/json");
        if (mediaType == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        Intrinsics.checkNotNullExpressionValue((Object)mediaType, (String)"checkNotNull(MediaType.parse(\"application/json\"))");
        Retrofit retrofit = builder.addConverterFactory(KotlinSerializationConverterFactory.create((StringFormat)stringFormat, (MediaType)mediaType)).build();
        Intrinsics.checkNotNullExpressionValue((Object)retrofit, (String)"Builder()\n        .baseU\u2026son\"))))\n        .build()");
        return retrofit;
    }

    @NotNull
    public static final OkHttpClient provideOkHttpClient(@NotNull TapTapSdkOptions options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        Set set = SetsKt.emptySet();
        String string = options.getClientId();
        String string2 = TapLocalizeUtil.getPreferredLanguage().getLanguage();
        String string3 = TapIdentifierUtil.INSTANCE.getDeviceId(options.getContext());
        if (string3 == null) {
            string3 = "";
        }
        OkHttpClient okHttpClient = builder.addInterceptor((Interceptor)new DefaultCommonArgsInterceptor(new DefaultCommonArgsInterceptor.Config(set, string, string2, "TapSDK-Android", string3, "Android", RandomUtils.INSTANCE.getRandomString(10), null, 128, null))).addInterceptor((Interceptor)new RequestSignInterceptor(new RequestSignInterceptor.Config(new DefaultSignStrategy(new DefaultSignStrategy.Config(options.getClientId(), options.getClientToken()))))).build();
        Intrinsics.checkNotNullExpressionValue((Object)okHttpClient, (String)"Builder()\n        .addIn\u2026       )\n        .build()");
        return okHttpClient;
    }

    @NotNull
    public static final Json provideJson() {
        return JsonKt.Json$default(null, (Function1)provideJson.1.INSTANCE, (int)1, null);
    }
}

