/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.common.network.interceptor;

import com.taptap.sdk.base.network.annotation.Module;
import com.taptap.sdk.common.network.utils.FixedTimeUtil;
import com.taptap.sdk.okhttp3.Headers;
import com.taptap.sdk.okhttp3.HttpUrl;
import com.taptap.sdk.okhttp3.Interceptor;
import com.taptap.sdk.okhttp3.Request;
import com.taptap.sdk.okhttp3.Response;
import com.taptap.sdk.retrofit2.Invocation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0019B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J\u0014\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0014H\u0002J \u0010\u0015\u001a\u00020\u0016*\u00020\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u0018H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/taptap/sdk/common/network/interceptor/DefaultCommonArgsInterceptor;", "Lcom/taptap/sdk/okhttp3/Interceptor;", "config", "Lcom/taptap/sdk/common/network/interceptor/DefaultCommonArgsInterceptor$Config;", "(Lcom/taptap/sdk/common/network/interceptor/DefaultCommonArgsInterceptor$Config;)V", "getCommonHeaders", "Lcom/taptap/sdk/okhttp3/Headers;", "invocation", "Lcom/taptap/sdk/retrofit2/Invocation;", "getModuleFromInvocation", "Lcom/taptap/sdk/base/network/annotation/Module;", "intercept", "Lcom/taptap/sdk/okhttp3/Response;", "chain", "Lcom/taptap/sdk/okhttp3/Interceptor$Chain;", "shouldAddAuthorization", "", "url", "", "paths", "", "from", "Lcom/taptap/sdk/okhttp3/HttpUrl;", "queryMap", "", "Config", "tap-common_release"})
public final class DefaultCommonArgsInterceptor
implements Interceptor {
    @NotNull
    private final Config config;

    public DefaultCommonArgsInterceptor(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
    }

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Request originRequest = chain.request();
        Request.Builder newRequestBuilder = originRequest.newBuilder();
        HttpUrl httpUrl = originRequest.url();
        Intrinsics.checkNotNullExpressionValue((Object)httpUrl, (String)"originRequest.url()");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"client_id", (Object)this.config.getClientId())};
        newRequestBuilder.url(this.from(httpUrl, MapsKt.hashMapOf((Pair[])pairArray)));
        newRequestBuilder.headers(this.getCommonHeaders((Invocation)originRequest.tag(Invocation.class)));
        String string = originRequest.url().encodedPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"originRequest.url().encodedPath()");
        if (this.shouldAddAuthorization(string, this.config.getPaths())) {
            String string2 = this.config.getAuthorization();
            if (string2 != null) {
                String value = string2;
                boolean bl = false;
                newRequestBuilder.header("Authorization", value);
            }
            Response response = chain.proceed(newRequestBuilder.build());
            Intrinsics.checkNotNullExpressionValue((Object)response, (String)"chain.proceed(newRequestBuilder.build())");
            return response;
        }
        Response response = chain.proceed(newRequestBuilder.build());
        Intrinsics.checkNotNullExpressionValue((Object)response, (String)"chain.proceed(newRequestBuilder.build())");
        return response;
    }

    /*
     * WARNING - void declaration
     */
    private final HttpUrl from(HttpUrl $this$from, Map<String, String> queryMap) {
        void $this$fold$iv;
        Iterable iterable = MapsKt.toList(queryMap);
        HttpUrl.Builder initial$iv = $this$from.newBuilder();
        boolean $i$f$fold = false;
        HttpUrl.Builder accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            Pair pair = (Pair)element$iv;
            HttpUrl.Builder builder = accumulator$iv;
            boolean bl = false;
            String key = (String)pair.component1();
            String value = (String)pair.component2();
            builder.addQueryParameter(key, value);
            accumulator$iv = builder;
        }
        HttpUrl httpUrl = accumulator$iv.build();
        Intrinsics.checkNotNullExpressionValue((Object)httpUrl, (String)"queryMap.toList()\n      \u2026   }\n            .build()");
        return httpUrl;
    }

    private final Headers getCommonHeaders(Invocation invocation) {
        HashMap params = new HashMap();
        Map map = params;
        Pair pair = TuplesKt.to((Object)"X-Tap-PN", (Object)"TapSDK");
        map.put(pair.getFirst(), pair.getSecond());
        map = params;
        pair = TuplesKt.to((Object)"X-Tap-Device-Id", (Object)this.config.getDeviceId());
        map.put(pair.getFirst(), pair.getSecond());
        map = params;
        pair = TuplesKt.to((Object)"X-Tap-Platform", (Object)"Android");
        map.put(pair.getFirst(), pair.getSecond());
        map = params;
        pair = TuplesKt.to((Object)"X-Tap-SDK-Artifact", (Object)this.config.getSdkArtifact());
        map.put(pair.getFirst(), pair.getSecond());
        map = params;
        pair = TuplesKt.to((Object)"X-Tap-Ts", (Object)String.valueOf(FixedTimeUtil.INSTANCE.getCurrentTimeInMillis() / (long)1000));
        map.put(pair.getFirst(), pair.getSecond());
        map = params;
        pair = TuplesKt.to((Object)"X-Tap-Nonce", (Object)this.config.getNonce());
        map.put(pair.getFirst(), pair.getSecond());
        map = params;
        pair = TuplesKt.to((Object)"X-Tap-Lang", (Object)this.config.getLanguage());
        map.put(pair.getFirst(), pair.getSecond());
        map = params;
        pair = TuplesKt.to((Object)"User-Agent", (Object)this.config.getUserAgent());
        map.put(pair.getFirst(), pair.getSecond());
        Module module = this.getModuleFromInvocation(invocation);
        if (module != null) {
            Module module2 = module;
            boolean bl = false;
            Map map2 = params;
            Pair pair2 = TuplesKt.to((Object)"X-Tap-SDK-Module", (Object)module2.name());
            map2.put(pair2.getFirst(), pair2.getSecond());
            map2 = params;
            pair2 = TuplesKt.to((Object)"X-Tap-SDK-Module-Version", (Object)module2.version());
            map2.put(pair2.getFirst(), pair2.getSecond());
        }
        Headers headers2 = Headers.of((Map)params);
        Intrinsics.checkNotNullExpressionValue((Object)headers2, (String)"of(params)");
        return headers2;
    }

    private final boolean shouldAddAuthorization(String url, Set<String> paths) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = paths;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String path = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.contains$default((CharSequence)url, (CharSequence)path, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final Module getModuleFromInvocation(Invocation invocation) {
        Module module;
        Object object = invocation;
        if (object != null && (object = object.method()) != null && (object = ((Method)object).getDeclaringClass()) != null) {
            Object serviceClass = object;
            boolean bl = false;
            module = ((Class)serviceClass).getAnnotation(Module.class);
        } else {
            module = null;
        }
        return module;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u001c\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001BO\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u0012\u0006\u0010\b\u001a\u00020\u0004\u0012\u0006\u0010\t\u001a\u00020\u0004\u0012\u0006\u0010\n\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\fJ\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0004H\u00c6\u0003J\u000b\u0010\u001e\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003Ja\u0010\u001f\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u00042\b\b\u0002\u0010\b\u001a\u00020\u00042\b\b\u0002\u0010\t\u001a\u00020\u00042\b\b\u0002\u0010\n\u001a\u00020\u00042\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0004H\u00c6\u0001J\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010#\u001a\u00020$H\u00d6\u0001J\t\u0010%\u001a\u00020\u0004H\u00d6\u0001R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0011\u0010\n\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000e\u00a8\u0006&"}, d2={"Lcom/taptap/sdk/common/network/interceptor/DefaultCommonArgsInterceptor$Config;", "", "paths", "", "", "clientId", "language", "userAgent", "deviceId", "sdkArtifact", "nonce", "authorization", "(Ljava/util/Set;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getAuthorization", "()Ljava/lang/String;", "getClientId", "getDeviceId", "getLanguage", "getNonce", "getPaths", "()Ljava/util/Set;", "getSdkArtifact", "getUserAgent", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "", "other", "hashCode", "", "toString", "tap-common_release"})
    public static final class Config {
        @NotNull
        private final Set<String> paths;
        @NotNull
        private final String clientId;
        @NotNull
        private final String language;
        @NotNull
        private final String userAgent;
        @NotNull
        private final String deviceId;
        @NotNull
        private final String sdkArtifact;
        @NotNull
        private final String nonce;
        @Nullable
        private final String authorization;

        public Config(@NotNull Set<String> paths, @NotNull String clientId, @NotNull String language, @NotNull String userAgent, @NotNull String deviceId, @NotNull String sdkArtifact, @NotNull String nonce, @Nullable String authorization) {
            Intrinsics.checkNotNullParameter(paths, (String)"paths");
            Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            Intrinsics.checkNotNullParameter((Object)userAgent, (String)"userAgent");
            Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
            Intrinsics.checkNotNullParameter((Object)sdkArtifact, (String)"sdkArtifact");
            Intrinsics.checkNotNullParameter((Object)nonce, (String)"nonce");
            this.paths = paths;
            this.clientId = clientId;
            this.language = language;
            this.userAgent = userAgent;
            this.deviceId = deviceId;
            this.sdkArtifact = sdkArtifact;
            this.nonce = nonce;
            this.authorization = authorization;
        }

        public /* synthetic */ Config(Set set, String string, String string2, String string3, String string4, String string5, String string6, String string7, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x80) != 0) {
                string7 = null;
            }
            this(set, string, string2, string3, string4, string5, string6, string7);
        }

        @NotNull
        public final Set<String> getPaths() {
            return this.paths;
        }

        @NotNull
        public final String getClientId() {
            return this.clientId;
        }

        @NotNull
        public final String getLanguage() {
            return this.language;
        }

        @NotNull
        public final String getUserAgent() {
            return this.userAgent;
        }

        @NotNull
        public final String getDeviceId() {
            return this.deviceId;
        }

        @NotNull
        public final String getSdkArtifact() {
            return this.sdkArtifact;
        }

        @NotNull
        public final String getNonce() {
            return this.nonce;
        }

        @Nullable
        public final String getAuthorization() {
            return this.authorization;
        }

        @NotNull
        public final Set<String> component1() {
            return this.paths;
        }

        @NotNull
        public final String component2() {
            return this.clientId;
        }

        @NotNull
        public final String component3() {
            return this.language;
        }

        @NotNull
        public final String component4() {
            return this.userAgent;
        }

        @NotNull
        public final String component5() {
            return this.deviceId;
        }

        @NotNull
        public final String component6() {
            return this.sdkArtifact;
        }

        @NotNull
        public final String component7() {
            return this.nonce;
        }

        @Nullable
        public final String component8() {
            return this.authorization;
        }

        @NotNull
        public final Config copy(@NotNull Set<String> paths, @NotNull String clientId, @NotNull String language, @NotNull String userAgent, @NotNull String deviceId, @NotNull String sdkArtifact, @NotNull String nonce, @Nullable String authorization) {
            Intrinsics.checkNotNullParameter(paths, (String)"paths");
            Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            Intrinsics.checkNotNullParameter((Object)userAgent, (String)"userAgent");
            Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
            Intrinsics.checkNotNullParameter((Object)sdkArtifact, (String)"sdkArtifact");
            Intrinsics.checkNotNullParameter((Object)nonce, (String)"nonce");
            return new Config(paths, clientId, language, userAgent, deviceId, sdkArtifact, nonce, authorization);
        }

        public static /* synthetic */ Config copy$default(Config config, Set set, String string, String string2, String string3, String string4, String string5, String string6, String string7, int n, Object object) {
            if ((n & 1) != 0) {
                set = config.paths;
            }
            if ((n & 2) != 0) {
                string = config.clientId;
            }
            if ((n & 4) != 0) {
                string2 = config.language;
            }
            if ((n & 8) != 0) {
                string3 = config.userAgent;
            }
            if ((n & 0x10) != 0) {
                string4 = config.deviceId;
            }
            if ((n & 0x20) != 0) {
                string5 = config.sdkArtifact;
            }
            if ((n & 0x40) != 0) {
                string6 = config.nonce;
            }
            if ((n & 0x80) != 0) {
                string7 = config.authorization;
            }
            return config.copy(set, string, string2, string3, string4, string5, string6, string7);
        }

        @NotNull
        public String toString() {
            return "Config(paths=" + this.paths + ", clientId=" + this.clientId + ", language=" + this.language + ", userAgent=" + this.userAgent + ", deviceId=" + this.deviceId + ", sdkArtifact=" + this.sdkArtifact + ", nonce=" + this.nonce + ", authorization=" + this.authorization + ')';
        }

        public int hashCode() {
            int result = ((Object)this.paths).hashCode();
            result = result * 31 + this.clientId.hashCode();
            result = result * 31 + this.language.hashCode();
            result = result * 31 + this.userAgent.hashCode();
            result = result * 31 + this.deviceId.hashCode();
            result = result * 31 + this.sdkArtifact.hashCode();
            result = result * 31 + this.nonce.hashCode();
            result = result * 31 + (this.authorization == null ? 0 : this.authorization.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Config)) {
                return false;
            }
            Config config = (Config)other;
            if (!Intrinsics.areEqual(this.paths, config.paths)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.clientId, (Object)config.clientId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.language, (Object)config.language)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.userAgent, (Object)config.userAgent)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.deviceId, (Object)config.deviceId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.sdkArtifact, (Object)config.sdkArtifact)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.nonce, (Object)config.nonce)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.authorization, (Object)config.authorization);
        }
    }
}

