/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.kit.internal.extensions;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import com.taptap.sdk.initializer.api.model.RegionType;
import com.taptap.sdk.kit.internal.TapTapKit;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a\u0018\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t\u001a\u0006\u0010\n\u001a\u00020\u0003\u001a\u0006\u0010\u000b\u001a\u00020\u0001\u001a\u0006\u0010\f\u001a\u00020\r\u001a\u0014\u0010\u000e\u001a\u00020\u0003*\u00020\u00012\b\b\u0002\u0010\u000f\u001a\u00020\u0003\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0003X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"INVALID_PACKAGE_VERSION_CODE", "", "PACKAGE_NAME_CN", "", "PACKAGE_NAME_GLOBAL", "checkApkFile", "context", "Landroid/content/Context;", "file", "Ljava/io/File;", "getTapPkgName", "getTapVersionCode", "isTapInstalled", "", "toDateString", "pattern", "tap-common_release"})
public final class SysExtKt {
    @NotNull
    public static final String PACKAGE_NAME_CN = "com.taptap";
    @NotNull
    public static final String PACKAGE_NAME_GLOBAL = "com.taptap.global";
    public static final int INVALID_PACKAGE_VERSION_CODE = -1;

    public static final boolean isTapInstalled() {
        boolean bl;
        try {
            bl = TapTapKit.INSTANCE.getContext().getPackageManager().getPackageInfo(SysExtKt.getTapPkgName(), 0) != null;
        }
        catch (Throwable t) {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public static final String getTapPkgName() {
        return TapTapKit.INSTANCE.getRegionType$tap_common_release() == RegionType.CN ? PACKAGE_NAME_CN : PACKAGE_NAME_GLOBAL;
    }

    public static final int getTapVersionCode() {
        int n;
        if (!SysExtKt.isTapInstalled()) {
            return -1;
        }
        try {
            PackageInfo packageInfo = TapTapKit.INSTANCE.getContext().getPackageManager().getPackageInfo(SysExtKt.getTapPkgName(), 0);
            n = packageInfo != null ? packageInfo.versionCode : -1;
        }
        catch (Throwable t) {
            n = -1;
        }
        return n;
    }

    public static final int checkApkFile(@NotNull Context context, @Nullable File file) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        File file2 = file;
        if (!(file2 != null ? file2.exists() : false)) {
            return -1;
        }
        try {
            String fileName = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)fileName, (String)"fileName");
            String string = fileName.substring(StringsKt.lastIndexOf$default((CharSequence)fileName, (String)".", (int)0, (boolean)false, (int)6, null) + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            String fileType = string;
            if (!Intrinsics.areEqual((Object)fileType, (Object)"apk")) {
                return -1;
            }
            PackageManager pm = context.getPackageManager();
            PackageInfo packageInfo = pm.getPackageArchiveInfo(file.getPath(), 1);
            return packageInfo == null ? -2 : 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    @NotNull
    public static final String toDateString(int $this$toDateString, @NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Date date = new Date((long)$this$toDateString * 1000L);
        SimpleDateFormat formatter = new SimpleDateFormat(pattern, Locale.getDefault());
        String string = formatter.format(date);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatter.format(date)");
        return string;
    }

    public static /* synthetic */ String toDateString$default(int n, String string, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = "yyyy.MM.dd";
        }
        return SysExtKt.toDateString(n, string);
    }
}

