/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.kit.internal.http;

import android.os.Build;
import android.util.Base64;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bJ \u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\b\b\u0002\u0010\f\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/taptap/sdk/kit/internal/http/TapHttpUtil;", "", "()V", "HMAC_SHA1", "", "HMAC_SHA256", "getRandomString", "length", "", "secret", "token", "content", "algorithm", "tap-common_release"})
public final class TapHttpUtil {
    @NotNull
    public static final TapHttpUtil INSTANCE = new TapHttpUtil();
    @NotNull
    public static final String HMAC_SHA1 = "HmacSHA1";
    @NotNull
    public static final String HMAC_SHA256 = "HmacSHA256";

    private TapHttpUtil() {
    }

    @NotNull
    public final String secret(@NotNull String token, @NotNull String content, @NotNull String algorithm) {
        String string;
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Mac hmacSha256 = Mac.getInstance(algorithm);
        String string2 = token;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        SecretKeySpec secretKey = new SecretKeySpec(byArray, HMAC_SHA256);
        hmacSha256.init(secretKey);
        String string3 = content;
        Charset charset2 = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"UTF_8");
        byte[] byArray2 = string3.getBytes(charset2);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
        byte[] signatureBytes = hmacSha256.doFinal(byArray2);
        if (Build.VERSION.SDK_INT >= 26) {
            String string4 = java.util.Base64.getEncoder().encodeToString(signatureBytes);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"{\n            java.util.\u2026signatureBytes)\n        }");
        } else {
            String string5 = Base64.encodeToString((byte[])signatureBytes, (int)2);
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"{\n            android.ut\u2026Base64.NO_WRAP)\n        }");
        }
        return string;
    }

    public static /* synthetic */ String secret$default(TapHttpUtil tapHttpUtil, String string, String string2, String string3, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = HMAC_SHA256;
        }
        return tapHttpUtil.secret(string, string2, string3);
    }

    @NotNull
    public final String getRandomString(int length) {
        String base = "abcdefghijklmnopqrstuvwxyz0123456789";
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            int number = Random.Default.nextInt(base.length());
            sb.append(base.charAt(number));
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }
}

