/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.kit.internal.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Process;
import android.telephony.TelephonyManager;
import com.taptap.sdk.kit.internal.TapLogger;

public class NetworkUtil {
    private static final String TAG = "NetworkUtil";

    public static ConnectivityManager getConnectivityManager(Context context) {
        return (ConnectivityManager)context.getSystemService("connectivity");
    }

    @SuppressLint(value={"MissingPermission"})
    public static String getConnectedType(Context context) {
        try {
            NetworkInfo net = NetworkUtil.getConnectivityManager(context).getActiveNetworkInfo();
            if (net != null) {
                switch (net.getType()) {
                    case 1: {
                        return "wifi";
                    }
                    case 0: {
                        return "mobile";
                    }
                }
                return "unknow";
            }
        }
        catch (Error | Exception throwable) {
            // empty catch block
        }
        return "not connected";
    }

    public static boolean checkHasPermission(Context context, String permission2) {
        try {
            int result = context.checkPermission(permission2, Process.myPid(), Process.myUid());
            return result == 0;
        }
        catch (Exception e) {
            return true;
        }
    }

    @SuppressLint(value={"MissingPermission"})
    private static boolean isWiFiNetwork(ConnectivityManager connectivityManager) {
        if (Build.VERSION.SDK_INT >= 23) {
            NetworkCapabilities capabilities;
            Network network = connectivityManager.getActiveNetwork();
            if (network != null && (capabilities = connectivityManager.getNetworkCapabilities(network)) != null) {
                return capabilities.hasTransport(1);
            }
        } else {
            NetworkInfo networkInfo = connectivityManager.getNetworkInfo(1);
            return networkInfo != null && networkInfo.isConnectedOrConnecting();
        }
        return false;
    }

    public static String getNetworkType(Context context) {
        try {
            if (!NetworkUtil.checkHasPermission(context, "android.permission.ACCESS_NETWORK_STATE")) {
                return "unknow";
            }
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            if (connectivityManager != null && !NetworkUtil.isNetworkAvailable(connectivityManager)) {
                return "unknow";
            }
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            return NetworkUtil.mobileNetworkType(context, telephonyManager, connectivityManager);
        }
        catch (Exception e) {
            TapLogger.logd(TAG, e);
            return "unknow";
        }
    }

    @SuppressLint(value={"NewApi", "WrongConstant"})
    public static boolean isNetworkValid(NetworkCapabilities capabilities) {
        if (capabilities != null) {
            return capabilities.hasTransport(1) || capabilities.hasTransport(0) || capabilities.hasTransport(3) || capabilities.hasTransport(7) || capabilities.hasTransport(4) || capabilities.hasCapability(16);
        }
        return false;
    }

    @SuppressLint(value={"MissingPermission"})
    private static boolean isNetworkAvailable(ConnectivityManager connectivityManager) {
        if (connectivityManager != null) {
            if (Build.VERSION.SDK_INT >= 23) {
                NetworkCapabilities capabilities;
                Network network = connectivityManager.getActiveNetwork();
                if (network != null && (capabilities = connectivityManager.getNetworkCapabilities(network)) != null) {
                    return NetworkUtil.isNetworkValid(capabilities);
                }
            } else {
                NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
                return networkInfo != null && networkInfo.isConnected();
            }
        }
        return false;
    }

    @SuppressLint(value={"MissingPermission"})
    public static boolean isNetworkAvailable(Context context) {
        if (context == null) {
            return true;
        }
        ConnectivityManager manager = (ConnectivityManager)context.getApplicationContext().getSystemService("connectivity");
        if (manager == null) {
            return false;
        }
        NetworkInfo networkinfo = manager.getActiveNetworkInfo();
        return networkinfo != null && networkinfo.isAvailable();
    }

    @SuppressLint(value={"MissingPermission"})
    private static String mobileNetworkType(Context context, TelephonyManager telephonyManager, ConnectivityManager connectivityManager) {
        int networkType = 0;
        if (telephonyManager != null) {
            if (Build.VERSION.SDK_INT >= 30 && (NetworkUtil.checkHasPermission(context, "android.permission.READ_PHONE_STATE") || telephonyManager.hasCarrierPrivileges())) {
                networkType = telephonyManager.getDataNetworkType();
            } else {
                try {
                    networkType = telephonyManager.getNetworkType();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (networkType == 0) {
            NetworkInfo networkInfo;
            if (Build.VERSION.SDK_INT >= 30) {
                return "3";
            }
            if (connectivityManager != null && (networkInfo = connectivityManager.getActiveNetworkInfo()) != null) {
                networkType = networkInfo.getSubtype();
            }
        }
        switch (networkType) {
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: {
                return "2G";
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                return "3G";
            }
            case 13: 
            case 18: 
            case 19: {
                return "4G";
            }
            case 20: {
                return "5G";
            }
        }
        return "unknow";
    }
}

