/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.common.network.convert;

import com.taptap.sdk.base.network.annotation.Transform;
import com.taptap.sdk.base.network.transform.BizTransformer;
import com.taptap.sdk.common.network.transform.DefaultBizTransformer;
import com.taptap.sdk.okhttp3.MediaType;
import com.taptap.sdk.okhttp3.ResponseBody;
import com.taptap.sdk.retrofit2.Converter;
import com.taptap.sdk.retrofit2.Retrofit;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u001b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u000f2\u00020\u0001:\u0002\u000e\u000fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J9\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0002\b\u0003\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u0010"}, d2={"Lcom/taptap/sdk/common/network/convert/BizConverterFactory;", "Lcom/taptap/sdk/retrofit2/Converter$Factory;", "()V", "responseBodyConverter", "Lcom/taptap/sdk/retrofit2/Converter;", "Lcom/taptap/sdk/okhttp3/ResponseBody;", "returnType", "Ljava/lang/reflect/Type;", "annotations", "", "", "retrofit", "Lcom/taptap/sdk/retrofit2/Retrofit;", "(Ljava/lang/reflect/Type;[Ljava/lang/annotation/Annotation;Lcom/taptap/sdk/retrofit2/Retrofit;)Lcom/taptap/sdk/retrofit2/Converter;", "BizConverter", "Companion", "tap-common_release"})
public final class BizConverterFactory
extends Converter.Factory {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private BizConverterFactory() {
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Converter<ResponseBody, ?> responseBodyConverter(@NotNull Type returnType, @NotNull Annotation[] annotations, @NotNull Retrofit retrofit) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)returnType, (String)"returnType");
        Intrinsics.checkNotNullParameter((Object)annotations, (String)"annotations");
        Intrinsics.checkNotNullParameter((Object)retrofit, (String)"retrofit");
        Annotation[] $this$filterIsInstance$iv = annotations;
        boolean $i$f$filterIsInstance = false;
        Annotation[] annotationArray = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof Transform)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Transform transform = (Transform)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
        KClass transformKlass = transform != null ? Reflection.getOrCreateKotlinClass((Class)transform.klass()) : Reflection.getOrCreateKotlinClass(DefaultBizTransformer.class);
        Converter converter = retrofit.nextResponseBodyConverter((Converter.Factory)this, returnType, annotations);
        if (converter == null) {
            return null;
        }
        Converter delegate = converter;
        return new BizConverter((KClass<? extends BizTransformer>)transformKlass, delegate);
    }

    public /* synthetic */ BizConverterFactory(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u0002B'\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u0012\u0010\u0010\u0007\u001a\f\u0012\u0004\u0012\u00020\u0003\u0012\u0002\b\u00030\u0002\u00a2\u0006\u0002\u0010\bJ\u0017\u0010\t\u001a\u0004\u0018\u00018\u00002\u0006\u0010\n\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\f\u001a\u00020\u00062\u000e\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u000eH\u0002R\u0018\u0010\u0007\u001a\f\u0012\u0004\u0012\u00020\u0003\u0012\u0002\b\u00030\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/taptap/sdk/common/network/convert/BizConverterFactory$BizConverter;", "T", "Lcom/taptap/sdk/retrofit2/Converter;", "Lcom/taptap/sdk/okhttp3/ResponseBody;", "klass", "Lkotlin/reflect/KClass;", "Lcom/taptap/sdk/base/network/transform/BizTransformer;", "delegate", "(Lkotlin/reflect/KClass;Lcom/taptap/sdk/retrofit2/Converter;)V", "convert", "value", "(Lcom/taptap/sdk/okhttp3/ResponseBody;)Ljava/lang/Object;", "createTransformerByReflect", "clazz", "Ljava/lang/Class;", "tap-common_release"})
    private static final class BizConverter<T>
    implements Converter<ResponseBody, T> {
        @NotNull
        private final KClass<? extends BizTransformer> klass;
        @NotNull
        private final Converter<ResponseBody, ?> delegate;

        public BizConverter(@NotNull KClass<? extends BizTransformer> klass, @NotNull Converter<ResponseBody, ?> delegate) {
            Intrinsics.checkNotNullParameter(klass, (String)"klass");
            Intrinsics.checkNotNullParameter(delegate, (String)"delegate");
            this.klass = klass;
            this.delegate = delegate;
        }

        @Nullable
        public T convert(@NotNull ResponseBody value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            BizTransformer bizTransformer = this.createTransformerByReflect(JvmClassMappingKt.getJavaClass(this.klass));
            InputStream inputStream = value.byteStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"value.byteStream()");
            byte[] inputStream2 = ByteStreamsKt.readBytes((InputStream)bizTransformer.transform(inputStream));
            boolean bl = false;
            ResponseBody responseBody = ResponseBody.create((MediaType)value.contentType(), (byte[])inputStream2);
            boolean bl2 = false;
            return (T)this.delegate.convert((Object)responseBody);
        }

        private final BizTransformer createTransformerByReflect(Class<? extends BizTransformer> clazz) {
            BizTransformer bizTransformer = clazz.newInstance();
            Intrinsics.checkNotNullExpressionValue((Object)bizTransformer, (String)"clazz.newInstance()");
            return bizTransformer;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lcom/taptap/sdk/common/network/convert/BizConverterFactory$Companion;", "", "()V", "create", "Lcom/taptap/sdk/retrofit2/Converter$Factory;", "tap-common_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Converter.Factory create() {
            return new BizConverterFactory(null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

