/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.common.network.retry;

import android.util.Log;
import com.taptap.sdk.common.network.retry.RetryStrategy;
import com.taptap.sdk.common.network.retry.RetryUtils;
import com.taptap.sdk.common.network.throwable.ApiErr;
import com.taptap.sdk.common.network.throwable.TapNetworkException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.DelayKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0003\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0004H\u0002JK\u0010\r\u001a\u0002H\u000e\"\u0004\b\u0000\u0010\u000e2\b\b\u0002\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00042\u001c\u0010\u0010\u001a\u0018\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000e0\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0011H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0013J?\u0010\r\u001a\u0002H\u000e\"\u0004\b\u0000\u0010\u000e2\b\b\u0002\u0010\t\u001a\u00020\n2\u001c\u0010\u0010\u001a\u0018\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000e0\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0011H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0019"}, d2={"Lcom/taptap/sdk/common/network/retry/RetryUtils;", "", "()V", "TAG", "", "requestCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "calculateNextDelay", "", "strategy", "Lcom/taptap/sdk/common/network/retry/RetryStrategy;", "currentDelay", "requestId", "retry", "T", "requestLabel", "block", "Lkotlin/Function1;", "Lkotlin/coroutines/Continuation;", "(Lcom/taptap/sdk/common/network/retry/RetryStrategy;Ljava/lang/String;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "(Lcom/taptap/sdk/common/network/retry/RetryStrategy;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "shouldRetry", "", "error", "", "tap-common_release"})
public final class RetryUtils {
    @NotNull
    public static final RetryUtils INSTANCE = new RetryUtils();
    @NotNull
    private static final String TAG = "RetryUtils";
    @NotNull
    private static final AtomicInteger requestCounter = new AtomicInteger(0);

    private RetryUtils() {
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final <T> Object retry(@NotNull RetryStrategy var1_1, @Nullable String var2_2, @NotNull Function1<? super Continuation<? super T>, ? extends Object> var3_3, @NotNull Continuation<? super T> var4_4) throws Throwable {
        if (!(var4_4 instanceof retry.1)) ** GOTO lbl-1000
        var11_5 = var4_4;
        if ((var11_5.label & -2147483648) != 0) {
            var11_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var4_4){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                int I$0;
                long J$0;
                /* synthetic */ Object result;
                final /* synthetic */ RetryUtils this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.retry(null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var12_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                retryCount = 0;
                v0 = requestLabel;
                if (v0 == null) {
                    v0 = requestId = "req_" + RetryUtils.requestCounter.incrementAndGet();
                }
                if ((var9_10 = strategy) instanceof RetryStrategy.NoRetry) {
                    v1 = 0L;
                } else if (var9_10 instanceof RetryStrategy.Fixed) {
                    v1 = ((RetryStrategy.Fixed)strategy).getIntervalMillis();
                } else if (var9_10 instanceof RetryStrategy.Exponential) {
                    v1 = ((RetryStrategy.Exponential)strategy).getInitialIntervalMillis();
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                nextDelayInMillis = v1;
lbl28:
                // 2 sources

                while (true) {
                    $continuation.L$0 = this;
                    $continuation.L$1 = strategy;
                    $continuation.L$2 = block;
                    $continuation.L$3 = requestId;
                    $continuation.I$0 = retryCount;
                    $continuation.J$0 = nextDelayInMillis;
                    $continuation.label = 1;
                    v2 = block.invoke($continuation);
                    ** if (v2 != var12_7) goto lbl41
lbl40:
                    // 1 sources

                    return var12_7;
lbl41:
                    // 1 sources

                    ** GOTO lbl53
                    break;
                }
            }
            case 1: {
                nextDelayInMillis = $continuation.J$0;
                retryCount = $continuation.I$0;
                requestId = (String)$continuation.L$3;
                block = (Function1)$continuation.L$2;
                strategy = (RetryStrategy)$continuation.L$1;
                this = (RetryUtils)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl53:
                    // 2 sources

                    return v2;
                }
                catch (Throwable error) {
                    if (!this.shouldRetry(error)) {
                        throw error;
                    }
                    if (strategy instanceof RetryStrategy.Fixed && retryCount >= ((RetryStrategy.Fixed)strategy).getMaxCount()) {
                        throw new IllegalArgumentException("\u8bf7\u6c42\u5931\u8d25\uff0c\u5df2\u8fbe\u5230\u6700\u5927\u91cd\u8bd5\u6b21\u6570: " + ((RetryStrategy.Fixed)strategy).getMaxCount());
                    }
                    Log.w((String)"RetryUtils", (String)('[' + requestId + "] \u7f51\u7edc\u8bf7\u6c42\u5931\u8d25\uff0c\u8fdb\u884c\u7b2c " + ++retryCount + " \u6b21\u91cd\u8bd5\uff0c\u5ef6\u8fdf: " + nextDelayInMillis + "ms"));
                    $continuation.L$0 = this;
                    $continuation.L$1 = strategy;
                    $continuation.L$2 = block;
                    $continuation.L$3 = requestId;
                    $continuation.I$0 = retryCount;
                    $continuation.J$0 = nextDelayInMillis;
                    $continuation.label = 2;
                    v3 = DelayKt.delay((long)nextDelayInMillis, $continuation);
                    if (v3 == var12_7) {
                        return var12_7;
                    }
                    ** GOTO lbl81
                }
            }
            case 2: {
                nextDelayInMillis = $continuation.J$0;
                retryCount = $continuation.I$0;
                requestId = (String)$continuation.L$3;
                block = (Function1)$continuation.L$2;
                strategy = (RetryStrategy)$continuation.L$1;
                this = (RetryUtils)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl81:
                // 2 sources

                nextDelayInMillis = this.calculateNextDelay(strategy, nextDelayInMillis, requestId);
                ** continue;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object retry$default(RetryUtils retryUtils, RetryStrategy retryStrategy, String string, Function1 function1, Continuation continuation, int n, Object object) throws Throwable {
        if ((n & 1) != 0) {
            retryStrategy = new RetryStrategy.Exponential(0L, 0L, 3, null);
        }
        if ((n & 2) != 0) {
            string = null;
        }
        return retryUtils.retry(retryStrategy, string, function1, continuation);
    }

    @Nullable
    public final <T> Object retry(@NotNull RetryStrategy strategy, @NotNull Function1<? super Continuation<? super T>, ? extends Object> block, @NotNull Continuation<? super T> $completion) throws Throwable {
        return this.retry(strategy, null, block, $completion);
    }

    public static /* synthetic */ Object retry$default(RetryUtils retryUtils, RetryStrategy retryStrategy, Function1 function1, Continuation continuation, int n, Object object) throws Throwable {
        if ((n & 1) != 0) {
            retryStrategy = new RetryStrategy.Exponential(0L, 0L, 3, null);
        }
        return retryUtils.retry(retryStrategy, function1, continuation);
    }

    private final long calculateNextDelay(RetryStrategy strategy, long currentDelay, String requestId) {
        long l;
        RetryStrategy retryStrategy = strategy;
        if (retryStrategy instanceof RetryStrategy.NoRetry) {
            l = 0L;
        } else if (retryStrategy instanceof RetryStrategy.Fixed) {
            l = currentDelay;
        } else if (retryStrategy instanceof RetryStrategy.Exponential) {
            long nextDelay = currentDelay * (long)2;
            long result = RangesKt.coerceAtMost((long)nextDelay, (long)((RetryStrategy.Exponential)strategy).getMaxIntervalMillis());
            Log.d((String)TAG, (String)('[' + requestId + "] \u4e0b\u6b21\u91cd\u8bd5\u5ef6\u8fdf\u8ba1\u7b97: " + currentDelay + " ms \u2192 " + result + " ms"));
            l = result;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return l;
    }

    private final boolean shouldRetry(Throwable error) {
        int n;
        Throwable throwable = error;
        return throwable instanceof TapNetworkException ? ((500 <= (n = ((TapNetworkException)error).getErr().getCode()) ? n < 600 : false) ? true : ((TapNetworkException)error).getErr().getApiErr() == ApiErr.INVALID_TIME) : (throwable instanceof SocketTimeoutException ? true : (throwable instanceof UnknownHostException ? true : (throwable instanceof ConnectException ? true : (throwable instanceof SSLHandshakeException ? true : throwable instanceof SSLException))));
    }
}

