/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.common.utils;

import android.content.Context;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004\u00a8\u0006\b"}, d2={"Lcom/taptap/sdk/common/utils/AssetUtils;", "", "()V", "readContentFromAssets", "", "context", "Landroid/content/Context;", "fileName", "tap-common_release"})
public final class AssetUtils {
    @NotNull
    public static final AssetUtils INSTANCE = new AssetUtils();

    private AssetUtils() {
    }

    @Nullable
    public final String readContentFromAssets(@NotNull Context context, @NotNull String fileName) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        try {
            InputStream inputStream = context.getAssets().open(fileName);
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"context.assets.open(fileName)");
            object = inputStream;
            Charset charset = Charsets.UTF_8;
            Reader reader = new InputStreamReader((InputStream)object, charset);
            int n = 8192;
            object = TextStreamsKt.readText((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)));
        }
        catch (Exception _) {
            object = null;
        }
        return object;
    }
}

