/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.kit.internal.enginebridge.internal;

import android.app.Activity;
import android.support.annotation.Keep;
import android.text.TextUtils;
import com.taptap.sdk.kit.internal.TapLogger;
import com.taptap.sdk.kit.internal.enginebridge.EngineBridge;
import com.taptap.sdk.kit.internal.enginebridge.EngineBridgeCallback;
import com.taptap.sdk.kit.internal.enginebridge.IEngineBridgeService;
import com.taptap.sdk.kit.internal.enginebridge.annotation.EngineBridgeParams;
import com.taptap.sdk.kit.internal.enginebridge.annotation.EngineBridgeService;
import com.taptap.sdk.kit.internal.enginebridge.command.Command;
import com.taptap.sdk.kit.internal.enginebridge.exception.BridgeExceptionMessage;
import com.taptap.sdk.kit.internal.enginebridge.exception.EngineBridgeException;
import com.taptap.sdk.kit.internal.enginebridge.internal.BridgeHolder;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c1\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u000b\u001a\u00020\b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rJ-\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\u0002\u0010\u0014J\u001d\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u00a2\u0006\u0002\u0010\u0018J\u0018\u0010\u0019\u001a\u0004\u0018\u00010\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001b0\r2\u0006\u0010\u0005\u001a\u00020\u0006J\u001c\u0010\u001c\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u001b\u0018\u00010\r2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\r\u00a8\u0006\u001e"}, d2={"Lcom/taptap/sdk/kit/internal/enginebridge/internal/EngineBridgeReflector;", "", "()V", "checkCommand", "", "command", "Lcom/taptap/sdk/kit/internal/enginebridge/command/Command;", "checkParamsMatchMethod", "", "jsonObject", "Lorg/json/JSONObject;", "checkServiceValid", "serviceClz", "Ljava/lang/Class;", "constructorCommandArgs", "", "method", "Ljava/lang/reflect/Method;", "callback", "Lcom/taptap/sdk/kit/internal/enginebridge/EngineBridgeCallback;", "(Ljava/lang/reflect/Method;Lcom/taptap/sdk/kit/internal/enginebridge/command/Command;Lcom/taptap/sdk/kit/internal/enginebridge/EngineBridgeCallback;)[Ljava/lang/Object;", "filterArray", "jsonArray", "Lorg/json/JSONArray;", "(Lorg/json/JSONArray;)[Ljava/lang/Object;", "findParams", "getRegisteredService", "Lcom/taptap/sdk/kit/internal/enginebridge/IEngineBridgeService;", "getValidService", "clz", "tap-common_release"})
@Keep
public final class EngineBridgeReflector {
    @NotNull
    public static final EngineBridgeReflector INSTANCE = new EngineBridgeReflector();

    private EngineBridgeReflector() {
    }

    public final boolean checkServiceValid(@NotNull Class<?> serviceClz) {
        Intrinsics.checkNotNullParameter(serviceClz, (String)"serviceClz");
        if (serviceClz.getAnnotation(EngineBridgeService.class) == null) {
            return false;
        }
        return IEngineBridgeService.class.isAssignableFrom(serviceClz);
    }

    @Nullable
    public final Class<? extends IEngineBridgeService> getValidService(@NotNull Class<?> clz) {
        Intrinsics.checkNotNullParameter(clz, (String)"clz");
        Class<?>[] interfaceClz = clz.getInterfaces();
        Intrinsics.checkNotNullExpressionValue(interfaceClz, (String)"interfaceClz");
        for (Class<?> superClz : interfaceClz) {
            Intrinsics.checkNotNullExpressionValue(superClz, (String)"superClz");
            if (!this.checkServiceValid(superClz)) continue;
            return superClz;
        }
        throw new EngineBridgeException(BridgeExceptionMessage.COMMAND_SERVICE_ERROR.getMessage());
    }

    public final void checkCommand(@NotNull Command command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        if (((CharSequence)command.getService()).length() == 0 || ((CharSequence)command.getMethod()).length() == 0) {
            throw new EngineBridgeException(BridgeExceptionMessage.COMMAND_PARSE_ERROR.getMessage());
        }
    }

    @NotNull
    public final Class<? extends IEngineBridgeService> getRegisteredService(@NotNull Command command) {
        boolean isServiceRegister;
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Class<? extends IEngineBridgeService> serviceClz = BridgeHolder.INSTANCE.getBridgeService(command.getService()).getKey();
        EngineBridgeService serviceName = serviceClz.getAnnotation(EngineBridgeService.class);
        boolean bl = isServiceRegister = serviceName != null && Intrinsics.areEqual((Object)serviceName.value(), (Object)command.getService());
        if (isServiceRegister) {
            return serviceClz;
        }
        throw new EngineBridgeException(BridgeExceptionMessage.COMMAND_SERVICE_ERROR.getMessage());
    }

    @NotNull
    public final Object[] constructorCommandArgs(@NotNull Method method, @NotNull Command command, @Nullable EngineBridgeCallback callback2) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Class<?>[] parameterTypes = method.getParameterTypes();
        Object[] args = new Object[parameterTypes.length];
        int originParamsCount = 0;
        TapLogger.logi("TAP_ENGINE_BRIDGE", "construct command: command=" + command + ", args=" + command.getArgs());
        try {
            JSONObject jsonObject = null;
            if (TextUtils.isEmpty((CharSequence)command.getArgs())) {
                jsonObject = new JSONObject();
            } else {
                jsonObject = new JSONObject(command.getArgs());
                originParamsCount = jsonObject.length();
            }
            for (Class<?> paramsClz : parameterTypes) {
                Class<?> clazz = paramsClz;
                if (Intrinsics.areEqual(clazz, Activity.class)) {
                    args[i] = EngineBridge.INSTANCE.getCurrentActivity$tap_common_release();
                    ++originParamsCount;
                    continue;
                }
                if (Intrinsics.areEqual(clazz, EngineBridgeCallback.class)) {
                    if (callback2 == null) {
                        throw new EngineBridgeException(BridgeExceptionMessage.COMMAND_ARGS_ERROR.getExtraMessage("callback is null"));
                    }
                    args[i] = callback2;
                    ++originParamsCount;
                    continue;
                }
                args[i] = this.findParams(jsonObject, method);
            }
            TapLogger.logi("TAP_ENGINE_BRIDGE", "construct command over: command=" + command + ", args=" + command.getArgs());
            if (!this.checkParamsMatchMethod(jsonObject) || originParamsCount != args.length) {
                return new Object[0];
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return args;
    }

    private final boolean checkParamsMatchMethod(JSONObject jsonObject) {
        return jsonObject.length() == 0;
    }

    @Nullable
    public final Object findParams(@NotNull JSONObject jsonObject, @NotNull Method method) throws JSONException {
        Intrinsics.checkNotNullParameter((Object)jsonObject, (String)"jsonObject");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        TapLogger.logi("TAP_ENGINE_BRIDGE", "findParams: jsonObject=" + jsonObject + ", method=" + method);
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        Intrinsics.checkNotNullExpressionValue((Object)parameterAnnotations, (String)"parameterAnnotations");
        Annotation[][] annotationArray = parameterAnnotations;
        int n = ((Object[])annotationArray).length;
        for (int i = 0; i < n; ++i) {
            Annotation[] annotations = annotationArray[i];
            Intrinsics.checkNotNullExpressionValue((Object)annotations, (String)"annotations");
            for (Annotation annotation : annotations) {
                if (!(annotation instanceof EngineBridgeParams) || !jsonObject.has(((EngineBridgeParams)annotation).value())) continue;
                Object args = jsonObject.get(((EngineBridgeParams)annotation).value());
                jsonObject.remove(((EngineBridgeParams)annotation).value());
                if (args == JSONObject.NULL) {
                    TapLogger.logi("TAP_ENGINE_BRIDGE", " method " + method.getDeclaringClass().getName() + '.' + method.getName() + " param " + ((EngineBridgeParams)annotation).value() + " convert jsonNull to null");
                    args = null;
                }
                if (args instanceof JSONArray) {
                    return this.filterArray((JSONArray)args);
                }
                return args;
            }
        }
        return null;
    }

    private final Object[] filterArray(JSONArray jsonArray) throws JSONException {
        Object[] objectArray;
        Class<?> clazz;
        int len = jsonArray.length();
        TapLogger.logi("TAP_ENGINE_BRIDGE", "filterArray: jsonArray=" + jsonArray);
        Class<?> clazz2 = clazz = jsonArray.get(0).getClass();
        if (Intrinsics.areEqual(clazz2, Boolean.TYPE)) {
            List result = new ArrayList();
            for (int i = 0; i < len; ++i) {
                result.add(jsonArray.getBoolean(i));
            }
            Collection $this$toTypedArray$iv = result;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            objectArray = thisCollection$iv.toArray(new Boolean[0]);
        } else if (Intrinsics.areEqual(clazz2, Integer.TYPE)) {
            List result = new ArrayList();
            for (int i = 0; i < len; ++i) {
                result.add(jsonArray.getInt(i));
            }
            Collection $this$toTypedArray$iv = result;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            objectArray = thisCollection$iv.toArray(new Integer[0]);
        } else if (Intrinsics.areEqual(clazz2, Long.TYPE)) {
            List result = new ArrayList();
            for (int i = 0; i < len; ++i) {
                result.add(jsonArray.getLong(i));
            }
            Collection $this$toTypedArray$iv = result;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            objectArray = thisCollection$iv.toArray(new Long[0]);
        } else if (Intrinsics.areEqual(clazz2, Float.TYPE)) {
            List result = new ArrayList();
            for (int i = 0; i < len; ++i) {
                result.add(Float.valueOf((float)jsonArray.getDouble(i)));
            }
            Collection $this$toTypedArray$iv = result;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            objectArray = thisCollection$iv.toArray(new Float[0]);
        } else if (Intrinsics.areEqual(clazz2, Double.TYPE)) {
            List result = new ArrayList();
            for (int i = 0; i < len; ++i) {
                result.add(jsonArray.getDouble(i));
            }
            Collection $this$toTypedArray$iv = result;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            objectArray = thisCollection$iv.toArray(new Double[0]);
        } else if (Intrinsics.areEqual(clazz2, String.class)) {
            List result = new ArrayList();
            for (int i = 0; i < len; ++i) {
                String string = jsonArray.getString(i);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jsonArray.getString(i)");
                result.add(string);
            }
            Collection $this$toTypedArray$iv = result;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            objectArray = thisCollection$iv.toArray(new String[0]);
        } else {
            throw new EngineBridgeException(BridgeExceptionMessage.COMMAND_ARGS_ERROR.getExtraMessage("\u6570\u7ec4\u7c7b\u578b\u7684\u53c2\u6570\u5fc5\u987b\u4e3a\u57fa\u7840\u6570\u636e\u7c7b\u578b!"));
        }
        return objectArray;
    }
}

