/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.kit.internal.executor;

import android.os.Handler;
import android.os.Looper;
import com.taptap.sdk.kit.internal.executor.TapNetExecutor;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\b\u0010\u001c\u001a\u00020\nH\u0007J\b\u0010\u001d\u001a\u00020\u0012H\u0007J\b\u0010\u001e\u001a\u00020\nH\u0003J\b\u0010\u0016\u001a\u00020\u0017H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0011\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u000e\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/taptap/sdk/kit/internal/executor/TapNetExecutor;", "", "()V", "CORE_POOL_SIZE", "", "CPU_COUNT", "KEEP_ALIVE_TIME", "", "MAX_POOL_SIZE", "executorService", "Ljava/util/concurrent/ExecutorService;", "getExecutorService", "()Ljava/util/concurrent/ExecutorService;", "executorService$delegate", "Lkotlin/Lazy;", "sThreadFactory", "Ljava/util/concurrent/ThreadFactory;", "scheduledExecutorService", "Ljava/util/concurrent/ScheduledExecutorService;", "getScheduledExecutorService", "()Ljava/util/concurrent/ScheduledExecutorService;", "scheduledExecutorService$delegate", "uiThread", "Ljava/util/concurrent/Executor;", "executeUIThread", "", "command", "Ljava/lang/Runnable;", "getExecutor", "getScheduledExecutor", "newThreadPoolExecutor", "UIThreadExecutor", "tap-common_release"})
public final class TapNetExecutor {
    @NotNull
    public static final TapNetExecutor INSTANCE = new TapNetExecutor();
    @NotNull
    private static final Lazy executorService$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)executorService.2.INSTANCE);
    @NotNull
    private static final Lazy scheduledExecutorService$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)scheduledExecutorService.2.INSTANCE);
    @NotNull
    private static final Executor uiThread = new UIThreadExecutor();
    private static final int CPU_COUNT = Runtime.getRuntime().availableProcessors();
    private static final int CORE_POOL_SIZE = CPU_COUNT + 1;
    private static final int MAX_POOL_SIZE = CPU_COUNT * 2 + 1;
    private static final long KEEP_ALIVE_TIME = 1L;
    @NotNull
    private static final ThreadFactory sThreadFactory = new ThreadFactory(){
        @NotNull
        private final AtomicInteger mCount;
        {
            this.mCount = new AtomicInteger(1);
        }

        @NotNull
        public Thread newThread(@NotNull Runnable r) {
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            return new Thread(r, "TapHttpAsyncTask #" + this.mCount.getAndIncrement());
        }
    };

    private TapNetExecutor() {
    }

    private final ExecutorService getExecutorService() {
        Lazy lazy = executorService$delegate;
        return (ExecutorService)lazy.getValue();
    }

    private final ScheduledExecutorService getScheduledExecutorService() {
        Lazy lazy = scheduledExecutorService$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-scheduledExecutorService>(...)");
        return (ScheduledExecutorService)object;
    }

    @JvmStatic
    @NotNull
    public static final ExecutorService getExecutor() {
        return INSTANCE.getExecutorService();
    }

    @JvmStatic
    @NotNull
    public static final ScheduledExecutorService getScheduledExecutor() {
        return INSTANCE.getScheduledExecutorService();
    }

    @JvmStatic
    @NotNull
    public static final Executor uiThread() {
        return uiThread;
    }

    @JvmStatic
    public static final void executeUIThread(@NotNull Runnable command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        uiThread.execute(command);
    }

    @JvmStatic
    private static final ExecutorService newThreadPoolExecutor() {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(CORE_POOL_SIZE, MAX_POOL_SIZE, 1L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)new LinkedBlockingQueue(), sThreadFactory);
        executor.allowCoreThreadTimeOut(true);
        return executor;
    }

    public static final /* synthetic */ ExecutorService access$newThreadPoolExecutor() {
        return TapNetExecutor.newThreadPoolExecutor();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/taptap/sdk/kit/internal/executor/TapNetExecutor$UIThreadExecutor;", "Ljava/util/concurrent/Executor;", "()V", "execute", "", "command", "Ljava/lang/Runnable;", "tap-common_release"})
    private static final class UIThreadExecutor
    implements Executor {
        @Override
        public void execute(@NotNull Runnable command) {
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            new Handler(Looper.getMainLooper()).post(command);
        }
    }
}

