/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.kit.internal.http.hanlder;

import com.taptap.sdk.common.services.AuthorizationService;
import com.taptap.sdk.kit.internal.TapTapKit;
import com.taptap.sdk.kit.internal.http.TapHttpUtil;
import com.taptap.sdk.kit.internal.http.TapTime;
import com.taptap.sdk.kit.internal.http.hanlder.ITapHttpSign;
import com.taptap.sdk.kit.internal.http.hanlder.TapHttpSign;
import com.taptap.sdk.kit.internal.http.hanlder.TapHttpSign$Default$special$;
import com.taptap.sdk.kit.internal.identifier.TapIdentifierUtil;
import com.taptap.sdk.kit.internal.utils.PlatformXUA;
import com.taptap.sdk.kit.internal.utils.localize.TapLocalizeUtil;
import com.taptap.sdk.servicemanager.utils.ServiceManagerComponent;
import java.net.URL;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\u0018\u0000 \u00032\u00020\u0001:\u0003\u0003\u0004\u0005B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0006"}, d2={"Lcom/taptap/sdk/kit/internal/http/hanlder/TapHttpSign;", "", "()V", "Companion", "Default", "None", "tap-common_release"})
public final class TapHttpSign {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String QUERY_CLIENT_ID = "client_id";

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/taptap/sdk/kit/internal/http/hanlder/TapHttpSign$Companion;", "", "()V", "QUERY_CLIENT_ID", "", "tap-common_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J$\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\r2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J,\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000bH\u0016J$\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\r2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u001d\u0010\u0003\u001a\u0004\u0018\u00010\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lcom/taptap/sdk/kit/internal/http/hanlder/TapHttpSign$Default;", "Lcom/taptap/sdk/kit/internal/http/hanlder/ITapHttpSign;", "()V", "authorizationService", "Lcom/taptap/sdk/common/services/AuthorizationService;", "getAuthorizationService", "()Lcom/taptap/sdk/common/services/AuthorizationService;", "authorizationService$delegate", "Lkotlin/Lazy;", "getFixQueryParams", "", "", "getGetHeaders", "", "moduleName", "moduleVersion", "getHeaders", "method", "getPostHeaders", "handle", "", "data", "Lcom/taptap/sdk/kit/internal/http/hanlder/ITapHttpSign$HandleData;", "tap-common_release"})
    public static final class Default
    implements ITapHttpSign {
        @NotNull
        private final Lazy authorizationService$delegate;

        public Default() {
            ServiceManagerComponent this_$iv = ServiceManagerComponent.INSTANCE;
            boolean $i$f$injectOrNull = false;
            this.authorizationService$delegate = LazyKt.lazy((Function0)Default$special$$inlined$injectOrNull$1.INSTANCE);
        }

        private final AuthorizationService getAuthorizationService() {
            Lazy lazy = this.authorizationService$delegate;
            return (AuthorizationService)lazy.getValue();
        }

        @Override
        @NotNull
        public Map<String, String> getFixQueryParams() {
            Map map;
            Map $this$getFixQueryParams_u24lambda_u240 = map = (Map)new LinkedHashMap();
            boolean bl = false;
            $this$getFixQueryParams_u24lambda_u240.put(TapHttpSign.QUERY_CLIENT_ID, TapTapKit.INSTANCE.getClientId$tap_common_release());
            return map;
        }

        @Override
        @NotNull
        public Map<String, String> getHeaders(@NotNull String moduleName, @NotNull String moduleVersion, @NotNull String method) {
            Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
            Intrinsics.checkNotNullParameter((Object)moduleVersion, (String)"moduleVersion");
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            String string = method;
            return Intrinsics.areEqual((Object)string, (Object)"POST") ? this.getPostHeaders(moduleName, moduleVersion) : (Intrinsics.areEqual((Object)string, (Object)"GET") ? this.getGetHeaders(moduleName, moduleVersion) : MapsKt.emptyMap());
        }

        private final Map<String, String> getGetHeaders(String moduleName, String moduleVersion) {
            Object object;
            block2: {
                object = new Pair[10];
                object[0] = TuplesKt.to((Object)"X-Tap-PN", (Object)"TapSDK");
                String string = TapIdentifierUtil.INSTANCE.getDeviceId(TapTapKit.INSTANCE.getContext());
                if (string == null) {
                    string = "";
                }
                object[1] = TuplesKt.to((Object)"X-Tap-Device-Id", (Object)string);
                object[2] = TuplesKt.to((Object)"X-Tap-Platform", (Object)"Android");
                object[3] = TuplesKt.to((Object)"X-Tap-SDK-Module", (Object)moduleName);
                object[4] = TuplesKt.to((Object)"X-Tap-SDK-Module-Version", (Object)moduleVersion);
                object[5] = TuplesKt.to((Object)"X-Tap-SDK-Artifact", (Object)PlatformXUA.getTrackSDKArtifact());
                object[6] = TuplesKt.to((Object)"X-Tap-Ts", (Object)String.valueOf(TapTime.INSTANCE.getCurrentTimeInMillis() / (long)1000));
                object[7] = TuplesKt.to((Object)"X-Tap-Nonce", (Object)TapHttpUtil.INSTANCE.getRandomString(10));
                object[8] = TuplesKt.to((Object)"X-Tap-Lang", (Object)TapLocalizeUtil.getPreferredLanguage().getLanguage());
                object[9] = TuplesKt.to((Object)"User-Agent", (Object)PlatformXUA.getTrackUA());
                Object $this$getGetHeaders_u24lambda_u242 = object = MapsKt.mutableMapOf((Pair[])object);
                boolean bl = false;
                String string2 = TapIdentifierUtil.INSTANCE.getGameUserId();
                if (string2 == null) break block2;
                String it = string2;
                boolean bl2 = false;
                if (((CharSequence)it).length() > 0) {
                    $this$getGetHeaders_u24lambda_u242.put("X-Tap-SDK-Game-User-Id", it);
                }
            }
            return object;
        }

        private final Map<String, String> getPostHeaders(String moduleName, String moduleVersion) {
            Object object;
            block2: {
                object = new Pair[10];
                object[0] = TuplesKt.to((Object)"X-Tap-PN", (Object)"TapSDK");
                String string = TapIdentifierUtil.INSTANCE.getDeviceId(TapTapKit.INSTANCE.getContext());
                if (string == null) {
                    string = "";
                }
                object[1] = TuplesKt.to((Object)"X-Tap-Device-Id", (Object)string);
                object[2] = TuplesKt.to((Object)"X-Tap-Platform", (Object)"Android");
                object[3] = TuplesKt.to((Object)"X-Tap-SDK-Module", (Object)moduleName);
                object[4] = TuplesKt.to((Object)"X-Tap-SDK-Module-Version", (Object)moduleVersion);
                object[5] = TuplesKt.to((Object)"X-Tap-SDK-Artifact", (Object)PlatformXUA.getTrackSDKArtifact());
                object[6] = TuplesKt.to((Object)"X-Tap-Ts", (Object)String.valueOf(TapTime.INSTANCE.getCurrentTimeInMillis() / (long)1000));
                object[7] = TuplesKt.to((Object)"X-Tap-Nonce", (Object)TapHttpUtil.INSTANCE.getRandomString(10));
                object[8] = TuplesKt.to((Object)"X-Tap-Lang", (Object)TapLocalizeUtil.getPreferredLanguage().getLanguage());
                object[9] = TuplesKt.to((Object)"User-Agent", (Object)PlatformXUA.getTrackUA());
                Object $this$getPostHeaders_u24lambda_u244 = object = MapsKt.mutableMapOf((Pair[])object);
                boolean bl = false;
                String string2 = TapIdentifierUtil.INSTANCE.getGameUserId();
                if (string2 == null) break block2;
                String it = string2;
                boolean bl2 = false;
                if (((CharSequence)it).length() > 0) {
                    $this$getPostHeaders_u24lambda_u244.put("X-Tap-SDK-Game-User-Id", it);
                }
            }
            return object;
        }

        @Override
        public void handle(@NotNull ITapHttpSign.HandleData data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            if (data.getEnableAuthorization() && !data.getHeaders().containsKey("Authorization")) {
                String executeResult;
                AuthorizationService authorizationService = this.getAuthorizationService();
                String string = executeResult = authorizationService != null ? authorizationService.obtainAuthorization(data.getUrl(), data.getMethod()) : null;
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    data.getHeaders().put("Authorization", it);
                }
            }
            URL urlObj = new URL(data.getUrl());
            String pathAndQuery = urlObj.getPath() + (urlObj.getQuery() != null ? '?' + urlObj.getQuery() : "");
            Map<String, String> $this$filterKeys$iv = data.getHeaders();
            boolean $i$f$filterKeys = false;
            LinkedHashMap<String, String> result$iv = new LinkedHashMap<String, String>();
            for (Map.Entry<String, String> entry$iv : $this$filterKeys$iv.entrySet()) {
                String it = entry$iv.getKey();
                boolean bl = false;
                String string = it.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                if (!StringsKt.startsWith$default((String)string, (String)"x-tap-", (boolean)false, (int)2, null)) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            Iterable $this$sortedBy$iv = ((Map)result$iv).entrySet();
            boolean $i$f$sortedBy = false;
            String filteredHeaders2 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Map.Entry it = (Map.Entry)a;
                    boolean bl = false;
                    String string = ((String)it.getKey()).toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                    it = (Map.Entry)b;
                    Comparable comparable = (Comparable)((Object)string);
                    bl = false;
                    String string2 = ((String)it.getKey()).toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string2)));
                }
            }), (CharSequence)"\n", null, null, (int)0, null, (Function1)handle.filteredHeaders.3.INSTANCE, (int)30, null);
            String bodyString = new String(data.getCompressContent(), Charsets.UTF_8);
            String stringToSign = data.getMethod() + '\n' + pathAndQuery + '\n' + filteredHeaders2 + '\n' + bodyString + '\n';
            String signature = TapHttpUtil.secret$default(TapHttpUtil.INSTANCE, TapTapKit.INSTANCE.getClientToken$tap_common_release(), stringToSign, null, 4, null);
            data.getHeaders().put("X-Tap-Sign", signature);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004H\u0016J,\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/taptap/sdk/kit/internal/http/hanlder/TapHttpSign$None;", "Lcom/taptap/sdk/kit/internal/http/hanlder/ITapHttpSign;", "()V", "getFixQueryParams", "", "", "getHeaders", "moduleName", "moduleVersion", "method", "handle", "", "data", "Lcom/taptap/sdk/kit/internal/http/hanlder/ITapHttpSign$HandleData;", "tap-common_release"})
    public static final class None
    implements ITapHttpSign {
        @Override
        @NotNull
        public Map<String, String> getFixQueryParams() {
            return MapsKt.emptyMap();
        }

        @Override
        @NotNull
        public Map<String, String> getHeaders(@NotNull String moduleName, @NotNull String moduleVersion, @NotNull String method) {
            Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
            Intrinsics.checkNotNullParameter((Object)moduleVersion, (String)"moduleVersion");
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            return MapsKt.emptyMap();
        }

        @Override
        public void handle(@NotNull ITapHttpSign.HandleData data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        }
    }
}

