/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.kit.internal.utils;

import android.annotation.SuppressLint;
import android.os.Build;
import android.text.TextUtils;
import java.lang.reflect.Method;
import java.util.Locale;

public class OSUtil {
    private static String customOS = "";
    private static String customOSVersion = "";
    private static final String KEY_HARMONYOS_VERSION_NAME = "hw_sc.build.platform.version";
    private static final String KEY_EMUI_VERSION_NAME = "ro.build.version.emui";
    private static final String KEY_MAGICUI_VERSION = "ro.build.version.magic";
    private static final String KEY_MIUI_VERSION_NAME = "ro.miui.ui.version.name";
    private static final String KEY_COLOROS_VERSION_NAME = "ro.build.version.opporom";
    private static final String KEY_VIVO_VERSION_NAME = "ro.vivo.os.name";
    private static final String KEY_VIVO_VERSION = "ro.vivo.os.version";
    private static final String KEY_ONEPLUS_VERSION_NAME = "ro.rom.version";
    private static final String KEY_FLYME_VERSION_NAME = "ro.build.display.id";
    private static final String KEY_NUBIA_VERSION_NAME = "ro.build.nubia.rom.name";
    private static final String KEY_NUBIA_VERSION_CODE = "ro.build.nubia.rom.code";

    @SuppressLint(value={"PrivateApi"})
    private static String getSystemPropertyValue(String key) {
        try {
            Class<?> classType = Class.forName("android.os.SystemProperties");
            Method getMethod = classType.getDeclaredMethod("get", String.class);
            String value = (String)getMethod.invoke(classType, key);
            return value;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static boolean isHarmonyOS() {
        try {
            Class<?> classType = Class.forName("com.huawei.system.BuildEx");
            Method getMethod = classType.getMethod("getOsBrand", new Class[0]);
            String value = (String)getMethod.invoke(classType, new Object[0]);
            return !TextUtils.isEmpty((CharSequence)value);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static String getCustomOS(String phoneBrand) {
        if (TextUtils.isEmpty((CharSequence)customOS)) {
            OSUtil.setCustomOSInfo(phoneBrand);
        }
        return customOS.toLowerCase(Locale.US);
    }

    public static String getCustomOSVersion(String phoneBrand) {
        if (TextUtils.isEmpty((CharSequence)customOS)) {
            OSUtil.setCustomOSInfo(phoneBrand);
        }
        return customOSVersion.toLowerCase(Locale.US);
    }

    public static String deleteSpaceAndToUpperCase(String str) {
        if (TextUtils.isEmpty((CharSequence)str)) {
            return "";
        }
        return str.replaceAll(" ", "").toUpperCase(Locale.US);
    }

    private static void setCustomOSInfo(String phoneBrand) {
        try {
            switch (OSUtil.deleteSpaceAndToUpperCase(phoneBrand)) {
                case "HUAWEI": {
                    if (OSUtil.isHarmonyOS()) {
                        customOSVersion = OSUtil.getSystemPropertyValue(KEY_HARMONYOS_VERSION_NAME);
                        customOS = "HarmonyOS";
                        break;
                    }
                    customOS = "EMUI";
                    customOSVersion = OSUtil.getSystemPropertyValue(KEY_EMUI_VERSION_NAME);
                    break;
                }
                case "HONOR": {
                    if (OSUtil.isHarmonyOS()) {
                        customOS = "HarmonyOS";
                        if (!TextUtils.isEmpty((CharSequence)OSUtil.getSystemPropertyValue(KEY_HARMONYOS_VERSION_NAME))) {
                            customOSVersion = OSUtil.getSystemPropertyValue(KEY_HARMONYOS_VERSION_NAME);
                            break;
                        }
                        customOSVersion = "";
                        break;
                    }
                    if (!TextUtils.isEmpty((CharSequence)OSUtil.getSystemPropertyValue(KEY_MAGICUI_VERSION))) {
                        customOS = "MagicUI";
                        customOSVersion = OSUtil.getSystemPropertyValue(KEY_MAGICUI_VERSION);
                        break;
                    }
                    customOS = "EMUI";
                    customOSVersion = OSUtil.getSystemPropertyValue(KEY_EMUI_VERSION_NAME);
                    break;
                }
                case "XIAOMI": 
                case "REDMI": {
                    customOS = "MIUI";
                    customOSVersion = OSUtil.getSystemPropertyValue(KEY_MIUI_VERSION_NAME);
                    break;
                }
                case "REALME": 
                case "OPPO": {
                    customOS = "ColorOS";
                    customOSVersion = OSUtil.getSystemPropertyValue(KEY_COLOROS_VERSION_NAME);
                    break;
                }
                case "VIVO": {
                    customOS = "Funtouch";
                    customOSVersion = OSUtil.getSystemPropertyValue(KEY_VIVO_VERSION);
                    break;
                }
                case "ONEPLUS": {
                    customOS = "HydrogenOS";
                    customOSVersion = OSUtil.getSystemPropertyValue(KEY_ONEPLUS_VERSION_NAME);
                    break;
                }
                case "MEIZU": {
                    customOS = "Flyme";
                    customOSVersion = OSUtil.getSystemPropertyValue(KEY_FLYME_VERSION_NAME);
                    break;
                }
                case "NUBIA": {
                    customOS = OSUtil.getSystemPropertyValue(KEY_NUBIA_VERSION_NAME);
                    customOSVersion = OSUtil.getSystemPropertyValue(KEY_NUBIA_VERSION_CODE);
                    break;
                }
                default: {
                    customOS = "Android";
                    customOSVersion = Build.VERSION.RELEASE;
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

