/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.common.network.convert;

import com.taptap.sdk.common.network.convert.ErrorHandlerCallFactory;
import com.taptap.sdk.common.network.data.response.BaseResponse;
import com.taptap.sdk.common.network.data.response.ErrResponse;
import com.taptap.sdk.common.network.throwable.ApiErr;
import com.taptap.sdk.common.network.throwable.TapNetworkException;
import com.taptap.sdk.common.network.utils.FixedTimeUtil;
import com.taptap.sdk.okhttp3.Request;
import com.taptap.sdk.okhttp3.ResponseBody;
import com.taptap.sdk.okio.Timeout;
import com.taptap.sdk.retrofit2.Call;
import com.taptap.sdk.retrofit2.CallAdapter;
import com.taptap.sdk.retrofit2.Callback;
import com.taptap.sdk.retrofit2.Response;
import com.taptap.sdk.retrofit2.Retrofit;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KType;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u001b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \r2\u00020\u0001:\u0003\r\u000e\u000fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0096\u0002\u00a2\u0006\u0002\u0010\f\u00a8\u0006\u0010"}, d2={"Lcom/taptap/sdk/common/network/convert/ErrorHandlerCallFactory;", "Lcom/taptap/sdk/retrofit2/CallAdapter$Factory;", "()V", "get", "Lcom/taptap/sdk/retrofit2/CallAdapter;", "returnType", "Ljava/lang/reflect/Type;", "annotations", "", "", "retrofit", "Lcom/taptap/sdk/retrofit2/Retrofit;", "(Ljava/lang/reflect/Type;[Ljava/lang/annotation/Annotation;Lcom/taptap/sdk/retrofit2/Retrofit;)Lcom/taptap/sdk/retrofit2/CallAdapter;", "Companion", "ErrorHandlingCall", "ErrorHandlingCallAdapter", "tap-common_release"})
public final class ErrorHandlerCallFactory
extends CallAdapter.Factory {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private ErrorHandlerCallFactory() {
    }

    @Nullable
    public CallAdapter<?, ?> get(@NotNull Type returnType, @NotNull Annotation[] annotations, @NotNull Retrofit retrofit) {
        Intrinsics.checkNotNullParameter((Object)returnType, (String)"returnType");
        Intrinsics.checkNotNullParameter((Object)annotations, (String)"annotations");
        Intrinsics.checkNotNullParameter((Object)retrofit, (String)"retrofit");
        Type responseType = CallAdapter.Factory.getParameterUpperBound((int)0, (ParameterizedType)((ParameterizedType)returnType));
        Intrinsics.checkNotNullExpressionValue((Object)responseType, (String)"responseType");
        return new ErrorHandlingCallAdapter(responseType);
    }

    public /* synthetic */ ErrorHandlerCallFactory(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00030\u0002B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003H\u0016J\b\u0010\u0004\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/taptap/sdk/common/network/convert/ErrorHandlerCallFactory$ErrorHandlingCallAdapter;", "T", "Lcom/taptap/sdk/retrofit2/CallAdapter;", "Lcom/taptap/sdk/retrofit2/Call;", "responseType", "Ljava/lang/reflect/Type;", "(Ljava/lang/reflect/Type;)V", "adapt", "call", "tap-common_release"})
    private static final class ErrorHandlingCallAdapter<T>
    implements CallAdapter<T, Call<T>> {
        @NotNull
        private final Type responseType;

        public ErrorHandlingCallAdapter(@NotNull Type responseType) {
            Intrinsics.checkNotNullParameter((Object)responseType, (String)"responseType");
            this.responseType = responseType;
        }

        @NotNull
        public Type responseType() {
            return this.responseType;
        }

        @NotNull
        public Call<T> adapt(@NotNull Call<T> call) {
            Intrinsics.checkNotNullParameter(call, (String)"call");
            return new ErrorHandlingCall<T>(call);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002H\u0016J\u0016\u0010\b\u001a\u00020\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\nH\u0016J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\u0016\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\fH\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/taptap/sdk/common/network/convert/ErrorHandlerCallFactory$ErrorHandlingCall;", "T", "Lcom/taptap/sdk/retrofit2/Call;", "delegate", "(Lcom/taptap/sdk/retrofit2/Call;)V", "cancel", "", "clone", "enqueue", "callback", "Lcom/taptap/sdk/retrofit2/Callback;", "execute", "Lcom/taptap/sdk/retrofit2/Response;", "isCanceled", "", "isExecuted", "parseBaseResponse", "Lcom/taptap/sdk/common/network/data/response/BaseResponse;", "response", "parseServerError", "Lcom/taptap/sdk/common/network/data/response/ErrResponse;", "data", "Lkotlinx/serialization/json/JsonElement;", "code", "", "request", "Lcom/taptap/sdk/okhttp3/Request;", "timeout", "Lcom/taptap/sdk/okio/Timeout;", "tap-common_release"})
    private static final class ErrorHandlingCall<T>
    implements Call<T> {
        @NotNull
        private final Call<T> delegate;

        public ErrorHandlingCall(@NotNull Call<T> delegate) {
            Intrinsics.checkNotNullParameter(delegate, (String)"delegate");
            this.delegate = delegate;
        }

        @NotNull
        public Response<T> execute() {
            throw new UnsupportedOperationException("MyCall does not support synchronous execution");
        }

        public void enqueue(@NotNull Callback<T> callback2) {
            Intrinsics.checkNotNullParameter(callback2, (String)"callback");
            this.delegate.enqueue(new Callback<T>(this, callback2){
                final /* synthetic */ ErrorHandlingCall<T> this$0;
                final /* synthetic */ Callback<T> $callback;
                {
                    this.this$0 = $receiver;
                    this.$callback = $callback;
                }

                public void onResponse(@NotNull Call<T> call, @NotNull Response<T> response) {
                    Intrinsics.checkNotNullParameter(call, (String)"call");
                    Intrinsics.checkNotNullParameter(response, (String)"response");
                    if (!response.isSuccessful()) {
                        try {
                            int code = response.code();
                            BaseResponse baseResponse = ErrorHandlingCall.access$parseBaseResponse(this.this$0, response);
                            ErrResponse serverError = ErrorHandlingCall.access$parseServerError(this.this$0, baseResponse.getData(), code);
                            if (serverError.getCode() != 0 && ((CharSequence)serverError.getError()).length() > 0) {
                                TapNetworkException.Err err = new TapNetworkException.Err(ApiErr.Companion.from(serverError.getError()), serverError.getCode(), serverError.getMsg());
                                if (enqueue.WhenMappings.$EnumSwitchMapping$0[err.getApiErr().ordinal()] == 1) {
                                    FixedTimeUtil.INSTANCE.fix(baseResponse.getNow());
                                }
                                this.$callback.onFailure(call, (Throwable)new TapNetworkException(err, null, 2, null));
                            }
                        }
                        catch (Throwable e) {
                            this.$callback.onFailure(call, e);
                        }
                    } else {
                        this.$callback.onResponse(call, response);
                    }
                }

                public void onFailure(@NotNull Call<T> call, @NotNull Throwable error) {
                    Intrinsics.checkNotNullParameter(call, (String)"call");
                    Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                    this.$callback.onFailure(call, error);
                }
            });
        }

        public boolean isExecuted() {
            return this.delegate.isExecuted();
        }

        public void cancel() {
            this.delegate.cancel();
        }

        public boolean isCanceled() {
            return this.delegate.isCanceled();
        }

        @NotNull
        public Call<T> clone() {
            Call call = this.delegate.clone();
            Intrinsics.checkNotNullExpressionValue((Object)call, (String)"delegate.clone()");
            return new ErrorHandlingCall<T>(call);
        }

        @NotNull
        public Request request() {
            Request request = this.delegate.request();
            Intrinsics.checkNotNullExpressionValue((Object)request, (String)"delegate.request()");
            return request;
        }

        @NotNull
        public Timeout timeout() {
            Timeout timeout = this.delegate.timeout();
            Intrinsics.checkNotNullExpressionValue((Object)timeout, (String)"delegate.timeout()");
            return timeout;
        }

        private final BaseResponse parseBaseResponse(Response<T> response) {
            BaseResponse baseResponse;
            int code = response.code();
            ResponseBody responseBody = response.errorBody();
            String string = responseBody != null ? responseBody.string() : null;
            String errorBodyStr = string == null ? "" : string;
            try {
                StringFormat $this$decodeFromString$iv = (StringFormat)Json.Default;
                boolean $i$f$decodeFromString = false;
                SerializersModule $this$serializer$iv$iv = $this$decodeFromString$iv.getSerializersModule();
                boolean $i$f$serializer = false;
                KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(BaseResponse.class));
                boolean $i$f$cast = false;
                Intrinsics.checkNotNull((Object)$this$cast$iv$iv$iv, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
                baseResponse = (BaseResponse)$this$decodeFromString$iv.decodeFromString((DeserializationStrategy)$this$cast$iv$iv$iv, errorBodyStr);
            }
            catch (Exception _) {
                baseResponse = null;
            }
            BaseResponse baseResponse2 = baseResponse;
            if (baseResponse2 == null) {
                throw new TapNetworkException(new TapNetworkException.Err(ApiErr.JSON_PARSE_ERROR, response.code(), "parse errorBody fail, code: " + code + ", errorBody: " + errorBodyStr), null, 2, null);
            }
            return baseResponse2;
        }

        private final ErrResponse parseServerError(JsonElement data, int code) {
            ErrResponse errResponse;
            try {
                Json $this$decodeFromJsonElement$iv = (Json)Json.Default;
                boolean $i$f$decodeFromJsonElement = false;
                SerializersModule $this$serializer$iv$iv = $this$decodeFromJsonElement$iv.getSerializersModule();
                boolean $i$f$serializer = false;
                KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(ErrResponse.class));
                boolean $i$f$cast = false;
                Intrinsics.checkNotNull((Object)$this$cast$iv$iv$iv, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
                errResponse = (ErrResponse)$this$decodeFromJsonElement$iv.decodeFromJsonElement((DeserializationStrategy)$this$cast$iv$iv$iv, data);
            }
            catch (Exception _) {
                errResponse = null;
            }
            ErrResponse serverError = errResponse;
            if (serverError == null) {
                throw new TapNetworkException(new TapNetworkException.Err(ApiErr.JSON_PARSE_ERROR, code, "parse BaseResponse.data fail, code: " + code), null, 2, null);
            }
            return serverError;
        }

        public static final /* synthetic */ BaseResponse access$parseBaseResponse(ErrorHandlingCall $this, Response response) {
            return $this.parseBaseResponse(response);
        }

        public static final /* synthetic */ ErrResponse access$parseServerError(ErrorHandlingCall $this, JsonElement data, int code) {
            return $this.parseServerError(data, code);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lcom/taptap/sdk/common/network/convert/ErrorHandlerCallFactory$Companion;", "", "()V", "create", "Lcom/taptap/sdk/retrofit2/CallAdapter$Factory;", "tap-common_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CallAdapter.Factory create() {
            return new ErrorHandlerCallFactory(null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

