/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.common.network.interceptor;

import com.taptap.sdk.base.network.sign.SignStrategy;
import com.taptap.sdk.common.network.utils.OkHttpUtils;
import com.taptap.sdk.okhttp3.Headers;
import com.taptap.sdk.okhttp3.HttpUrl;
import com.taptap.sdk.okhttp3.Interceptor;
import com.taptap.sdk.okhttp3.Request;
import com.taptap.sdk.okhttp3.Response;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\tB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/taptap/sdk/common/network/interceptor/RequestSignInterceptor;", "Lcom/taptap/sdk/okhttp3/Interceptor;", "config", "Lcom/taptap/sdk/common/network/interceptor/RequestSignInterceptor$Config;", "(Lcom/taptap/sdk/common/network/interceptor/RequestSignInterceptor$Config;)V", "intercept", "Lcom/taptap/sdk/okhttp3/Response;", "chain", "Lcom/taptap/sdk/okhttp3/Interceptor$Chain;", "Config", "tap-common_release"})
public final class RequestSignInterceptor
implements Interceptor {
    @NotNull
    private final Config config;

    public RequestSignInterceptor(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
    }

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Request originRequest = chain.request();
        Request.Builder newRequestBuilder = originRequest.newBuilder();
        SignStrategy signStrategy = this.config.getSignStrategy();
        HttpUrl httpUrl = originRequest.url();
        Intrinsics.checkNotNullExpressionValue((Object)httpUrl, (String)"originRequest.url()");
        String string = originRequest.method();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"originRequest.method()");
        Headers headers2 = originRequest.headers();
        Intrinsics.checkNotNullExpressionValue((Object)headers2, (String)"originRequest.headers()");
        Intrinsics.checkNotNullExpressionValue((Object)originRequest, (String)"originRequest");
        String string2 = OkHttpUtils.INSTANCE.convertBody2String(originRequest);
        if (string2 == null) {
            string2 = "";
        }
        newRequestBuilder.header("X-Tap-Sign", signStrategy.calculate(httpUrl, string, headers2, string2));
        Response response = chain.proceed(newRequestBuilder.build());
        Intrinsics.checkNotNullExpressionValue((Object)response, (String)"chain.proceed(newRequestBuilder.build())");
        return response;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/taptap/sdk/common/network/interceptor/RequestSignInterceptor$Config;", "", "signStrategy", "Lcom/taptap/sdk/base/network/sign/SignStrategy;", "(Lcom/taptap/sdk/base/network/sign/SignStrategy;)V", "getSignStrategy", "()Lcom/taptap/sdk/base/network/sign/SignStrategy;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "tap-common_release"})
    public static final class Config {
        @NotNull
        private final SignStrategy signStrategy;

        public Config(@NotNull SignStrategy signStrategy) {
            Intrinsics.checkNotNullParameter((Object)signStrategy, (String)"signStrategy");
            this.signStrategy = signStrategy;
        }

        @NotNull
        public final SignStrategy getSignStrategy() {
            return this.signStrategy;
        }

        @NotNull
        public final SignStrategy component1() {
            return this.signStrategy;
        }

        @NotNull
        public final Config copy(@NotNull SignStrategy signStrategy) {
            Intrinsics.checkNotNullParameter((Object)signStrategy, (String)"signStrategy");
            return new Config(signStrategy);
        }

        public static /* synthetic */ Config copy$default(Config config, SignStrategy signStrategy, int n, Object object) {
            if ((n & 1) != 0) {
                signStrategy = config.signStrategy;
            }
            return config.copy(signStrategy);
        }

        @NotNull
        public String toString() {
            return "Config(signStrategy=" + this.signStrategy + ')';
        }

        public int hashCode() {
            return this.signStrategy.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Config)) {
                return false;
            }
            Config config = (Config)other;
            return Intrinsics.areEqual((Object)this.signStrategy, (Object)config.signStrategy);
        }
    }
}

