/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.common.network.transform;

import com.taptap.sdk.base.network.transform.BizTransformer;
import com.taptap.sdk.common.network.data.response.BaseResponse;
import com.taptap.sdk.common.network.data.response.ErrResponse;
import com.taptap.sdk.common.network.throwable.ApiErr;
import com.taptap.sdk.common.network.throwable.TapNetworkException;
import com.taptap.sdk.common.network.utils.FixedTimeUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KType;
import kotlin.text.Charsets;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/taptap/sdk/common/network/transform/DefaultBizTransformer;", "Lcom/taptap/sdk/base/network/transform/BizTransformer;", "()V", "parseBaseResponse", "Lcom/taptap/sdk/common/network/data/response/BaseResponse;", "jsonStr", "", "parseErrorResponse", "Lcom/taptap/sdk/common/network/data/response/ErrResponse;", "data", "Lkotlinx/serialization/json/JsonElement;", "transform", "Ljava/io/InputStream;", "origin", "tap-common_release"})
public final class DefaultBizTransformer
implements BizTransformer {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public InputStream transform(@NotNull InputStream origin) {
        InputStream inputStream;
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        BaseResponse response = this.parseBaseResponse(new String(ByteStreamsKt.readBytes((InputStream)origin), Charsets.UTF_8));
        if (response.getSuccess()) {
            String $this$encodeToString$iv;
            StringFormat stringFormat = (StringFormat)Json.Default;
            Object value$iv = response.getData();
            boolean $i$f$encodeToString = false;
            SerializersModule $this$serializer$iv$iv = $this$encodeToString$iv.getSerializersModule();
            boolean $i$f$serializer = false;
            KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(JsonElement.class));
            boolean $i$f$cast = false;
            Intrinsics.checkNotNull((Object)$this$cast$iv$iv$iv, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
            $this$encodeToString$iv = $this$encodeToString$iv.encodeToString((SerializationStrategy)$this$cast$iv$iv$iv, value$iv);
            value$iv = Charsets.UTF_8;
            byte[] byArray = $this$encodeToString$iv.getBytes((Charset)value$iv);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            inputStream = new ByteArrayInputStream(byArray);
        } else {
            void $this$encodeToString$iv;
            ErrResponse serverError = this.parseErrorResponse(response.getData());
            if (serverError.getCode() != 0 && ((CharSequence)serverError.getError()).length() > 0) {
                TapNetworkException.Err err = new TapNetworkException.Err(ApiErr.Companion.from(serverError.getError()), serverError.getCode(), serverError.getMsg());
                if (WhenMappings.$EnumSwitchMapping$0[err.getApiErr().ordinal()] == 1) {
                    FixedTimeUtil.INSTANCE.fix(response.getNow());
                }
                throw new TapNetworkException(err, null, 2, null);
            }
            StringFormat err = (StringFormat)Json.Default;
            JsonElement value$iv = response.getData();
            boolean $i$f$encodeToString = false;
            SerializersModule $this$serializer$iv$iv = $this$encodeToString$iv.getSerializersModule();
            boolean $i$f$serializer = false;
            KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(JsonElement.class));
            boolean $i$f$cast = false;
            Intrinsics.checkNotNull((Object)$this$cast$iv$iv$iv, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
            String string = $this$encodeToString$iv.encodeToString((SerializationStrategy)$this$cast$iv$iv$iv, (Object)value$iv);
            Charset charset = Charsets.UTF_8;
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            inputStream = new ByteArrayInputStream(byArray);
        }
        return inputStream;
    }

    private final BaseResponse parseBaseResponse(String jsonStr) {
        BaseResponse baseResponse;
        try {
            StringFormat $this$decodeFromString$iv = (StringFormat)Json.Default;
            boolean $i$f$decodeFromString = false;
            SerializersModule $this$serializer$iv$iv = $this$decodeFromString$iv.getSerializersModule();
            boolean $i$f$serializer = false;
            KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(BaseResponse.class));
            boolean $i$f$cast = false;
            Intrinsics.checkNotNull((Object)$this$cast$iv$iv$iv, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
            baseResponse = (BaseResponse)$this$decodeFromString$iv.decodeFromString((DeserializationStrategy)$this$cast$iv$iv$iv, jsonStr);
        }
        catch (Exception _) {
            baseResponse = null;
        }
        BaseResponse baseResponse2 = baseResponse;
        if (baseResponse2 == null) {
            throw new TapNetworkException(new TapNetworkException.Err(ApiErr.JSON_PARSE_ERROR, -1, "parse jsonStr fail, jsonStr: " + jsonStr), null, 2, null);
        }
        return baseResponse2;
    }

    private final ErrResponse parseErrorResponse(JsonElement data) {
        ErrResponse errResponse;
        try {
            Json $this$decodeFromJsonElement$iv = (Json)Json.Default;
            boolean $i$f$decodeFromJsonElement = false;
            SerializersModule $this$serializer$iv$iv = $this$decodeFromJsonElement$iv.getSerializersModule();
            boolean $i$f$serializer = false;
            KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(ErrResponse.class));
            boolean $i$f$cast = false;
            Intrinsics.checkNotNull((Object)$this$cast$iv$iv$iv, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
            errResponse = (ErrResponse)$this$decodeFromJsonElement$iv.decodeFromJsonElement((DeserializationStrategy)$this$cast$iv$iv$iv, data);
        }
        catch (Exception _) {
            errResponse = null;
        }
        ErrResponse errorResponse = errResponse;
        if (errorResponse == null) {
            throw new TapNetworkException(new TapNetworkException.Err(ApiErr.JSON_PARSE_ERROR, -1, "parse BaseResponse.data fail, data: " + data), null, 2, null);
        }
        return errorResponse;
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ApiErr.values().length];
            try {
                nArray[ApiErr.INVALID_TIME.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

