/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.common.network.utils;

import android.os.Build;
import android.util.Base64;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004\u00a8\u0006\u0007"}, d2={"Lcom/taptap/sdk/common/network/utils/SecretUtil;", "", "()V", "secret", "", "token", "content", "tap-common_release"})
public final class SecretUtil {
    @NotNull
    public static final SecretUtil INSTANCE = new SecretUtil();

    private SecretUtil() {
    }

    @NotNull
    public final String secret(@NotNull String token, @NotNull String content) {
        String string;
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Mac hmacSha256 = Mac.getInstance("HmacSHA256");
        String string2 = token;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        SecretKeySpec secretKey = new SecretKeySpec(byArray, "HmacSHA256");
        hmacSha256.init(secretKey);
        String string3 = content;
        Charset charset2 = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"UTF_8");
        byte[] byArray2 = string3.getBytes(charset2);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
        byte[] signatureBytes = hmacSha256.doFinal(byArray2);
        if (Build.VERSION.SDK_INT >= 26) {
            String string4 = java.util.Base64.getEncoder().encodeToString(signatureBytes);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getEncoder().encodeToString(signatureBytes)");
        } else {
            String string5 = Base64.encodeToString((byte[])signatureBytes, (int)2);
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"encodeToString(signature\u2026s, androidBase64.NO_WRAP)");
        }
        return string;
    }
}

