/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.common.oaid.strategy;

import android.content.Context;
import com.taptap.sdk.common.oaid.ErrorCode;
import com.taptap.sdk.common.oaid.exception.OAIDException;
import com.taptap.sdk.common.oaid.proxy.IdentifyListenerHandler;
import com.taptap.sdk.common.oaid.strategy.OAIDStrategy;
import com.taptap.sdk.common.oaid.version.Versions;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.SafeContinuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joor.Reflect;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016J%\u0010\u001d\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001eR\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001f"}, d2={"Lcom/taptap/sdk/common/oaid/strategy/OaidStrategy3;", "Lcom/taptap/sdk/common/oaid/strategy/OAIDStrategy;", "mdidSdkHelperClass", "", "identifierListenerClass", "idSupplierClass", "jLibraryClass", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "identifyListener", "Lorg/joor/Reflect;", "jLibrary", "midSDKHelper", "supplier", "supportedVersion", "", "Lcom/taptap/sdk/common/oaid/version/Versions;", "getSupportedVersion", "()Ljava/util/Set;", "initPemCert", "", "context", "Landroid/content/Context;", "oaidCert", "initSdk", "", "handler", "", "loadClassesByReflect", "", "tryGetOAIDByReflect", "(Landroid/content/Context;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "tap-common_release"})
public final class OaidStrategy3
implements OAIDStrategy {
    @NotNull
    private final String mdidSdkHelperClass;
    @NotNull
    private final String identifierListenerClass;
    @NotNull
    private final String idSupplierClass;
    @NotNull
    private final String jLibraryClass;
    @Nullable
    private Reflect identifyListener;
    @Nullable
    private Reflect supplier;
    @Nullable
    private Reflect midSDKHelper;
    @Nullable
    private Reflect jLibrary;
    @NotNull
    private final Set<Versions> supportedVersion;

    public OaidStrategy3(@NotNull String mdidSdkHelperClass, @NotNull String identifierListenerClass, @NotNull String idSupplierClass, @NotNull String jLibraryClass) {
        Intrinsics.checkNotNullParameter((Object)mdidSdkHelperClass, (String)"mdidSdkHelperClass");
        Intrinsics.checkNotNullParameter((Object)identifierListenerClass, (String)"identifierListenerClass");
        Intrinsics.checkNotNullParameter((Object)idSupplierClass, (String)"idSupplierClass");
        Intrinsics.checkNotNullParameter((Object)jLibraryClass, (String)"jLibraryClass");
        this.mdidSdkHelperClass = mdidSdkHelperClass;
        this.identifierListenerClass = identifierListenerClass;
        this.idSupplierClass = idSupplierClass;
        this.jLibraryClass = jLibraryClass;
        Versions[] versionsArray = new Versions[]{Versions.V_1_0_6, Versions.V_1_0_8, Versions.V_1_0_9, Versions.V_1_0_10, Versions.V_1_0_11, Versions.V_1_0_13};
        this.supportedVersion = SetsKt.setOf((Object[])versionsArray);
    }

    @Override
    public boolean loadClassesByReflect() {
        try {
            this.midSDKHelper = Reflect.onClass((String)this.mdidSdkHelperClass);
            this.identifyListener = Reflect.onClass((String)this.identifierListenerClass);
            this.supplier = Reflect.onClass((String)this.idSupplierClass);
            this.jLibrary = Reflect.onClass((String)this.jLibraryClass);
        }
        catch (Throwable _) {
            return false;
        }
        return this.midSDKHelper != null && this.identifyListener != null && this.supplier != null && this.jLibrary != null;
    }

    @Override
    public void initPemCert(@NotNull Context context, @Nullable String oaidCert) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            Reflect reflect;
            Reflect reflect2 = reflect = this.midSDKHelper;
            if (reflect2 != null) {
                Object[] objectArray = new Object[]{context, oaidCert};
                reflect2.call("InitCert", objectArray);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    @Nullable
    public Object tryGetOAIDByReflect(@NotNull Context context, @Nullable String oaidCert, @NotNull Continuation<? super String> $completion) {
        Continuation<? super String> continuation = $completion;
        SafeContinuation safeContinuation = new SafeContinuation(IntrinsicsKt.intercepted(continuation));
        Continuation continuation2 = (Continuation)safeContinuation;
        boolean bl = false;
        try {
            this.initPemCert(context, oaidCert);
            Reflect reflect = this.jLibrary;
            if (reflect != null) {
                Object[] objectArray = new Object[]{context};
                reflect.call("InitEntry", objectArray);
            }
            Class[] classArray = new Class[1];
            Reflect reflect2 = this.identifyListener;
            classArray[0] = reflect2 != null ? reflect2.type() : null;
            Object object = Proxy.newProxyInstance(context.getClassLoader(), classArray, (InvocationHandler)new IdentifyListenerHandler((Function1<? super String, Unit>)((Function1)new Function1<String, Unit>((Continuation<? super String>)continuation2){
                final /* synthetic */ Continuation<String> $continuation;
                {
                    this.$continuation = $continuation;
                    super(1);
                }

                public final void invoke(@Nullable String oaid) {
                    this.$continuation.resumeWith(Result.constructor-impl((Object)oaid));
                }
            }), (Function1<? super Exception, Unit>)((Function1)new Function1<Exception, Unit>((Continuation<? super String>)continuation2){
                final /* synthetic */ Continuation<String> $continuation;
                {
                    this.$continuation = $continuation;
                    super(1);
                }

                public final void invoke(@NotNull Exception error) {
                    Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                    this.$continuation.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)error)));
                }
            })));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"continuation ->\n        \u2026  )\n                    )");
            int errCode2 = this.initSdk(context, object);
            ErrorCode errorCode = ErrorCode.Companion.from(errCode2);
            switch (WhenMappings.$EnumSwitchMapping$0[errorCode.ordinal()]) {
                case 1: 
                case 2: {
                    break;
                }
                default: {
                    continuation2.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new OAIDException(errorCode))));
                    break;
                }
            }
        }
        catch (Exception error) {
            continuation2.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)error)));
        }
        Object object = safeContinuation.getOrThrow();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }

    @Override
    @NotNull
    public Set<Versions> getSupportedVersion() {
        return this.supportedVersion;
    }

    private final int initSdk(Context context, Object handler) {
        Reflect reflect = this.midSDKHelper;
        if (reflect == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        Object[] objectArray = new Object[]{context, true, handler};
        Object object = reflect.call("InitSdk", objectArray).get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"checkNotNull(midSDKHelpe\u2026ndler)\n            .get()");
        return ((Number)object).intValue();
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ErrorCode.values().length];
            try {
                nArray[ErrorCode.INIT_INFO_RESULT_OK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ErrorCode.INIT_INFO_RESULT_DELAY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

