/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.kit.internal.extensions;

import android.content.res.Resources;
import android.graphics.Outline;
import android.graphics.Path;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewOutlineProvider;
import com.taptap.sdk.kit.internal.TapTapKit;
import com.taptap.sdk.kit.internal.extensions.DebounceOnClickListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0006\u0010\u0005\u001a\u00020\u0006\u001a\n\u0010\u0007\u001a\u00020\b*\u00020\t\u001a2\u0010\n\u001a\u00020\b*\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\f2\b\b\u0002\u0010\u000e\u001a\u00020\f2\b\b\u0002\u0010\u000f\u001a\u00020\f\u001a\f\u0010\u0010\u001a\u00020\b*\u0004\u0018\u00010\t\u001a\f\u0010\u0011\u001a\u00020\b*\u0004\u0018\u00010\t\u001a\f\u0010\u0012\u001a\u00020\u0006*\u0004\u0018\u00010\t\u001a(\u0010\u0013\u001a\u00020\b*\u00020\t2\b\b\u0002\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\b0\u0017\u001a\n\u0010\u0018\u001a\u00020\f*\u00020\f\u001a\n\u0010\u0019\u001a\u00020\u0001*\u00020\f\u001a\f\u0010\u001a\u001a\u00020\b*\u0004\u0018\u00010\t\u00a8\u0006\u001b"}, d2={"getColorRes", "", "res", "getThemeText", "", "isLandscape", "", "applyCircleOutline", "", "Landroid/view/View;", "applyCustomRoundedCorners", "leftTop", "", "rightTop", "rightBottom", "leftBottom", "gone", "invisible", "isVisible", "setDebounceClickListener", "debounceInterval", "", "listenerBlock", "Lkotlin/Function1;", "toDp", "toPx", "visible", "tap-common_release"})
public final class UIExtKt {
    public static final void visible(@Nullable View $this$visible) {
        View view = $this$visible;
        if (view != null) {
            view.setVisibility(0);
        }
    }

    public static final void gone(@Nullable View $this$gone) {
        View view = $this$gone;
        if (view != null) {
            view.setVisibility(8);
        }
    }

    public static final void invisible(@Nullable View $this$invisible) {
        View view = $this$invisible;
        if (view != null) {
            view.setVisibility(4);
        }
    }

    public static final boolean isVisible(@Nullable View $this$isVisible) {
        View view = $this$isVisible;
        return view != null ? view.getVisibility() == 0 : false;
    }

    public static final int toPx(float $this$toPx) {
        return (int)TypedValue.applyDimension((int)1, (float)$this$toPx, (DisplayMetrics)Resources.getSystem().getDisplayMetrics());
    }

    public static final float toDp(float $this$toDp) {
        return TypedValue.applyDimension((int)0, (float)$this$toDp, (DisplayMetrics)Resources.getSystem().getDisplayMetrics());
    }

    public static final void setDebounceClickListener(@NotNull View $this$setDebounceClickListener, long debounceInterval, @NotNull Function1<? super View, Unit> listenerBlock) {
        Intrinsics.checkNotNullParameter((Object)$this$setDebounceClickListener, (String)"<this>");
        Intrinsics.checkNotNullParameter(listenerBlock, (String)"listenerBlock");
        $this$setDebounceClickListener.setOnClickListener((View.OnClickListener)new DebounceOnClickListener(debounceInterval, listenerBlock));
    }

    public static /* synthetic */ void setDebounceClickListener$default(View view, long l, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            l = 500L;
        }
        UIExtKt.setDebounceClickListener(view, l, (Function1<? super View, Unit>)function1);
    }

    @NotNull
    public static final String getThemeText() {
        return (TapTapKit.INSTANCE.getContext().getResources().getConfiguration().uiMode & 0x30) == 32 ? "dark" : "light";
    }

    public static final void applyCircleOutline(@NotNull View $this$applyCircleOutline) {
        Intrinsics.checkNotNullParameter((Object)$this$applyCircleOutline, (String)"<this>");
        $this$applyCircleOutline.setClipToOutline(true);
        $this$applyCircleOutline.setOutlineProvider(new ViewOutlineProvider(){

            public void getOutline(@NotNull View view, @NotNull Outline outline) {
                Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                Intrinsics.checkNotNullParameter((Object)outline, (String)"outline");
                outline.setOval(0, 0, view.getWidth(), view.getHeight());
            }
        });
    }

    public static final void applyCustomRoundedCorners(@NotNull View $this$applyCustomRoundedCorners, float leftTop, float rightTop, float rightBottom, float leftBottom) {
        Intrinsics.checkNotNullParameter((Object)$this$applyCustomRoundedCorners, (String)"<this>");
        $this$applyCustomRoundedCorners.setClipToOutline(true);
        $this$applyCustomRoundedCorners.setOutlineProvider(new ViewOutlineProvider(leftTop, rightTop, rightBottom, leftBottom){
            final /* synthetic */ float $leftTop;
            final /* synthetic */ float $rightTop;
            final /* synthetic */ float $rightBottom;
            final /* synthetic */ float $leftBottom;
            {
                this.$leftTop = $leftTop;
                this.$rightTop = $rightTop;
                this.$rightBottom = $rightBottom;
                this.$leftBottom = $leftBottom;
            }

            public void getOutline(@NotNull View view, @NotNull Outline outline) {
                Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                Intrinsics.checkNotNullParameter((Object)outline, (String)"outline");
                Path path = new Path();
                float f = this.$leftTop;
                float f2 = this.$rightTop;
                float f3 = this.$rightBottom;
                float f4 = this.$leftBottom;
                Path $this$getOutline_u24lambda_u240 = path;
                boolean bl = false;
                float[] fArray = new float[]{f, f, f2, f2, f3, f3, f4, f4};
                $this$getOutline_u24lambda_u240.addRoundRect(0.0f, 0.0f, (float)view.getWidth(), (float)view.getHeight(), fArray, Path.Direction.CW);
                Path path2 = path;
                try {
                    if (Build.VERSION.SDK_INT >= 30) {
                        outline.setPath(path2);
                    } else {
                        outline.setConvexPath(path2);
                    }
                }
                catch (Exception e) {
                    float[] fArray2 = new float[]{this.$rightTop, this.$rightBottom, this.$leftBottom};
                    float maxRadius = ComparisonsKt.maxOf((float)this.$leftTop, (float[])fArray2);
                    outline.setRoundRect(0, 0, view.getWidth(), view.getHeight(), maxRadius);
                }
            }
        });
    }

    public static /* synthetic */ void applyCustomRoundedCorners$default(View view, float f, float f2, float f3, float f4, int n, Object object) {
        if ((n & 1) != 0) {
            f = 0.0f;
        }
        if ((n & 2) != 0) {
            f2 = 0.0f;
        }
        if ((n & 4) != 0) {
            f3 = 0.0f;
        }
        if ((n & 8) != 0) {
            f4 = 0.0f;
        }
        UIExtKt.applyCustomRoundedCorners(view, f, f2, f3, f4);
    }

    public static final boolean isLandscape() {
        return TapTapKit.INSTANCE.getSdkOptions().getScreenOrientation() == 1;
    }

    public static final int getColorRes(int res) {
        return TapTapKit.INSTANCE.getContext().getResources().getColor(res);
    }
}

