/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.kit.internal.identifier;

import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Process;
import android.provider.Settings;
import com.taptap.sdk.kit.internal.identifier.DataUtils;
import com.taptap.sdk.kit.internal.identifier.TapIdentifierUtil;
import com.taptap.sdk.kit.internal.identifier.content.TapGameUserIdUtil;
import com.taptap.sdk.kit.internal.identifier.content.TapOpenIdUtil;
import java.security.MessageDigest;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u00042\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u0016\u001a\u0004\u0018\u00010\u0004J\u0006\u0010\u0017\u001a\u00020\u0004J\b\u0010\u0018\u001a\u0004\u0018\u00010\u0004J\u000e\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u001d\u001a\u00020\u001b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/taptap/sdk/kit/internal/identifier/TapIdentifierUtil;", "", "()V", "SP_NAME", "", "androidId", "deviceId", "installUUID", "sp", "Landroid/content/SharedPreferences;", "getSp", "()Landroid/content/SharedPreferences;", "sp$delegate", "Lkotlin/Lazy;", "uniqueDeviceId", "bytesToHexString", "src", "", "getAndroidID", "context", "Landroid/content/Context;", "getDeviceId", "getGameUserId", "getInstallUUID", "getOpenId", "getUniqueDeviceId", "setGameUserId", "", "gameUserId", "setOpenId", "openId", "tap-common_release"})
public final class TapIdentifierUtil {
    @NotNull
    public static final TapIdentifierUtil INSTANCE = new TapIdentifierUtil();
    @NotNull
    private static final String SP_NAME = "TapSdkCore_SP";
    @NotNull
    private static final Lazy sp$delegate = LazyKt.lazy((Function0)sp.2.INSTANCE);
    @Nullable
    private static volatile String androidId;
    @NotNull
    private static volatile String uniqueDeviceId;
    @Nullable
    private static volatile String deviceId;
    @NotNull
    private static volatile String installUUID;

    private TapIdentifierUtil() {
    }

    private final SharedPreferences getSp() {
        Lazy lazy = sp$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-sp>(...)");
        return (SharedPreferences)object;
    }

    @JvmStatic
    @Nullable
    public static final String getAndroidID(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (androidId != null) {
            return androidId;
        }
        try {
            androidId = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return androidId;
    }

    @NotNull
    public final String getUniqueDeviceId(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            if (((CharSequence)uniqueDeviceId).length() > 0) {
                return uniqueDeviceId;
            }
            PackageManager pm = context.getPackageManager();
            String packageName = context.getPackageName();
            PackageInfo packageInfo = pm.getPackageInfo(packageName, 0);
            long firstInstallTime = packageInfo.firstInstallTime;
            int pid = Process.myPid();
            String permitInfo = "" + firstInstallTime + '-' + pid;
            MessageDigest md = MessageDigest.getInstance("MD5");
            StringBuilder stringBuilder = new StringBuilder().append("v1-");
            String string = permitInfo;
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            uniqueDeviceId = stringBuilder.append(this.bytesToHexString(md.digest(byArray))).toString();
            return uniqueDeviceId;
        }
        catch (Throwable e) {
            e.printStackTrace();
            uniqueDeviceId = "unknown";
            return uniqueDeviceId;
        }
    }

    @Nullable
    public final String getDeviceId(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (deviceId != null) {
            return deviceId;
        }
        deviceId = DataUtils.getDeviceId(context);
        return deviceId;
    }

    @NotNull
    public final synchronized String getInstallUUID() {
        if (((CharSequence)installUUID).length() > 0) {
            return installUUID;
        }
        String keyName = "tapsdk_install_uuid";
        String uuid = this.getSp().getString(keyName, null);
        CharSequence charSequence = uuid;
        if (!(charSequence == null || charSequence.length() == 0)) {
            installUUID = uuid;
            return uuid;
        }
        uuid = UUID.randomUUID().toString();
        this.getSp().edit().putString(keyName, uuid).apply();
        installUUID = uuid;
        return uuid;
    }

    @Nullable
    public final String getOpenId() {
        return TapOpenIdUtil.INSTANCE.getOpenId();
    }

    public final void setOpenId(@Nullable String openId) {
        TapOpenIdUtil.INSTANCE.setOpenId$tap_common_release(openId);
    }

    @Nullable
    public final String getGameUserId() {
        return TapGameUserIdUtil.INSTANCE.getGameUserId();
    }

    public final void setGameUserId(@Nullable String gameUserId) {
        TapGameUserIdUtil.INSTANCE.setGameUserId$tap_common_release(gameUserId);
    }

    private final String bytesToHexString(byte[] src) {
        if (src == null || src.length == 0) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder("");
        int n = src.length;
        for (int i = 0; i < n; ++i) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString();
    }

    static {
        uniqueDeviceId = "";
        installUUID = "";
    }
}

