/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.kit.internal.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.os.Process;
import android.security.keystore.KeyGenParameterSpec;
import android.text.TextUtils;
import android.util.Base64;
import com.taptap.sdk.kit.internal.TapLogger;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public class CryptoUtils {
    private static final String TAG = "TapCryptoUtils";
    public static final String DEFAULT_SECRETKEY_NAME = "default_secretkey_name";
    public static final String STORE_FILE_NAME = "crypto";
    private KeyStore keyStore;
    private static volatile CryptoUtils instance = null;

    private CryptoUtils(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    public static synchronized CryptoUtils getInstance(Context context) {
        if (instance == null) {
            File file = new File(context.getFilesDir(), STORE_FILE_NAME);
            try {
                KeyStore keyStore = CryptoUtils.getKeyStore(file);
                CryptoUtils.initKey(keyStore, file);
                instance = new CryptoUtils(keyStore);
            }
            catch (Exception e) {
                TapLogger.loge(TAG, null, e);
                try {
                    KeyStore keyStore = CryptoUtils.getKeyStore(file);
                    CryptoUtils.initKey(keyStore, file);
                    instance = new CryptoUtils(keyStore);
                }
                catch (Exception e1) {
                    TapLogger.loge(TAG, null, e1);
                    return null;
                }
            }
        }
        return instance;
    }

    private static void initKey(KeyStore keyStore, File file) throws Exception {
        if (!keyStore.containsAlias(DEFAULT_SECRETKEY_NAME)) {
            KeyGenerator keyGenerator = CryptoUtils.generateKeyGenerator();
            SecretKey secretKey = keyGenerator.generateKey();
            CryptoUtils.storeKey(keyStore, file, secretKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeKey(KeyStore keyStore, File file, SecretKey secretKey) throws Exception {
        if (Build.VERSION.SDK_INT >= 23) {
            keyStore.setKeyEntry(DEFAULT_SECRETKEY_NAME, secretKey, null, null);
        } else {
            keyStore.setKeyEntry(DEFAULT_SECRETKEY_NAME, secretKey, null, null);
            try (FileOutputStream fos = null;){
                fos = new FileOutputStream(file);
                keyStore.store(fos, null);
                fos.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore getKeyStore(File file) throws Exception {
        if (Build.VERSION.SDK_INT >= 23) {
            KeyStore keyStore = KeyStore.getInstance("AndroidKeyStore");
            keyStore.load(null);
            return keyStore;
        }
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        if (!file.exists()) {
            boolean isSuccess = file.createNewFile();
            if (!isSuccess) {
                throw new SecurityException("\u521b\u5efa\u5185\u90e8\u5b58\u50a8\u6587\u4ef6\u5931\u8d25");
            }
            keyStore.load(null, null);
        } else if (file.length() <= 0L) {
            keyStore.load(null, null);
        } else {
            try (FileInputStream fis = null;){
                fis = new FileInputStream(file);
                keyStore.load(fis, null);
                fis.close();
            }
        }
        return keyStore;
    }

    @SuppressLint(value={"DeletedProvider"})
    private static KeyGenerator generateKeyGenerator() throws Exception {
        KeyGenerator keyGenerator;
        if (Build.VERSION.SDK_INT >= 23) {
            keyGenerator = KeyGenerator.getInstance("AES", "AndroidKeyStore");
            keyGenerator.init((AlgorithmParameterSpec)new KeyGenParameterSpec.Builder(DEFAULT_SECRETKEY_NAME, 3).setBlockModes(new String[]{"CBC"}).setUserAuthenticationRequired(false).setEncryptionPaddings(new String[]{"PKCS7Padding"}).build());
        } else {
            keyGenerator = KeyGenerator.getInstance("AES");
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG", "Crypto");
            secureRandom.setSeed(CryptoUtils.generateSeed());
            keyGenerator.init(128, secureRandom);
        }
        return keyGenerator;
    }

    private static byte[] generateSeed() {
        try {
            ByteArrayOutputStream seedBuffer = new ByteArrayOutputStream();
            DataOutputStream seedBufferOut = new DataOutputStream(seedBuffer);
            seedBufferOut.writeLong(System.currentTimeMillis());
            seedBufferOut.writeLong(System.nanoTime());
            seedBufferOut.writeInt(Process.myPid());
            seedBufferOut.writeInt(Process.myUid());
            seedBufferOut.write(Build.BOARD.getBytes());
            return seedBuffer.toByteArray();
        }
        catch (IOException e) {
            throw new SecurityException("Failed to generate seed", e);
        }
    }

    public String aesEncrypt(String content) {
        try {
            SecretKey secretKey = CryptoUtils.getSecretKey(this.keyStore);
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS7Padding");
            cipher.init(1, secretKey);
            byte[] bytes = cipher.doFinal(StringUtils.string2BytesWithUTF8(content));
            return new EncryptData(Base64.encodeToString((byte[])bytes, (int)2), cipher.getIV()).toString();
        }
        catch (Exception e) {
            TapLogger.loge(TAG, null, e);
            return null;
        }
    }

    public String aesDecrypt(String data) {
        try {
            EncryptData encryptData = new EncryptData(data);
            SecretKey secretKey = CryptoUtils.getSecretKey(this.keyStore);
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS7Padding");
            cipher.init(2, (Key)secretKey, new IvParameterSpec(encryptData.getIv()));
            byte[] bytes = cipher.doFinal(Base64.decode((String)encryptData.getEncryptString(), (int)2));
            return StringUtils.bytes2StringWithUTF8(bytes);
        }
        catch (Exception e) {
            TapLogger.loge(TAG, "aesDecrypt", e);
            return null;
        }
    }

    private static SecretKey getSecretKey(KeyStore keyStore) {
        try {
            return (SecretKey)keyStore.getKey(DEFAULT_SECRETKEY_NAME, null);
        }
        catch (Exception e) {
            TapLogger.loge(TAG, null, e);
            return null;
        }
    }

    private static class StringUtils {
        private StringUtils() {
        }

        public static String bytes2String(byte[] bytes) {
            return new String(bytes, StandardCharsets.ISO_8859_1);
        }

        public static byte[] string2Bytes(String content) {
            return content.getBytes(StandardCharsets.ISO_8859_1);
        }

        public static String bytes2StringWithUTF8(byte[] bytes) {
            return new String(bytes, StandardCharsets.UTF_8);
        }

        public static byte[] string2BytesWithUTF8(String content) {
            return content.getBytes(StandardCharsets.UTF_8);
        }
    }

    public static class EncryptData {
        String encryptString;
        byte[] iv;

        public EncryptData(String encryptString, byte[] iv) {
            this.encryptString = encryptString;
            this.iv = iv;
        }

        public EncryptData(String content) {
            if (!TextUtils.isEmpty((CharSequence)content)) {
                int iIndex = content.indexOf("[i]");
                this.encryptString = content.substring(0, iIndex);
                String ivStr = content.substring(iIndex + 3);
                this.iv = StringUtils.string2Bytes(ivStr);
            }
        }

        public byte[] getIv() {
            return this.iv;
        }

        public String getEncryptString() {
            return this.encryptString;
        }

        public String toString() {
            return this.encryptString + "[i]" + StringUtils.bytes2String(this.iv);
        }
    }
}

