/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.common.utils;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u0016\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u0004J\u0016\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0007J\u0018\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\b\b\u0002\u0010\f\u001a\u00020\u0004\u00a8\u0006\u000f"}, d2={"Lcom/taptap/sdk/common/utils/ColorUtils;", "", "()V", "getAlpha", "", "color", "getAlphaFloat", "", "getRgb", "parseColor", "hexColor", "", "alpha", "rgbToArgb", "rgbColor", "tap-common_release"})
public final class ColorUtils {
    @NotNull
    public static final ColorUtils INSTANCE = new ColorUtils();

    private ColorUtils() {
    }

    public final int rgbToArgb(int rgbColor, int alpha) {
        return alpha << 24 | rgbColor & 0xFFFFFF;
    }

    public static /* synthetic */ int rgbToArgb$default(ColorUtils colorUtils, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = 255;
        }
        return colorUtils.rgbToArgb(n, n2);
    }

    public final int rgbToArgb(int rgbColor, float alpha) {
        int alphaInt = RangesKt.coerceIn((int)((int)(alpha * (float)255)), (int)0, (int)255);
        return this.rgbToArgb(rgbColor, alphaInt);
    }

    public final int parseColor(@NotNull String hexColor, int alpha) {
        Intrinsics.checkNotNullParameter((Object)hexColor, (String)"hexColor");
        String cleanHex = StringsKt.removePrefix((String)hexColor, (CharSequence)"#");
        int rgbColor = Integer.parseInt(cleanHex, CharsKt.checkRadix((int)16));
        return this.rgbToArgb(rgbColor, alpha);
    }

    public static /* synthetic */ int parseColor$default(ColorUtils colorUtils, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 255;
        }
        return colorUtils.parseColor(string, n);
    }

    public final int parseColor(@NotNull String hexColor, float alpha) {
        Intrinsics.checkNotNullParameter((Object)hexColor, (String)"hexColor");
        String cleanHex = StringsKt.removePrefix((String)hexColor, (CharSequence)"#");
        int rgbColor = Integer.parseInt(cleanHex, CharsKt.checkRadix((int)16));
        return this.rgbToArgb(rgbColor, alpha);
    }

    public final int getRgb(int color) {
        return color & 0xFFFFFF;
    }

    public final int getAlpha(int color) {
        return color >> 24 & 0xFF;
    }

    public final float getAlphaFloat(int color) {
        return (float)this.getAlpha(color) / 255.0f;
    }
}

