/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.common.utils;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.widget.ImageView;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0012\u0013B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\bJ0\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\bH\u0002J\u000e\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0014"}, d2={"Lcom/taptap/sdk/common/utils/GradientOverlayUtils;", "", "()V", "addGradientOverlay", "", "imageView", "Landroid/widget/ImageView;", "color", "", "startAlpha", "", "endAlpha", "direction", "Lcom/taptap/sdk/common/utils/GradientOverlayUtils$GradientDirection;", "cornerRadius", "createGradientDrawable", "Lcom/taptap/sdk/common/utils/GradientOverlayUtils$GradientOverlayDrawable;", "removeGradientOverlay", "GradientDirection", "GradientOverlayDrawable", "tap-common_release"})
public final class GradientOverlayUtils {
    @NotNull
    public static final GradientOverlayUtils INSTANCE = new GradientOverlayUtils();

    private GradientOverlayUtils() {
    }

    public final void addGradientOverlay(@NotNull ImageView imageView, int color, float startAlpha, float endAlpha, @NotNull GradientDirection direction, int cornerRadius) {
        Intrinsics.checkNotNullParameter((Object)imageView, (String)"imageView");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        GradientOverlayDrawable gradientDrawable = this.createGradientDrawable(color, startAlpha, endAlpha, direction, cornerRadius);
        Drawable originalDrawable = imageView.getDrawable();
        if (originalDrawable != null) {
            Drawable[] drawableArray = new Drawable[]{originalDrawable, gradientDrawable};
            LayerDrawable layerDrawable = new LayerDrawable(drawableArray);
            layerDrawable.setLayerInset(1, 0, 0, 0, 0);
            imageView.setImageDrawable((Drawable)layerDrawable);
        } else {
            imageView.setBackground((Drawable)gradientDrawable);
        }
        imageView.invalidate();
    }

    public static /* synthetic */ void addGradientOverlay$default(GradientOverlayUtils gradientOverlayUtils, ImageView imageView, int n, float f, float f2, GradientDirection gradientDirection, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            f = 0.4f;
        }
        if ((n3 & 8) != 0) {
            f2 = 1.0f;
        }
        if ((n3 & 0x10) != 0) {
            gradientDirection = GradientDirection.TOP_TO_BOTTOM;
        }
        if ((n3 & 0x20) != 0) {
            n2 = 0;
        }
        gradientOverlayUtils.addGradientOverlay(imageView, n, f, f2, gradientDirection, n2);
    }

    private final GradientOverlayDrawable createGradientDrawable(int color, float startAlpha, float endAlpha, GradientDirection direction, int cornerRadius) {
        return new GradientOverlayDrawable(color, startAlpha, endAlpha, direction, cornerRadius);
    }

    public final void removeGradientOverlay(@NotNull ImageView imageView) {
        Intrinsics.checkNotNullParameter((Object)imageView, (String)"imageView");
        Drawable drawable = imageView.getDrawable();
        if (drawable instanceof LayerDrawable && ((LayerDrawable)drawable).getNumberOfLayers() > 1) {
            imageView.setImageDrawable(((LayerDrawable)drawable).getDrawable(0));
        } else {
            imageView.setBackground(null);
        }
        imageView.invalidate();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/taptap/sdk/common/utils/GradientOverlayUtils$GradientDirection;", "", "(Ljava/lang/String;I)V", "TOP_TO_BOTTOM", "BOTTOM_TO_TOP", "LEFT_TO_RIGHT", "RIGHT_TO_LEFT", "tap-common_release"})
    public static final class GradientDirection
    extends Enum<GradientDirection> {
        public static final /* enum */ GradientDirection TOP_TO_BOTTOM = new GradientDirection();
        public static final /* enum */ GradientDirection BOTTOM_TO_TOP = new GradientDirection();
        public static final /* enum */ GradientDirection LEFT_TO_RIGHT = new GradientDirection();
        public static final /* enum */ GradientDirection RIGHT_TO_LEFT = new GradientDirection();
        private static final /* synthetic */ GradientDirection[] $VALUES;

        public static GradientDirection[] values() {
            return (GradientDirection[])$VALUES.clone();
        }

        public static GradientDirection valueOf(String value) {
            return Enum.valueOf(GradientDirection.class, value);
        }

        static {
            $VALUES = gradientDirectionArray = new GradientDirection[]{GradientDirection.TOP_TO_BOTTOM, GradientDirection.BOTTOM_TO_TOP, GradientDirection.LEFT_TO_RIGHT, GradientDirection.RIGHT_TO_LEFT};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0005H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0003H\u0016J\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0012\u0010\u0019\u001a\u00020\u00142\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/taptap/sdk/common/utils/GradientOverlayUtils$GradientOverlayDrawable;", "Landroid/graphics/drawable/Drawable;", "color", "", "startAlpha", "", "endAlpha", "direction", "Lcom/taptap/sdk/common/utils/GradientOverlayUtils$GradientDirection;", "cornerRadius", "(IFFLcom/taptap/sdk/common/utils/GradientOverlayUtils$GradientDirection;I)V", "paint", "Landroid/graphics/Paint;", "path", "Landroid/graphics/Path;", "rectF", "Landroid/graphics/RectF;", "adjustAlpha", "alpha", "draw", "", "canvas", "Landroid/graphics/Canvas;", "getOpacity", "setAlpha", "setColorFilter", "colorFilter", "Landroid/graphics/ColorFilter;", "tap-common_release"})
    private static final class GradientOverlayDrawable
    extends Drawable {
        private final int color;
        private final float startAlpha;
        private final float endAlpha;
        @NotNull
        private final GradientDirection direction;
        private final int cornerRadius;
        @NotNull
        private final Paint paint;
        @NotNull
        private final Path path;
        @NotNull
        private final RectF rectF;

        /*
         * WARNING - void declaration
         */
        public GradientOverlayDrawable(int color, float startAlpha, float endAlpha, @NotNull GradientDirection direction, int cornerRadius) {
            void $this$paint_u24lambda_u240;
            Paint paint;
            Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
            this.color = color;
            this.startAlpha = startAlpha;
            this.endAlpha = endAlpha;
            this.direction = direction;
            this.cornerRadius = cornerRadius;
            Paint paint2 = paint = new Paint();
            GradientOverlayDrawable gradientOverlayDrawable = this;
            boolean bl = false;
            $this$paint_u24lambda_u240.setAntiAlias(true);
            $this$paint_u24lambda_u240.setStyle(Paint.Style.FILL);
            gradientOverlayDrawable.paint = paint;
            this.path = new Path();
            this.rectF = new RectF();
        }

        public void draw(@NotNull Canvas canvas) {
            LinearGradient linearGradient;
            Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
            Rect rect = this.getBounds();
            Intrinsics.checkNotNullExpressionValue((Object)rect, (String)"bounds");
            Rect bounds = rect;
            if (bounds.isEmpty()) {
                return;
            }
            int startColor = this.adjustAlpha(this.color, this.startAlpha);
            int endColor = this.adjustAlpha(this.color, this.endAlpha);
            switch (WhenMappings.$EnumSwitchMapping$0[this.direction.ordinal()]) {
                case 1: {
                    linearGradient = new LinearGradient((float)bounds.left, (float)bounds.top, (float)bounds.left, (float)bounds.bottom, startColor, endColor, Shader.TileMode.CLAMP);
                    break;
                }
                case 2: {
                    linearGradient = new LinearGradient((float)bounds.left, (float)bounds.bottom, (float)bounds.left, (float)bounds.top, startColor, endColor, Shader.TileMode.CLAMP);
                    break;
                }
                case 3: {
                    linearGradient = new LinearGradient((float)bounds.left, (float)bounds.top, (float)bounds.right, (float)bounds.top, startColor, endColor, Shader.TileMode.CLAMP);
                    break;
                }
                case 4: {
                    linearGradient = new LinearGradient((float)bounds.right, (float)bounds.top, (float)bounds.left, (float)bounds.top, startColor, endColor, Shader.TileMode.CLAMP);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            LinearGradient gradient = linearGradient;
            this.paint.setShader((Shader)gradient);
            if (this.cornerRadius > 0) {
                this.rectF.set(bounds);
                this.path.reset();
                float[] fArray = new float[]{this.cornerRadius, this.cornerRadius, this.cornerRadius, this.cornerRadius, 0.0f, 0.0f, 0.0f, 0.0f};
                float[] radii = fArray;
                this.path.addRoundRect(this.rectF, radii, Path.Direction.CW);
                this.path.close();
                canvas.drawPath(this.path, this.paint);
            } else {
                canvas.drawRect(bounds, this.paint);
            }
        }

        public void setAlpha(int alpha) {
            this.paint.setAlpha(alpha);
        }

        public void setColorFilter(@Nullable ColorFilter colorFilter) {
            this.paint.setColorFilter(colorFilter);
        }

        public int getOpacity() {
            return -3;
        }

        private final int adjustAlpha(int color, float alpha) {
            int alphaInt = RangesKt.coerceIn((int)((int)(alpha * (float)255)), (int)0, (int)255);
            int rgbColor = color & 0xFFFFFF;
            return alphaInt << 24 | rgbColor;
        }

        @Metadata(mv={1, 5, 1}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[GradientDirection.values().length];
                try {
                    nArray[GradientDirection.TOP_TO_BOTTOM.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[GradientDirection.BOTTOM_TO_TOP.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[GradientDirection.LEFT_TO_RIGHT.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[GradientDirection.RIGHT_TO_LEFT.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

