/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.kit.internal.http;

import android.util.Log;
import com.taptap.sdk.kit.internal.TapLogger;
import com.taptap.sdk.okhttp3.Headers;
import com.taptap.sdk.okhttp3.Interceptor;
import com.taptap.sdk.okhttp3.MediaType;
import com.taptap.sdk.okhttp3.Request;
import com.taptap.sdk.okhttp3.RequestBody;
import com.taptap.sdk.okhttp3.Response;
import com.taptap.sdk.okhttp3.ResponseBody;
import com.taptap.sdk.okhttp3.internal.http.HttpHeaders;
import com.taptap.sdk.okio.Buffer;
import com.taptap.sdk.okio.BufferedSink;
import com.taptap.sdk.okio.BufferedSource;
import com.taptap.sdk.okio.GzipSource;
import com.taptap.sdk.okio.Source;
import java.io.EOFException;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000  2\u00020\u0001:\u0003 !\"B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001c\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\n\u0010\u0018\u001a\u00060\u0019j\u0002`\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/taptap/sdk/kit/internal/http/TapLogInterceptor;", "Lcom/taptap/sdk/okhttp3/Interceptor;", "enableLog", "", "level", "Lcom/taptap/sdk/kit/internal/http/TapLogInterceptor$Level;", "(ZLcom/taptap/sdk/kit/internal/http/TapLogInterceptor$Level;)V", "bodyHasUnknownEncoding", "headers", "Lcom/taptap/sdk/okhttp3/Headers;", "intercept", "Lcom/taptap/sdk/okhttp3/Response;", "chain", "Lcom/taptap/sdk/okhttp3/Interceptor$Chain;", "isPlaintext", "buffer", "Lcom/taptap/sdk/okio/Buffer;", "log", "", "message", "", "logException", "request", "Lcom/taptap/sdk/okhttp3/Request;", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "logRequest", "logResponse", "startTime", "Lcom/taptap/sdk/kit/internal/http/TapLogInterceptor$LogTime;", "response", "Companion", "Level", "LogTime", "tap-common_release"})
public final class TapLogInterceptor
implements Interceptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean enableLog;
    @NotNull
    private final Level level;
    private static final Charset UTF8 = Charset.forName("UTF-8");

    public TapLogInterceptor(boolean enableLog, @NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        this.enableLog = enableLog;
        this.level = level;
    }

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) {
        Response response;
        block6: {
            Throwable throwable;
            Object object;
            Object $i$a$-runCatching-TapLogInterceptor$intercept$32;
            Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
            Request request = chain.request();
            try {
                boolean $i$a$-runCatching-TapLogInterceptor$intercept$32 = false;
                Intrinsics.checkNotNullExpressionValue((Object)request, (String)"request");
                this.logRequest(request);
                $i$a$-runCatching-TapLogInterceptor$intercept$32 = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable2) {
                $i$a$-runCatching-TapLogInterceptor$intercept$32 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
            }
            LogTime startTime = new LogTime();
            response = null;
            try {
                Response response2 = chain.proceed(request);
                Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"chain.proceed(request)");
                response = response2;
            }
            catch (Exception e) {
                Intrinsics.checkNotNullExpressionValue((Object)request, (String)"request");
                this.logException(request, e);
                throw e;
            }
            try {
                boolean bl = false;
                this.logResponse(startTime, response);
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable3) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable3));
            }
            Throwable throwable4 = Result.exceptionOrNull-impl((Object)object);
            if (throwable4 == null) break block6;
            Throwable it = throwable = throwable4;
            boolean bl = false;
            TapLogger.logd("TapHttp", "logResponse error: " + it, it);
        }
        return response;
    }

    private final void logException(Request request, Exception e) {
        StringBuilder builder = new StringBuilder("<------ HTTP FAILED: ");
        builder.append(request.method() + ' ').append(request.url());
        builder.append("" + '\n' + e);
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        this.log(string);
    }

    private final void logRequest(Request request) {
        boolean hasRequestBody;
        StringBuilder builder = new StringBuilder("------> ");
        builder.append(request.method() + ' ').append(request.url());
        RequestBody requestBody = request.body();
        boolean bl = hasRequestBody = requestBody != null;
        if (hasRequestBody) {
            builder.append(" (");
            RequestBody requestBody2 = requestBody;
            builder.append(requestBody2 != null ? Long.valueOf(requestBody2.contentLength()) : null);
            builder.append("-byte body)");
        }
        if (this.level == Level.BASIC) {
            if (hasRequestBody) {
                RequestBody requestBody3 = requestBody;
                if ((requestBody3 != null ? requestBody3.contentType() : null) != null) {
                    builder.append("\n").append("Content-Type: ").append(requestBody.contentType());
                }
                RequestBody requestBody4 = requestBody;
                if (!(requestBody4 != null ? requestBody4.contentLength() == -1L : false)) {
                    RequestBody requestBody5 = requestBody;
                    builder.append("\n").append("Content-Length: ").append(requestBody5 != null ? Long.valueOf(requestBody5.contentLength()) : null);
                }
            }
            Headers headers2 = request.headers();
            int n = headers2.size();
            for (int i = 0; i < n; ++i) {
                String name = headers2.name(i);
                if (StringsKt.equals((String)"Content-Type", (String)name, (boolean)true) || StringsKt.equals((String)"Content-Length", (String)name, (boolean)true)) continue;
                builder.append("\n").append(name).append(": ").append(headers2.value(i));
            }
            if (hasRequestBody) {
                Intrinsics.checkNotNullExpressionValue((Object)headers2, (String)"headers");
                if (this.bodyHasUnknownEncoding(headers2)) {
                    builder.append("\n------> END " + request.method() + " (encoded body omitted)");
                } else {
                    Buffer buffer = new Buffer();
                    RequestBody requestBody6 = requestBody;
                    Intrinsics.checkNotNull((Object)requestBody6);
                    requestBody6.writeTo((BufferedSink)buffer);
                    Charset charset = UTF8;
                    MediaType contentType = requestBody.contentType();
                    if (contentType != null) {
                        charset = contentType.charset(UTF8);
                    }
                    if (this.isPlaintext(buffer)) {
                        builder.append("\n").append(buffer.readString(charset));
                        builder.append("\n------> END " + request.method() + " (" + requestBody.contentLength() + "-byte body)");
                    } else {
                        builder.append("\n------> END " + request.method() + " (binary " + requestBody.contentLength() + "-byte body omitted)");
                    }
                }
            } else {
                builder.append("\n------> END " + request.method());
            }
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        this.log(string);
    }

    private final boolean bodyHasUnknownEncoding(Headers headers2) {
        String contentEncoding = headers2.get("Content-Encoding");
        return contentEncoding != null && !StringsKt.equals((String)contentEncoding, (String)"identity", (boolean)true) && !StringsKt.equals((String)contentEncoding, (String)"gzip", (boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void logResponse(LogTime startTime, Response response) {
        StringBuilder stringBuilder;
        ResponseBody responseBody = response.body();
        Request request = response.request();
        long requestCostMs = startTime.tookMs();
        ResponseBody responseBody2 = responseBody;
        long contentLength = responseBody2 != null ? responseBody2.contentLength() : -1L;
        Headers headers2 = response.headers();
        StringBuilder $this$logResponse_u24lambda_u243 = stringBuilder = new StringBuilder("<------ " + response.code() + ' ' + request.url() + " (" + requestCostMs + "ms)");
        boolean bl = false;
        if (this.level == Level.BASIC) {
            int n = headers2.size();
            for (int i = 0; i < n; ++i) {
                String name = headers2.name(i);
                $this$logResponse_u24lambda_u243.append("\n").append(name).append(": ").append(headers2.value(i));
            }
        }
        StringBuilder builder = stringBuilder;
        if (this.level == Level.BASIC) {
            if (HttpHeaders.hasBody((Response)response) && responseBody != null) {
                Headers headers3 = response.headers();
                Intrinsics.checkNotNullExpressionValue((Object)headers3, (String)"response.headers()");
                if (this.bodyHasUnknownEncoding(headers3)) {
                    builder.append("\n<------ END HTTP (encoded body omitted)");
                } else {
                    BufferedSource source = responseBody.source();
                    source.request(Long.MAX_VALUE);
                    Buffer buffer = source.buffer();
                    Long gzippedLength = null;
                    if (StringsKt.equals((String)"gzip", (String)headers2.get("Content-Encoding"), (boolean)true)) {
                        gzippedLength = buffer.size();
                        GzipSource gzippedResponseBody = null;
                        try {
                            gzippedResponseBody = new GzipSource((Source)buffer.clone());
                            buffer = new Buffer();
                            buffer.writeAll((Source)gzippedResponseBody);
                        }
                        catch (Throwable throwable) {
                            GzipSource gzipSource = gzippedResponseBody;
                            if (gzipSource != null) {
                                gzipSource.close();
                            }
                            throw throwable;
                        }
                        gzippedResponseBody.close();
                    }
                    Charset charset = UTF8;
                    MediaType contentType = responseBody.contentType();
                    if (contentType != null) {
                        charset = contentType.charset(UTF8);
                    }
                    Buffer buffer2 = buffer;
                    Intrinsics.checkNotNullExpressionValue((Object)buffer2, (String)"buffer");
                    if (!this.isPlaintext(buffer2)) {
                        builder.append("\n<------ END HTTP (binary " + buffer.size() + "-byte body omitted)");
                    }
                    if (contentLength != 0L) {
                        builder.append("\n").append(buffer.clone().readString(charset));
                    }
                    if (gzippedLength != null) {
                        builder.append("\n<------ END HTTP (" + buffer.size() + "-byte, " + gzippedLength + "-gzipped-byte body)");
                    } else {
                        builder.append("\n<------ END HTTP (" + buffer.size() + "-byte body)");
                    }
                }
            } else {
                builder.append("\n<------ END HTTP");
            }
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        this.log(string);
    }

    private final boolean isPlaintext(Buffer buffer) {
        try {
            Buffer prefix = new Buffer();
            long byteCount = buffer.size() < 64L ? buffer.size() : 64L;
            buffer.copyTo(prefix, 0L, byteCount);
            for (int i = 0; i < 16 && !prefix.exhausted(); ++i) {
                int codePoint = prefix.readUtf8CodePoint();
                if (!Character.isISOControl(codePoint) || Character.isWhitespace(codePoint)) continue;
                return false;
            }
            return true;
        }
        catch (EOFException e) {
            return false;
        }
    }

    private final void log(String message) {
        if (this.enableLog) {
            Log.d((String)"TapHttp", (String)message);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/taptap/sdk/kit/internal/http/TapLogInterceptor$Level;", "", "(Ljava/lang/String;I)V", "BASIC", "HEADERS", "tap-common_release"})
    public static final class Level
    extends Enum<Level> {
        public static final /* enum */ Level BASIC = new Level();
        public static final /* enum */ Level HEADERS = new Level();
        private static final /* synthetic */ Level[] $VALUES;

        public static Level[] values() {
            return (Level[])$VALUES.clone();
        }

        public static Level valueOf(String value) {
            return Enum.valueOf(Level.class, value);
        }

        static {
            $VALUES = levelArray = new Level[]{Level.BASIC, Level.HEADERS};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/taptap/sdk/kit/internal/http/TapLogInterceptor$Companion;", "", "()V", "UTF8", "Ljava/nio/charset/Charset;", "kotlin.jvm.PlatformType", "tap-common_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/taptap/sdk/kit/internal/http/TapLogInterceptor$LogTime;", "", "()V", "startNs", "", "tookMs", "tap-common_release"})
    public static final class LogTime {
        private final long startNs = System.nanoTime();

        public final long tookMs() {
            return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.startNs);
        }
    }
}

