/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.kit.internal.http.hanlder;

import com.taptap.sdk.kit.internal.http.TapHttpException;
import com.taptap.sdk.kit.internal.http.TapTime;
import com.taptap.sdk.kit.internal.http.hanlder.AbsTapHttpBackoff;
import com.taptap.sdk.kit.internal.http.hanlder.ITapHttpRetry;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0005"}, d2={"Lcom/taptap/sdk/kit/internal/http/hanlder/TapHttpRetry;", "", "()V", "NoneRetry", "SdkDefault", "tap-common_release"})
public final class TapHttpRetry {

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0003\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/taptap/sdk/kit/internal/http/hanlder/TapHttpRetry$NoneRetry;", "Lcom/taptap/sdk/kit/internal/http/hanlder/ITapHttpRetry;", "()V", "nextRetryMillis", "", "e", "", "tap-common_release"})
    public static final class NoneRetry
    implements ITapHttpRetry {
        @Override
        public long nextRetryMillis(@NotNull Throwable e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            return -1L;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0003\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/taptap/sdk/kit/internal/http/hanlder/TapHttpRetry$SdkDefault;", "Lcom/taptap/sdk/kit/internal/http/hanlder/ITapHttpRetry;", "backoff", "Lcom/taptap/sdk/kit/internal/http/hanlder/AbsTapHttpBackoff;", "(Lcom/taptap/sdk/kit/internal/http/hanlder/AbsTapHttpBackoff;)V", "nextRetryMillis", "", "e", "", "tap-common_release"})
    public static final class SdkDefault
    implements ITapHttpRetry {
        @NotNull
        private final AbsTapHttpBackoff backoff;

        public SdkDefault(@NotNull AbsTapHttpBackoff backoff) {
            Intrinsics.checkNotNullParameter((Object)backoff, (String)"backoff");
            this.backoff = backoff;
        }

        @Override
        public long nextRetryMillis(@NotNull Throwable e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            long nextBackoffMillis = -1L;
            Throwable throwable = e;
            if (throwable instanceof TapHttpException.ServerError) {
                int n = ((TapHttpException.ServerError)e).getHttpCode();
                boolean bl = 500 <= n ? n < 600 : false;
                if (bl) {
                    nextBackoffMillis = this.backoff.nextBackoffMillis();
                } else if (Intrinsics.areEqual((Object)((TapHttpException.ServerError)e).getError().getError(), (Object)"server_error")) {
                    nextBackoffMillis = this.backoff.nextBackoffMillis();
                } else if (Intrinsics.areEqual((Object)((TapHttpException.ServerError)e).getError().getError(), (Object)"invalid_time")) {
                    TapTime.INSTANCE.calibrateServerTime(((TapHttpException.ServerError)e).getResponse().getNow());
                    if (this.backoff.canInvalidTimeRetry()) {
                        nextBackoffMillis = 0L;
                    }
                }
            } else if (throwable instanceof TapHttpException.NoServerError) {
                int n = ((TapHttpException.NoServerError)e).getHttpCode();
                boolean bl = 500 <= n ? n < 600 : false;
                if (bl) {
                    nextBackoffMillis = this.backoff.nextBackoffMillis();
                }
            } else if (throwable instanceof UnknownHostException ? true : throwable instanceof SocketTimeoutException) {
                nextBackoffMillis = this.backoff.nextBackoffMillis();
            }
            return nextBackoffMillis;
        }
    }
}

