/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.kit.internal.identifier;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.taptap.sdk.kit.internal.TapLogger;
import com.taptap.sdk.kit.internal.identifier.TapIdentifierUtil;
import com.taptap.sdk.kit.internal.utils.CryptoUtils;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;

class DataUtils {
    private static final String TAG = "DataUtils";
    private static final String ENCODE_PREFIX = "_encode_identify_prefix_";

    DataUtils() {
    }

    @Nullable
    private static String handleSecurityData(Context context, String key, String data) {
        if (TextUtils.isEmpty((CharSequence)data) || TextUtils.isEmpty((CharSequence)key)) {
            return data;
        }
        CryptoUtils utils = CryptoUtils.getInstance(context);
        if (utils != null) {
            if (data.startsWith(ENCODE_PREFIX)) {
                String decrypt = utils.aesDecrypt(data.substring(ENCODE_PREFIX.length()));
                if (decrypt == null) {
                    SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
                    sharedPreferences.edit().remove(key).apply();
                }
                return decrypt;
            }
            SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
            sharedPreferences.edit().putString(key, ENCODE_PREFIX + utils.aesEncrypt(data)).apply();
            return data;
        }
        TapLogger.logd(TAG, " data should be decrypt but util is null");
        return data.startsWith(ENCODE_PREFIX) ? "" : data;
    }

    @NonNull
    public static String getDeviceId(Context context) {
        String securityData;
        String KEY = "tapdb_game_mobile_identify";
        String MATCHER = "__game_mobile__0__";
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        String identify = null;
        if (null != sharedPreferences) {
            try {
                identify = sharedPreferences.getString("tapdb_game_mobile_identify", null);
                if (identify != null && (identify = DataUtils.handleSecurityData(context, "tapdb_game_mobile_identify", identify)) != null) {
                    return identify;
                }
            }
            catch (Exception e) {
                TapLogger.loge(TAG, "getDeviceId", e);
            }
            Map all = sharedPreferences.getAll();
            String oldKey = null;
            for (String s : all.keySet()) {
                if (!s.contains("__game_mobile__0__")) continue;
                oldKey = s;
                identify = (String)all.get(s);
                break;
            }
            if (identify != null && (identify = DataUtils.handleSecurityData(context, oldKey, identify)) != null) {
                return identify;
            }
        }
        if (!TextUtils.isEmpty((CharSequence)(identify = DataUtils.getTapDBId(TapIdentifierUtil.getAndroidID(context)))) && identify.length() <= 256 && (identify = DataUtils.handleSecurityData(context, "tapdb_game_mobile_identify", identify)) != null) {
            return identify;
        }
        identify = UUID.randomUUID().toString();
        if (!TextUtils.isEmpty((CharSequence)identify) && identify.length() <= 256 && (securityData = DataUtils.handleSecurityData(context, "tapdb_game_mobile_identify", identify)) != null) {
            return securityData;
        }
        return identify;
    }

    private static String getTapDBId(String androidId) {
        String ANID_REGEX = "^[0-9a-zA-Z]{8,16}$";
        int ANID_LENGTH = 16;
        String[] ANIDS_EXCLUDED = new String[]{"0000000000000000", "ffffffffffffffff"};
        if (null != androidId) {
            if (!androidId.matches("^[0-9a-zA-Z]{8,16}$")) {
                androidId = null;
            } else {
                int length = androidId.length();
                if (length < 16) {
                    for (int i = 0; i < 16 - length; ++i) {
                        androidId = "0" + androidId;
                    }
                }
                if (Arrays.asList(ANIDS_EXCLUDED).contains(androidId)) {
                    androidId = null;
                }
            }
        }
        return androidId != null ? androidId : UUID.randomUUID().toString();
    }
}

