/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.kit.internal.utils;

import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Environment;
import android.os.Process;
import android.os.StatFs;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import com.taptap.sdk.kit.internal.TapLogger;
import com.taptap.sdk.kit.internal.utils.CommonUtils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Locale;

public class DeviceUtils {
    private static String TAG = "DeviceUtils";
    public static String cpuAbi = null;

    public static String getManufacturer() {
        return Build.MANUFACTURER;
    }

    public static String getModel() {
        return Build.MODEL;
    }

    public static String getCurLanguageDisplayName() {
        Locale locale = CommonUtils.getCurrentLocale();
        return locale.toLanguageTag();
    }

    public static long getDeviceTotalRam(Context context) {
        try {
            ActivityManager manager = (ActivityManager)context.getSystemService("activity");
            ActivityManager.MemoryInfo info = new ActivityManager.MemoryInfo();
            if (manager == null) {
                return 0L;
            }
            manager.getMemoryInfo(info);
            return info.totalMem;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static long getDeviceTotalRom(Context context) {
        try {
            StatFs statFs = new StatFs(Environment.getDataDirectory().getPath());
            long total = Build.VERSION.SDK_INT >= 18 ? statFs.getBlockCountLong() * statFs.getBlockSizeLong() : (long)statFs.getBlockCount() * (long)statFs.getBlockSize();
            return total;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static long getRemainingRamSize(Context context) {
        long result = 0L;
        try {
            ActivityManager manager = (ActivityManager)context.getSystemService("activity");
            ActivityManager.MemoryInfo info = new ActivityManager.MemoryInfo();
            manager.getMemoryInfo(info);
            result = info.availMem;
        }
        catch (Exception e) {
            TapLogger.logd(TAG, e);
        }
        return result;
    }

    public static long getRemainingRomSize() {
        long result = 0L;
        try {
            StatFs statFs = new StatFs(Environment.getDataDirectory().getPath());
            long availableCounts = statFs.getAvailableBlocksLong();
            long size = statFs.getBlockSizeLong();
            result = availableCounts * size;
        }
        catch (Exception e) {
            TapLogger.logd(TAG, e);
        }
        return result;
    }

    public static String getPlatform() {
        return "Android";
    }

    public static String getCpuInfo() {
        return Build.CPU_ABI;
    }

    public static String getCpuABIS() {
        Object[] abis = Build.SUPPORTED_ABIS;
        if (abis == null || abis.length == 0) {
            return "";
        }
        return Arrays.toString(abis);
    }

    public static int getPackageVersionCode(Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            return packageInfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static String getPackageVersion(Context context) {
        String version = "";
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            version = packageInfo.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return version;
    }

    public static boolean isRunInSandbox() {
        Object sandbox = System.getProperties().get("flag_running_in_sandbox");
        return sandbox != null;
    }

    public static boolean isRunInCloud() {
        if (!TextUtils.isEmpty((CharSequence)Build.MODEL)) {
            return Build.MODEL.contains("haima_cloudplay") || Build.MODEL.toLowerCase().contains("taptap");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCPUHardware() {
        String hardware = "";
        BufferedReader bufferedReader = null;
        try {
            String data;
            FileReader reader = new FileReader("/proc/cpuinfo");
            bufferedReader = new BufferedReader(reader);
            while ((data = bufferedReader.readLine()) != null) {
                if (!data.contains("Hardware")) continue;
                hardware = data.split(":")[1];
                break;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (hardware == null || hardware.trim().isEmpty()) {
            hardware = Build.HARDWARE;
        }
        return hardware;
    }

    public static String getDeviceBrand() {
        return !TextUtils.isEmpty((CharSequence)Build.BRAND) ? Build.BRAND : "";
    }

    public static String getDeviceModel() {
        return !TextUtils.isEmpty((CharSequence)Build.MODEL) ? Build.MODEL : "";
    }

    public static int[] getDeviceSize(Context context) {
        int[] size = new int[2];
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        int height = metrics.heightPixels;
        int width = metrics.widthPixels;
        if (height > width) {
            int tmp = width;
            width = height;
            height = tmp;
        }
        size[0] = width;
        size[1] = height;
        return size;
    }

    public static String getOS() {
        return Build.VERSION.RELEASE == null ? "UNKNOWN" : Build.VERSION.RELEASE;
    }

    public static String getOSType() {
        return Build.SUPPORTED_64_BIT_ABIS.length > 0 ? "64" : "32";
    }

    public static String getCPUAbi() {
        if (TextUtils.isEmpty((CharSequence)cpuAbi)) {
            try {
                String abi = new BufferedReader(new InputStreamReader(Runtime.getRuntime().exec("getprop ro.product.cpu.abi").getInputStream())).readLine();
                cpuAbi = abi.contains("x86") ? "x86" : (abi.contains("armeabi-v7a") ? "armeabi-v7a" : (abi.contains("arm64-v8a") ? "arm64-v8a" : "armeabi"));
            }
            catch (Exception e) {
                cpuAbi = "armeabi";
            }
        }
        return cpuAbi;
    }

    public static String getCarrier(Context context) {
        try {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            String provider = "unknown";
            if (telephonyManager != null && !TextUtils.isEmpty((CharSequence)telephonyManager.getNetworkOperatorName())) {
                provider = telephonyManager.getNetworkOperatorName();
            }
            return provider;
        }
        catch (Exception e) {
            TapLogger.logd(TAG, e);
            return null;
        }
    }

    @SuppressLint(value={"MissingPermission", "HardwareIds"})
    public static String getIMEI(Context context) {
        String imei = "";
        try {
            if (!DeviceUtils.hasReadPhoneStatePermission(context)) {
                return imei;
            }
            TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
            if (tm != null) {
                if (Build.VERSION.SDK_INT > 28) {
                    if (tm.hasCarrierPrivileges()) {
                        imei = tm.getImei();
                    } else {
                        TapLogger.logd(TAG, "Can not get IMEI info.");
                    }
                } else {
                    imei = Build.VERSION.SDK_INT >= 26 ? tm.getImei() : tm.getDeviceId();
                }
            }
        }
        catch (Exception e) {
            TapLogger.logd(TAG, e);
        }
        return imei;
    }

    private static boolean hasReadPhoneStatePermission(Context context) {
        if (Build.VERSION.SDK_INT > 28) {
            if (!DeviceUtils.checkHasPermission(context, "android.permission.READ_PRECISE_PHONE_STATE")) {
                TapLogger.logd(TAG, "Don't have permission android.permission.READ_PRECISE_PHONE_STATE,getDeviceID failed");
                return false;
            }
        } else if (!DeviceUtils.checkHasPermission(context, "android.permission.READ_PHONE_STATE")) {
            TapLogger.logd(TAG, "Don't have permission android.permission.READ_PHONE_STATE,getDeviceID failed");
            return false;
        }
        return true;
    }

    public static boolean checkHasPermission(Context context, String permission2) {
        try {
            int result = context.checkPermission(permission2, Process.myPid(), Process.myUid());
            return result == 0;
        }
        catch (Exception e) {
            return true;
        }
    }
}

