/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.core;

import com.taptap.sdk.core.TapTapPurchasedEvent;
import com.taptap.sdk.db.TapDB;
import com.taptap.sdk.db.data.model.Event;
import com.taptap.sdk.db.data.model.EventType;
import com.taptap.sdk.db.data.model.WrapEvent;
import com.taptap.sdk.db.event.DeviceAddEvent;
import com.taptap.sdk.db.event.DeviceInitializeEvent;
import com.taptap.sdk.db.event.DeviceLoginEvent;
import com.taptap.sdk.db.event.DeviceUpdateEvent;
import com.taptap.sdk.db.event.PurchasedEvent;
import com.taptap.sdk.db.event.UserAddEvent;
import com.taptap.sdk.db.event.UserInitializeEvent;
import com.taptap.sdk.db.event.UserLoginEvent;
import com.taptap.sdk.db.event.UserUpdateEvent;
import com.taptap.sdk.db.utils.JSONObjectUtils;
import com.taptap.sdk.db.utils.UserIdVerifyTools;
import com.taptap.sdk.kit.internal.TapLogger;
import com.taptap.sdk.kit.internal.identifier.TapIdentifierUtil;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001$B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0001H\u0007J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0007J\b\u0010\n\u001a\u00020\u0004H\u0007J!\u0010\u000b\u001a\u00020\u00042\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\r\"\u00020\u0006H\u0007\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u000f\u001a\u00020\u0004H\u0007J\u0012\u0010\u0010\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0007J\u0012\u0010\u0011\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0007J\u0012\u0010\u0012\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0007J\b\u0010\u0013\u001a\u0004\u0018\u00010\u0006J\b\u0010\u0014\u001a\u00020\u0004H\u0007J\u001c\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00062\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u0007J\u0010\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u0012\u0010\u001a\u001a\u00020\u00042\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0007J\u0012\u0010\u001d\u001a\u00020\u00042\b\u0010\u001e\u001a\u0004\u0018\u00010\u0006H\u0007J\u001c\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u00062\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u0007J\u0012\u0010!\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0007J\u0012\u0010\"\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0007J\u0012\u0010#\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0007\u00a8\u0006%"}, d2={"Lcom/taptap/sdk/core/TapTapEvent;", "", "()V", "addCommon", "", "key", "", "value", "properties", "Lorg/json/JSONObject;", "clearAllCommonProperties", "clearCommonProperties", "keys", "", "([Ljava/lang/String;)V", "clearUser", "deviceAdd", "deviceInitialize", "deviceUpdate", "getDeviceId", "logDeviceLoginEvent", "logEvent", "name", "logPurchasedEvent", "event", "Lcom/taptap/sdk/core/TapTapPurchasedEvent;", "registerDynamicProperties", "dynamicProperties", "Lcom/taptap/sdk/core/TapTapEvent$TapEventDynamicProperties;", "setOAID", "oaid", "setUserId", "userId", "userAdd", "userInitialize", "userUpdate", "TapEventDynamicProperties", "tap-db_release"})
public final class TapTapEvent {
    @NotNull
    public static final TapTapEvent INSTANCE = new TapTapEvent();

    private TapTapEvent() {
    }

    @JvmStatic
    public static final void logEvent(@NotNull String name, @Nullable JSONObject properties) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        TapDB tapDB = TapDB.Companion.getInstance();
        WrapEvent.Builder builder = new WrapEvent.Builder();
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        String string2 = EventType.TRACK.getValue();
        long l = System.currentTimeMillis();
        JSONObject jSONObject = properties;
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        tapDB.submitEvent(builder.setEvent(new Event(string, name, string2, l, jSONObject)).setEventType(EventType.TRACK).isAutomatically(false).isCustomEvent(true).build());
    }

    public static /* synthetic */ void logEvent$default(String string, JSONObject jSONObject, int n, Object object) {
        if ((n & 2) != 0) {
            jSONObject = null;
        }
        TapTapEvent.logEvent(string, jSONObject);
    }

    @JvmStatic
    public static final void logPurchasedEvent(@NotNull TapTapPurchasedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        new PurchasedEvent.Builder(event.getProperties()).isAutomatically(false).setOrderId(event.getOrderId()).setProductName(event.getProductName()).setAmount(event.getAmount()).setCurrencyType(event.getCurrencyType()).setPaymentMethod(event.getPaymentMethod()).build().submit();
    }

    @JvmStatic
    public static final void setUserId(@NotNull String userId, @Nullable JSONObject properties) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        try {
            UserIdVerifyTools.INSTANCE.verify(userId);
            TapDB.Companion.getInstance().setUserId(userId);
            new UserLoginEvent.Builder(properties).isAutomatically(true).build().submit();
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"has_user", (Object)true)};
            new DeviceUpdateEvent.Builder(MapsKt.hashMapOf((Pair[])pairArray)).isAutomatically(false).build().submit();
            TapIdentifierUtil.INSTANCE.setGameUserId(userId);
        }
        catch (Exception e) {
            TapLogger.loge$default(null, null, (Throwable)e, (int)3, null);
        }
    }

    public static /* synthetic */ void setUserId$default(String string, JSONObject jSONObject, int n, Object object) {
        if ((n & 2) != 0) {
            jSONObject = null;
        }
        TapTapEvent.setUserId(string, jSONObject);
    }

    @JvmStatic
    public static final void clearUser() {
        TapDB.Companion.getInstance().setUserId(null);
        TapIdentifierUtil.INSTANCE.setGameUserId(null);
    }

    @Nullable
    public final String getDeviceId() {
        return TapIdentifierUtil.INSTANCE.getDeviceId(TapDB.Companion.getOptions$tap_db_release().getContext());
    }

    @JvmStatic
    public static final void deviceInitialize(@Nullable JSONObject properties) {
        new DeviceInitializeEvent.Builder(properties).isAutomatically(false).build().submit();
    }

    @JvmStatic
    public static final void deviceUpdate(@Nullable JSONObject properties) {
        Object object = properties;
        if (object == null || (object = JSONObjectUtils.INSTANCE.toMap((JSONObject)object)) == null) {
            object = MapsKt.emptyMap();
        }
        new DeviceUpdateEvent.Builder((Map<String, ? extends Object>)object).isAutomatically(false).build().submit();
    }

    @JvmStatic
    public static final void deviceAdd(@Nullable JSONObject properties) {
        new DeviceAddEvent.Builder(properties).isAutomatically(false).build().submit();
    }

    @JvmStatic
    public static final void userInitialize(@Nullable JSONObject properties) {
        new UserInitializeEvent.Builder(properties).isAutomatically(false).build().submit();
    }

    @JvmStatic
    public static final void userUpdate(@Nullable JSONObject properties) {
        new UserUpdateEvent.Builder(properties).isAutomatically(false).build().submit();
    }

    @JvmStatic
    public static final void userAdd(@Nullable JSONObject properties) {
        new UserAddEvent.Builder(properties).isAutomatically(false).build().submit();
    }

    @JvmStatic
    public static final void addCommon(@Nullable JSONObject properties) {
        TapDB tapDB = TapDB.Companion.getInstance();
        Object object = properties;
        if (object == null || (object = JSONObjectUtils.INSTANCE.toMap((JSONObject)object)) == null) {
            object = MapsKt.emptyMap();
        }
        tapDB.addCommon((Map<String, ? extends Object>)object);
    }

    @JvmStatic
    public static final void addCommon(@NotNull String key, @Nullable Object value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        TapDB.Companion.getInstance().addCommon(MapsKt.mapOf((Pair)TuplesKt.to((Object)key, (Object)value)));
    }

    @JvmStatic
    public static final void clearCommonProperties(String ... keys) {
        Intrinsics.checkNotNullParameter((Object)keys, (String)"keys");
        TapDB.Companion.getInstance().clearCommonProperties(ArraysKt.toSet((Object[])keys));
    }

    @JvmStatic
    public static final void clearAllCommonProperties() {
        TapDB.Companion.getInstance().clearAllCommonProperties();
    }

    @JvmStatic
    public static final void registerDynamicProperties(@Nullable TapEventDynamicProperties dynamicProperties) {
        TapDB.Companion.getInstance().registerDynamicPropertiesGetter(dynamicProperties);
    }

    @JvmStatic
    public static final void setOAID(@Nullable String oaid) {
        TapDB.Companion.getInstance().setOAID(oaid);
    }

    @JvmStatic
    public static final void logDeviceLoginEvent() {
        new DeviceLoginEvent.Builder(TapDB.Companion.getOptions$tap_db_release().getProperties()).isAutomatically(true).build().submitNow();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\n\u0010\u0002\u001a\u0004\u0018\u00010\u0003H&\u00a8\u0006\u0004"}, d2={"Lcom/taptap/sdk/core/TapTapEvent$TapEventDynamicProperties;", "", "getDynamicProperties", "Lorg/json/JSONObject;", "tap-db_release"})
    public static interface TapEventDynamicProperties {
        @Nullable
        public JSONObject getDynamicProperties();
    }
}

