/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.db;

import android.content.SharedPreferences;
import android.util.Log;
import com.taptap.sdk.base.utils.lifecycle.TapActivityLifecycleTracker;
import com.taptap.sdk.common.gaid.GAIDManager;
import com.taptap.sdk.common.gaid.data.model.GAID;
import com.taptap.sdk.common.network.NetworkClientKt;
import com.taptap.sdk.common.oaid.OAIDManager;
import com.taptap.sdk.core.TapTapEvent;
import com.taptap.sdk.db.EventContext;
import com.taptap.sdk.db.TapDB;
import com.taptap.sdk.db.biz.gameplay.GameDurationService;
import com.taptap.sdk.db.biz.gameplay.reporter.DefaultGameDurationReporter;
import com.taptap.sdk.db.biz.gameplay.storage.PrefsGameDurationStorage;
import com.taptap.sdk.db.biz.gameplay.tracker.DefaultGameDurationTracker;
import com.taptap.sdk.db.biz.iap.IAPService;
import com.taptap.sdk.db.data.model.Event;
import com.taptap.sdk.db.data.model.WrapEvent;
import com.taptap.sdk.db.interceptor.Interceptor;
import com.taptap.sdk.db.interceptor.RealChain;
import com.taptap.sdk.db.processor.EventProcessor;
import com.taptap.sdk.db.properties.PredefinedProvider;
import com.taptap.sdk.db.properties.SystemProvider;
import com.taptap.sdk.db.repository.EventApi;
import com.taptap.sdk.db.repository.EventRepository;
import com.taptap.sdk.db.storage.PersistentQueue;
import com.taptap.sdk.db.utils.MapUtils2;
import com.taptap.sdk.initializer.api.model.RegionType;
import com.taptap.sdk.initializer.api.option.TapTapSdkOptions;
import com.taptap.sdk.retrofit2.Retrofit;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.Delegates;
import kotlin.properties.ObservableProperty;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.SupervisorKt;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 `2\u00020\u0001:\u0002_`B\u000f\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B?\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0018\u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f0\u000e\u00a2\u0006\u0002\u0010\u0012J\u001c\u0010D\u001a\u00020E2\u0014\u0010F\u001a\u0010\u0012\u0004\u0012\u00020\u0018\u0012\u0006\u0012\u0004\u0018\u00010\"0!J\u0006\u0010G\u001a\u00020EJ\u0014\u0010H\u001a\u00020E2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00180JJ\u0006\u0010K\u001a\u00020EJ\b\u0010L\u001a\u0004\u0018\u00010\u0018J\b\u0010M\u001a\u0004\u0018\u00010\u0018J\u0013\u0010N\u001a\u0004\u0018\u00010\u0018H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010OJ\u0013\u0010P\u001a\u0004\u0018\u00010\u0018H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010OJ\u0006\u0010Q\u001a\u00020EJ\u001c\u0010R\u001a\u00020E2\b\u0010S\u001a\u0004\u0018\u00010\u00182\b\u0010T\u001a\u0004\u0018\u00010\u0018H\u0002J\b\u0010U\u001a\u00020VH\u0002J\u0010\u0010W\u001a\u00020E2\b\u0010X\u001a\u0004\u0018\u00010+J\u0010\u0010Y\u001a\u00020E2\b\u0010Z\u001a\u0004\u0018\u00010\u0018J\u0010\u0010[\u001a\u00020E2\b\u0010\\\u001a\u0004\u0018\u00010\u0018J\u000e\u0010]\u001a\u00020E2\u0006\u0010^\u001a\u00020\u0010R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R/\u0010\u0019\u001a\u0004\u0018\u00010\u00182\b\u0010\u0017\u001a\u0004\u0018\u00010\u00188V@VX\u0096\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR(\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\u0018\u0012\u0006\u0012\u0004\u0018\u00010\"0!X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001c\u0010'\u001a\u0004\u0018\u00010\u0018X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u001b\"\u0004\b)\u0010\u001dR\u001c\u0010*\u001a\u0004\u0018\u00010+X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u001a\u00100\u001a\u000201X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u000e\u00106\u001a\u000207X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00108\u001a\u0004\u0018\u000109X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010:\u001a\u0004\u0018\u00010;X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f0\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010=R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010?R\u0014\u0010@\u001a\u00020\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u0010\u001bR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010C\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006a"}, d2={"Lcom/taptap/sdk/db/TapDB;", "Lcom/taptap/sdk/db/EventContext;", "builder", "Lcom/taptap/sdk/db/TapDB$Builder;", "(Lcom/taptap/sdk/db/TapDB$Builder;)V", "options", "Lcom/taptap/sdk/initializer/api/option/TapTapSdkOptions;", "config", "Lcom/taptap/sdk/db/processor/EventProcessor$Config;", "predefinedProvider", "Lcom/taptap/sdk/db/properties/PredefinedProvider;", "systemProvider", "Lcom/taptap/sdk/db/properties/SystemProvider;", "interceptors", "", "Lcom/taptap/sdk/db/interceptor/Interceptor;", "Lcom/taptap/sdk/db/data/model/WrapEvent;", "Lcom/taptap/sdk/db/data/model/Event;", "(Lcom/taptap/sdk/initializer/api/option/TapTapSdkOptions;Lcom/taptap/sdk/db/processor/EventProcessor$Config;Lcom/taptap/sdk/db/properties/PredefinedProvider;Lcom/taptap/sdk/db/properties/SystemProvider;Ljava/util/List;)V", "chain", "Lcom/taptap/sdk/db/interceptor/RealChain;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<set-?>", "", "currentUserId", "getCurrentUserId", "()Ljava/lang/String;", "setCurrentUserId", "(Ljava/lang/String;)V", "currentUserId$delegate", "Lkotlin/properties/ReadWriteProperty;", "customExtras", "", "", "getCustomExtras", "()Ljava/util/Map;", "setCustomExtras", "(Ljava/util/Map;)V", "customOAID", "getCustomOAID", "setCustomOAID", "dynamicPropertiesGetter", "Lcom/taptap/sdk/core/TapTapEvent$TapEventDynamicProperties;", "getDynamicPropertiesGetter", "()Lcom/taptap/sdk/core/TapTapEvent$TapEventDynamicProperties;", "setDynamicPropertiesGetter", "(Lcom/taptap/sdk/core/TapTapEvent$TapEventDynamicProperties;)V", "eventIndex", "Ljava/util/concurrent/atomic/AtomicLong;", "getEventIndex", "()Ljava/util/concurrent/atomic/AtomicLong;", "setEventIndex", "(Ljava/util/concurrent/atomic/AtomicLong;)V", "eventProcessor", "Lcom/taptap/sdk/db/processor/EventProcessor;", "gameDurationService", "Lcom/taptap/sdk/db/biz/gameplay/GameDurationService;", "iapService", "Lcom/taptap/sdk/db/biz/iap/IAPService;", "getInterceptors", "()Ljava/util/List;", "getPredefinedProvider", "()Lcom/taptap/sdk/db/properties/PredefinedProvider;", "sessionId", "getSessionId", "getSystemProvider", "()Lcom/taptap/sdk/db/properties/SystemProvider;", "addCommon", "", "properties", "clearAllCommonProperties", "clearCommonProperties", "keys", "", "flushEvents", "getCurrentGAID", "getCurrentOAID", "getGAID", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getOAID", "initialize", "onUserIdChange", "oldValue", "newValue", "provideNetworkApi", "Lcom/taptap/sdk/db/repository/EventApi;", "registerDynamicPropertiesGetter", "propertiesGetter", "setOAID", "value", "setUserId", "userId", "submitEvent", "wrapEvent", "Builder", "Companion", "tap-db_release"})
public final class TapDB
implements EventContext {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final TapTapSdkOptions options;
    @NotNull
    private final EventProcessor.Config config;
    @NotNull
    private final PredefinedProvider predefinedProvider;
    @NotNull
    private final SystemProvider systemProvider;
    @NotNull
    private final List<Interceptor<WrapEvent, Event>> interceptors;
    @NotNull
    private final CoroutineScope coroutineScope;
    @Nullable
    private String customOAID;
    @NotNull
    private final ReadWriteProperty currentUserId$delegate;
    @NotNull
    private Map<String, ? extends Object> customExtras;
    @Nullable
    private TapTapEvent.TapEventDynamicProperties dynamicPropertiesGetter;
    @NotNull
    private final String sessionId;
    @NotNull
    private AtomicLong eventIndex;
    @Nullable
    private GameDurationService gameDurationService;
    @Nullable
    private IAPService iapService;
    @NotNull
    private final EventProcessor eventProcessor;
    @NotNull
    private final RealChain<WrapEvent, Event> chain;
    @NotNull
    private static final String TAG = "TapDB";
    @Nullable
    private static volatile TapDB INSTANCE;
    @NotNull
    private static final ReadWriteProperty<Object, TapTapSdkOptions> options$delegate;

    public TapDB(@NotNull TapTapSdkOptions options, @NotNull EventProcessor.Config config, @NotNull PredefinedProvider predefinedProvider, @NotNull SystemProvider systemProvider, @NotNull List<? extends Interceptor<WrapEvent, Event>> interceptors) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)predefinedProvider, (String)"predefinedProvider");
        Intrinsics.checkNotNullParameter((Object)systemProvider, (String)"systemProvider");
        Intrinsics.checkNotNullParameter(interceptors, (String)"interceptors");
        this.options = options;
        this.config = config;
        this.predefinedProvider = predefinedProvider;
        this.systemProvider = systemProvider;
        this.interceptors = interceptors;
        this.coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)Dispatchers.getIO().plus((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null)));
        Delegates delegates = Delegates.INSTANCE;
        Object initialValue$iv = null;
        boolean $i$f$observable = false;
        this.currentUserId$delegate = (ReadWriteProperty)new ObservableProperty<String>(initialValue$iv, this){
            final /* synthetic */ TapDB this$0;
            {
                this.this$0 = tapDB;
                super($initialValue);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            protected void afterChange(@NotNull KProperty property, Object oldValue, Object newValue) {
                void newValue2;
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                String string = (String)newValue;
                String oldValue2 = (String)oldValue;
                boolean bl = false;
                TapDB.access$onUserIdChange(this.this$0, oldValue2, (String)newValue2);
            }
        };
        this.customExtras = MapsKt.emptyMap();
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        this.sessionId = string;
        this.eventIndex = new AtomicLong(0L);
        this.eventProcessor = new EventProcessor(this.config, new EventRepository(new PersistentQueue<Event>(this.config), this.provideNetworkApi()));
        this.chain = new RealChain(this.getInterceptors(), 0, null, 6, null);
    }

    @Override
    @NotNull
    public PredefinedProvider getPredefinedProvider() {
        return this.predefinedProvider;
    }

    @Override
    @NotNull
    public SystemProvider getSystemProvider() {
        return this.systemProvider;
    }

    @Override
    @NotNull
    public List<Interceptor<WrapEvent, Event>> getInterceptors() {
        return this.interceptors;
    }

    @Override
    @Nullable
    public String getCustomOAID() {
        return this.customOAID;
    }

    @Override
    public void setCustomOAID(@Nullable String string) {
        this.customOAID = string;
    }

    @Override
    @Nullable
    public String getCurrentUserId() {
        return (String)this.currentUserId$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Override
    public void setCurrentUserId(@Nullable String string) {
        this.currentUserId$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)string);
    }

    @Override
    @NotNull
    public Map<String, Object> getCustomExtras() {
        return this.customExtras;
    }

    @Override
    public void setCustomExtras(@NotNull Map<String, ? extends Object> map2) {
        Intrinsics.checkNotNullParameter(map2, (String)"<set-?>");
        this.customExtras = map2;
    }

    @Override
    @Nullable
    public TapTapEvent.TapEventDynamicProperties getDynamicPropertiesGetter() {
        return this.dynamicPropertiesGetter;
    }

    @Override
    public void setDynamicPropertiesGetter(@Nullable TapTapEvent.TapEventDynamicProperties tapEventDynamicProperties) {
        this.dynamicPropertiesGetter = tapEventDynamicProperties;
    }

    @Override
    @NotNull
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    @NotNull
    public AtomicLong getEventIndex() {
        return this.eventIndex;
    }

    @Override
    public void setEventIndex(@NotNull AtomicLong atomicLong) {
        Intrinsics.checkNotNullParameter((Object)atomicLong, (String)"<set-?>");
        this.eventIndex = atomicLong;
    }

    private TapDB(Builder builder) {
        TapTapSdkOptions tapTapSdkOptions = builder.getOptions();
        EventProcessor.Config config = builder.getConfig$tap_db_release();
        if (config == null) {
            boolean bl = false;
            String string = "you must set config for TapDB";
            throw new IllegalStateException(string.toString());
        }
        EventProcessor.Config config2 = config;
        List<Interceptor<WrapEvent, Event>> list = builder.getInterceptors$tap_db_release();
        SystemProvider systemProvider = builder.getSystemProvider$tap_db_release();
        if (systemProvider == null) {
            boolean bl = false;
            String string = "you must set systemProvider for TapDB";
            throw new IllegalStateException(string.toString());
        }
        SystemProvider systemProvider2 = systemProvider;
        PredefinedProvider predefinedProvider = builder.getPredefinedProvider$tap_db_release();
        if (predefinedProvider == null) {
            boolean bl = false;
            String string = "you must set predefinedProvider for TapDB";
            throw new IllegalStateException(string.toString());
        }
        PredefinedProvider predefinedProvider2 = predefinedProvider;
        this(tapTapSdkOptions, config2, predefinedProvider2, systemProvider2, list);
    }

    public final void initialize() {
        INSTANCE = this;
        Companion.setOptions$tap_db_release(this.options);
        GameDurationService.Builder builder = new GameDurationService.Builder(this.options.getContext());
        SharedPreferences sharedPreferences = this.options.getContext().getSharedPreferences("com.taptap.sdk.GameDurationStorage", 0);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"options.context.getShare\u2026                        )");
        this.gameDurationService = builder.setTracker(new DefaultGameDurationTracker(new PrefsGameDurationStorage(sharedPreferences, (Json)Json.Default), new DefaultGameDurationReporter(), TapActivityLifecycleTracker.INSTANCE, this)).build().initialize();
        this.iapService = new IAPService.Builder(this.options).build().initialize();
    }

    public final void submitEvent(@NotNull WrapEvent wrapEvent) {
        Intrinsics.checkNotNullParameter((Object)wrapEvent, (String)"wrapEvent");
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, wrapEvent, null){
            Object L$0;
            int label;
            final /* synthetic */ TapDB this$0;
            final /* synthetic */ WrapEvent $wrapEvent;
            {
                this.this$0 = $receiver;
                this.$wrapEvent = $wrapEvent;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        var3_3 = TapDB.access$getEventProcessor$p(this.this$0);
                        this.L$0 = var3_3;
                        this.label = 1;
                        v0 = TapDB.access$getChain$p(this.this$0).process(this.$wrapEvent.newBuilder((Function1<? super WrapEvent.Builder, Unit>)((Function1)new Function1<WrapEvent.Builder, Unit>(this.this$0){
                            final /* synthetic */ TapDB this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull WrapEvent.Builder $this$newBuilder) {
                                Intrinsics.checkNotNullParameter((Object)$this$newBuilder, (String)"$this$newBuilder");
                                String string = $this$newBuilder.getUserId$tap_db_release();
                                if (string == null) {
                                    string = this.this$0.getCurrentUserId();
                                }
                                $this$newBuilder.setUserId(string);
                                $this$newBuilder.setEventContext(this.this$0);
                            }
                        })), (Continuation)this);
                        ** if (v0 != var4_2) goto lbl13
lbl12:
                        // 1 sources

                        return var4_2;
lbl13:
                        // 1 sources

                        ** GOTO lbl20
                    }
                    case 1: {
                        var3_3 = (EventProcessor)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl20:
                        // 2 sources

                        this.L$0 = null;
                        this.label = 2;
                        v1 = var3_3.submitEvent((Event)v0, (Continuation<? super Unit>)((Continuation)this));
                        ** if (v1 != var4_2) goto lbl25
lbl24:
                        // 1 sources

                        return var4_2;
lbl25:
                        // 1 sources

                        ** GOTO lbl35
                    }
                    case 2: {
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
                        }
                        catch (Throwable e) {
                            Log.e((String)"TapDB", (String)"submit wrapEvent fail", (Throwable)e);
                        }
lbl35:
                        // 3 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final void flushEvents() {
        this.eventProcessor.flushEvents();
    }

    public final void setUserId(@Nullable String userId) {
        this.setCurrentUserId(userId);
    }

    public final void setOAID(@Nullable String value) {
        if (!this.options.getDisableReflectionOAID()) {
            Log.e((String)TAG, (String)"setOAID is not allowed when disableReflectionOAID is false");
        }
        this.setCustomOAID(value);
    }

    public final void addCommon(@NotNull Map<String, ? extends Object> properties) {
        Intrinsics.checkNotNullParameter(properties, (String)"properties");
        this.setCustomExtras(MapsKt.plus(this.getCustomExtras(), (Map)MapUtils2.filterRecursively$default(MapUtils2.INSTANCE, properties, null, 1, null)));
    }

    public final void registerDynamicPropertiesGetter(@Nullable TapTapEvent.TapEventDynamicProperties propertiesGetter) {
        this.setDynamicPropertiesGetter(propertiesGetter);
    }

    /*
     * WARNING - void declaration
     */
    public final void clearCommonProperties(@NotNull Set<String> keys) {
        void $this$filterKeys$iv;
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        Map<String, Object> map2 = this.getCustomExtras();
        TapDB tapDB = this;
        boolean $i$f$filterKeys = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
            String it = (String)entry$iv.getKey();
            boolean bl = false;
            if (!(!keys.contains(it))) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        tapDB.setCustomExtras(result$iv);
    }

    public final void clearAllCommonProperties() {
        this.setCustomExtras(MapsKt.emptyMap());
    }

    @Nullable
    public final Object getOAID(@NotNull Continuation<? super String> $completion) {
        if (!this.options.getDisableReflectionOAID()) {
            return OAIDManager.Companion.getInstance().getOAID($completion);
        }
        return this.getCustomOAID();
    }

    @Nullable
    public final String getCurrentOAID() {
        return !this.options.getDisableReflectionOAID() ? OAIDManager.Companion.getInstance().getCurrentOAID() : this.getCustomOAID();
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object getGAID(@NotNull Continuation<? super String> var1_1) {
        if (!(var1_1 instanceof getGAID.1)) ** GOTO lbl-1000
        var4_2 = var1_1;
        if ((var4_2.label & -2147483648) != 0) {
            var4_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                /* synthetic */ Object result;
                final /* synthetic */ TapDB this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getGAID((Continuation<? super String>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = GAIDManager.Companion.getInstance().getGAID((Continuation)$continuation);
                if (v0 == var5_4) {
                    return var5_4;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                v1 = (GAID)v0;
                if (v1 == null) {
                    return null;
                }
                gaid = v1;
                return gaid.getAndroidAdvertiserIdValue();
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public final String getCurrentGAID() {
        GAID gAID = GAIDManager.Companion.getInstance().getCurrentGAID();
        if (gAID == null) {
            return null;
        }
        GAID gaid = gAID;
        return gaid.getAndroidAdvertiserIdValue();
    }

    private final EventApi provideNetworkApi() {
        Retrofit retrofit = NetworkClientKt.provideRetrofit((String)TapDB.provideNetworkApi$getBaseUrl(this), (TapTapSdkOptions)this.options);
        Object object = retrofit.create(EventApi.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"retrofit.create(EventApi::class.java)");
        return (EventApi)object;
    }

    private final void onUserIdChange(String oldValue, String newValue) {
        CharSequence charSequence;
        Log.d((String)TAG, (String)("userId changed from " + oldValue + " to " + newValue));
        if (oldValue != null && !Intrinsics.areEqual((Object)oldValue, (Object)newValue)) {
            GameDurationService gameDurationService = this.gameDurationService;
            if (gameDurationService != null) {
                gameDurationService.submitOldUserGameDuration(oldValue, newValue);
            }
        }
        if (!((charSequence = (CharSequence)this.getCurrentUserId()) == null || charSequence.length() == 0)) {
            GameDurationService gameDurationService = this.gameDurationService;
            if (gameDurationService != null) {
                gameDurationService.setUserStartTimeAtInMillis(System.currentTimeMillis());
            }
        }
    }

    private static final String provideNetworkApi$getBaseUrl(TapDB this$0) {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[this$0.options.getRegion().ordinal()]) {
            case 1: {
                string = "https://e.tapdb.net";
                break;
            }
            case 2: {
                string = "https://e.tapdb.ap-sg.tapapis.com";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    public static final /* synthetic */ EventProcessor access$getEventProcessor$p(TapDB $this) {
        return $this.eventProcessor;
    }

    public static final /* synthetic */ RealChain access$getChain$p(TapDB $this) {
        return $this.chain;
    }

    public /* synthetic */ TapDB(Builder builder, DefaultConstructorMarker $constructor_marker) {
        this(builder);
    }

    public static final /* synthetic */ void access$onUserIdChange(TapDB $this, String oldValue, String newValue) {
        $this.onUserIdChange(oldValue, newValue);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(TapDB.class, "currentUserId", "getCurrentUserId()Ljava/lang/String;", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
        options$delegate = Delegates.INSTANCE.notNull();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u001b\u001a\u00020\u00002\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bJ\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0006J\u000e\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0013J\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0017R\"\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tRB\u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b0\n2\u0018\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b0\n@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\"\u0010\u0014\u001a\u0004\u0018\u00010\u00132\b\u0010\u0005\u001a\u0004\u0018\u00010\u0013@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\"\u0010\u0018\u001a\u0004\u0018\u00010\u00172\b\u0010\u0005\u001a\u0004\u0018\u00010\u0017@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006#"}, d2={"Lcom/taptap/sdk/db/TapDB$Builder;", "", "options", "Lcom/taptap/sdk/initializer/api/option/TapTapSdkOptions;", "(Lcom/taptap/sdk/initializer/api/option/TapTapSdkOptions;)V", "<set-?>", "Lcom/taptap/sdk/db/processor/EventProcessor$Config;", "config", "getConfig$tap_db_release", "()Lcom/taptap/sdk/db/processor/EventProcessor$Config;", "", "Lcom/taptap/sdk/db/interceptor/Interceptor;", "Lcom/taptap/sdk/db/data/model/WrapEvent;", "Lcom/taptap/sdk/db/data/model/Event;", "interceptors", "getInterceptors$tap_db_release", "()Ljava/util/List;", "getOptions", "()Lcom/taptap/sdk/initializer/api/option/TapTapSdkOptions;", "Lcom/taptap/sdk/db/properties/PredefinedProvider;", "predefinedProvider", "getPredefinedProvider$tap_db_release", "()Lcom/taptap/sdk/db/properties/PredefinedProvider;", "Lcom/taptap/sdk/db/properties/SystemProvider;", "systemProvider", "getSystemProvider$tap_db_release", "()Lcom/taptap/sdk/db/properties/SystemProvider;", "addInterceptor", "interceptor", "build", "Lcom/taptap/sdk/db/TapDB;", "configuration", "setPredefinedProvider", "provider", "setSystemProvider", "tap-db_release"})
    public static final class Builder {
        @NotNull
        private final TapTapSdkOptions options;
        @Nullable
        private EventProcessor.Config config;
        @NotNull
        private List<? extends Interceptor<WrapEvent, Event>> interceptors;
        @Nullable
        private PredefinedProvider predefinedProvider;
        @Nullable
        private SystemProvider systemProvider;

        public Builder(@NotNull TapTapSdkOptions options) {
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            this.options = options;
            this.interceptors = CollectionsKt.emptyList();
        }

        @NotNull
        public final TapTapSdkOptions getOptions() {
            return this.options;
        }

        @Nullable
        public final EventProcessor.Config getConfig$tap_db_release() {
            return this.config;
        }

        @NotNull
        public final List<Interceptor<WrapEvent, Event>> getInterceptors$tap_db_release() {
            return this.interceptors;
        }

        @Nullable
        public final PredefinedProvider getPredefinedProvider$tap_db_release() {
            return this.predefinedProvider;
        }

        @Nullable
        public final SystemProvider getSystemProvider$tap_db_release() {
            return this.systemProvider;
        }

        @NotNull
        public final Builder configuration(@NotNull EventProcessor.Config config) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Builder $this$configuration_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$configuration_u24lambda_u240.config = config;
            return builder;
        }

        @NotNull
        public final Builder addInterceptor(@NotNull Interceptor<WrapEvent, Event> interceptor) {
            Builder builder;
            Intrinsics.checkNotNullParameter(interceptor, (String)"interceptor");
            Builder $this$addInterceptor_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$addInterceptor_u24lambda_u241.interceptors = CollectionsKt.plus((Collection)$this$addInterceptor_u24lambda_u241.interceptors, interceptor);
            return builder;
        }

        @NotNull
        public final Builder setPredefinedProvider(@NotNull PredefinedProvider provider) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            Builder $this$setPredefinedProvider_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$setPredefinedProvider_u24lambda_u242.predefinedProvider = provider;
            return builder;
        }

        @NotNull
        public final Builder setSystemProvider(@NotNull SystemProvider provider) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            Builder $this$setSystemProvider_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$setSystemProvider_u24lambda_u243.systemProvider = provider;
            return builder;
        }

        @NotNull
        public final TapDB build() {
            return new TapDB(this, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0010\u001a\u00020\u0004R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R+\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b8@@@X\u0080\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0011"}, d2={"Lcom/taptap/sdk/db/TapDB$Companion;", "", "()V", "INSTANCE", "Lcom/taptap/sdk/db/TapDB;", "TAG", "", "<set-?>", "Lcom/taptap/sdk/initializer/api/option/TapTapSdkOptions;", "options", "getOptions$tap_db_release", "()Lcom/taptap/sdk/initializer/api/option/TapTapSdkOptions;", "setOptions$tap_db_release", "(Lcom/taptap/sdk/initializer/api/option/TapTapSdkOptions;)V", "options$delegate", "Lkotlin/properties/ReadWriteProperty;", "getInstance", "tap-db_release"})
    public static final class Companion {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

        private Companion() {
        }

        @NotNull
        public final TapTapSdkOptions getOptions$tap_db_release() {
            return (TapTapSdkOptions)options$delegate.getValue((Object)this, $$delegatedProperties[0]);
        }

        public final void setOptions$tap_db_release(@NotNull TapTapSdkOptions tapTapSdkOptions) {
            Intrinsics.checkNotNullParameter((Object)tapTapSdkOptions, (String)"<set-?>");
            options$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)tapTapSdkOptions);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final TapDB getInstance() {
            Companion companion = this;
            synchronized (companion) {
                boolean bl = false;
                TapDB tapDB = INSTANCE;
                if (tapDB == null) {
                    boolean bl2 = false;
                    String string = "TapDB is not initialized, please call TapDB.Builder(context).build().initialize() first";
                    throw new IllegalStateException(string.toString());
                }
                TapDB tapDB2 = tapDB;
                return tapDB2;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Companion.class, "options", "getOptions$tap_db_release()Lcom/taptap/sdk/initializer/api/option/TapTapSdkOptions;", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RegionType.values().length];
            try {
                nArray[RegionType.CN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RegionType.GLOBAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

