/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.db.biz.iap.common;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.IBinder;
import com.taptap.sdk.db.TapDB;
import com.taptap.sdk.db.biz.iap.common.InAppPurchaseUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010&\u001a\u0004\u0018\u00010\u00012\u0006\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010*H\u0007J\b\u0010+\u001a\u00020,H\u0007J0\u0010-\u001a\u0012\u0012\u0004\u0012\u00020\u00040.j\b\u0012\u0004\u0012\u00020\u0004`/2\u0016\u00100\u001a\u0012\u0012\u0004\u0012\u00020\u00040.j\b\u0012\u0004\u0012\u00020\u0004`/H\u0002J\u001e\u00101\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001f2\u0006\u0010'\u001a\u00020(2\u0006\u00102\u001a\u00020\u0004H\u0002J\u001e\u00103\u001a\u0004\u0018\u00010\"2\n\u00104\u001a\u0006\u0012\u0002\b\u00030\u001f2\u0006\u00105\u001a\u00020\u0004H\u0002J0\u00106\u001a\u0012\u0012\u0004\u0012\u00020\u00040.j\b\u0012\u0004\u0012\u00020\u0004`/2\u0006\u0010'\u001a\u00020(2\u0006\u00107\u001a\u00020\u00012\u0006\u00108\u001a\u00020\u0004H\u0002J*\u00109\u001a\u0012\u0012\u0004\u0012\u00020\u00040.j\b\u0012\u0004\u0012\u00020\u0004`/2\u0006\u0010'\u001a\u00020(2\b\u00107\u001a\u0004\u0018\u00010\u0001H\u0007J2\u0010:\u001a\u0012\u0012\u0004\u0012\u00020\u00040.j\b\u0012\u0004\u0012\u00020\u0004`/2\u0006\u0010'\u001a\u00020(2\b\u00107\u001a\u0004\u0018\u00010\u00012\u0006\u00108\u001a\u00020\u0004H\u0002J*\u0010;\u001a\u0012\u0012\u0004\u0012\u00020\u00040.j\b\u0012\u0004\u0012\u00020\u0004`/2\u0006\u0010'\u001a\u00020(2\b\u00107\u001a\u0004\u0018\u00010\u0001H\u0007J*\u0010<\u001a\u0012\u0012\u0004\u0012\u00020\u00040.j\b\u0012\u0004\u0012\u00020\u0004`/2\u0006\u0010'\u001a\u00020(2\b\u00107\u001a\u0004\u0018\u00010\u0001H\u0007JF\u0010=\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040>2\u0006\u0010'\u001a\u00020(2\u0016\u0010?\u001a\u0012\u0012\u0004\u0012\u00020\u00040.j\b\u0012\u0004\u0012\u00020\u0004`/2\b\u00107\u001a\u0004\u0018\u00010\u00012\u0006\u0010@\u001a\u00020AH\u0007JF\u0010B\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040>2\u0006\u0010'\u001a\u00020(2\u0016\u0010?\u001a\u0012\u0012\u0004\u0012\u00020\u00040.j\b\u0012\u0004\u0012\u00020\u0004`/2\b\u00107\u001a\u0004\u0018\u00010\u00012\u0006\u0010@\u001a\u00020AH\u0002J\u000e\u0010C\u001a\u00020A2\u0006\u0010D\u001a\u00020\u0004JA\u0010E\u001a\u0004\u0018\u00010\u00012\u0006\u0010'\u001a\u00020(2\u0006\u00102\u001a\u00020\u00042\u0006\u00105\u001a\u00020\u00042\b\u0010F\u001a\u0004\u0018\u00010\u00012\u000e\u0010G\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010HH\u0002\u00a2\u0006\u0002\u0010IJ\"\u0010J\u001a\u00020A2\u0006\u0010'\u001a\u00020(2\b\u00107\u001a\u0004\u0018\u00010\u00012\u0006\u00108\u001a\u00020\u0004H\u0002J,\u0010K\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040L2\u0016\u0010?\u001a\u0012\u0012\u0004\u0012\u00020\u00040.j\b\u0012\u0004\u0012\u00020\u0004`/H\u0002J\u001c\u0010M\u001a\u00020,2\u0012\u0010N\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040>H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n \u0015*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R2\u0010\u001d\u001a&\u0012\u0004\u0012\u00020\u0004\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001f0\u001ej\u0012\u0012\u0004\u0012\u00020\u0004\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001f` X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010!\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\"0\u001ej\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\"` X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010#\u001a\n \u0015*\u0004\u0018\u00010$0$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010%\u001a\n \u0015*\u0004\u0018\u00010$0$X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006O"}, d2={"Lcom/taptap/sdk/db/biz/iap/common/IAPEventUtils;", "", "()V", "AS_INTERFACE", "", "CACHE_CLEAR_TIME_LIMIT_SEC", "", "DETAILS_LIST", "GET_PURCHASES", "GET_PURCHASE_HISTORY", "GET_SKU_DETAILS", "INAPP", "INAPP_CONTINUATION_TOKEN", "INAPP_PURCHASE_DATA_LIST", "IN_APP_BILLING_SERVICE", "IN_APP_BILLING_SERVICE_STUB", "IS_BILLING_SUPPORTED", "ITEM_ID_LIST", "LAST_CLEARED_TIME", "MAX_QUERY_PURCHASE_NUM", "PACKAGE_NAME", "kotlin.jvm.PlatformType", "PURCHASE_EXPIRE_TIME_SEC", "PURCHASE_INAPP_STORE", "PURCHASE_STOP_QUERY_TIME_SEC", "RESPONSE_CODE", "SKU_DETAILS_STORE", "SKU_DETAIL_EXPIRE_TIME_SEC", "SUBSCRIPTION", "classMap", "Ljava/util/HashMap;", "Ljava/lang/Class;", "Lkotlin/collections/HashMap;", "methodMap", "Ljava/lang/reflect/Method;", "purchaseInappSharedPrefs", "Landroid/content/SharedPreferences;", "skuDetailSharedPrefs", "asInterface", "context", "Landroid/content/Context;", "service", "Landroid/os/IBinder;", "clearSkuDetailsCache", "", "filterPurchases", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "purchases", "getClass", "className", "getMethod", "classObj", "methodName", "getPurchaseHistory", "inAppBillingObj", "type", "getPurchaseHistoryInapp", "getPurchases", "getPurchasesInapp", "getPurchasesSubs", "getSkuDetails", "", "skuList", "isSubscription", "", "getSkuDetailsFromGoogle", "hasFreeTrialPeirod", "skuDetail", "invokeMethod", "obj", "args", "", "(Landroid/content/Context;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;", "isBillingSupported", "readSkuDetailsFromCache", "", "writeSkuDetailsToCache", "skuDetailsMap", "tap-db_release"})
public final class IAPEventUtils {
    @NotNull
    public static final IAPEventUtils INSTANCE = new IAPEventUtils();
    @NotNull
    private static final HashMap<String, Method> methodMap = new HashMap();
    @NotNull
    private static final HashMap<String, Class<?>> classMap = new HashMap();
    private static final int CACHE_CLEAR_TIME_LIMIT_SEC = 604800;
    private static final int SKU_DETAIL_EXPIRE_TIME_SEC = 43200;
    @NotNull
    private static final String SUBSCRIPTION = "subs";
    @NotNull
    private static final String INAPP = "inapp";
    private static final int PURCHASE_EXPIRE_TIME_SEC = 86400;
    private static final int PURCHASE_STOP_QUERY_TIME_SEC = 1200;
    private static final int MAX_QUERY_PURCHASE_NUM = 30;
    @NotNull
    private static final String IN_APP_BILLING_SERVICE_STUB = "com.android.vending.billing.IInAppBillingService$Stub";
    @NotNull
    private static final String IN_APP_BILLING_SERVICE = "com.android.vending.billing.IInAppBillingService";
    @NotNull
    private static final String AS_INTERFACE = "asInterface";
    @NotNull
    private static final String GET_SKU_DETAILS = "getSkuDetails";
    @NotNull
    private static final String GET_PURCHASES = "getPurchases";
    @NotNull
    private static final String GET_PURCHASE_HISTORY = "getPurchaseHistory";
    @NotNull
    private static final String IS_BILLING_SUPPORTED = "isBillingSupported";
    @NotNull
    private static final String ITEM_ID_LIST = "ITEM_ID_LIST";
    @NotNull
    private static final String RESPONSE_CODE = "RESPONSE_CODE";
    @NotNull
    private static final String DETAILS_LIST = "DETAILS_LIST";
    @NotNull
    private static final String INAPP_PURCHASE_DATA_LIST = "INAPP_PURCHASE_DATA_LIST";
    @NotNull
    private static final String INAPP_CONTINUATION_TOKEN = "INAPP_CONTINUATION_TOKEN";
    @NotNull
    private static final String LAST_CLEARED_TIME = "LAST_CLEARED_TIME";
    private static final String PACKAGE_NAME = TapDB.Companion.getOptions$tap_db_release().getContext().getPackageName();
    @NotNull
    private static final String SKU_DETAILS_STORE = "com.taptap.internal.SKU_DETAILS";
    @NotNull
    private static final String PURCHASE_INAPP_STORE = "com.taptap.internal.PURCHASE";
    private static final SharedPreferences skuDetailSharedPrefs = TapDB.Companion.getOptions$tap_db_release().getContext().getSharedPreferences("com.taptap.internal.SKU_DETAILS", 0);
    private static final SharedPreferences purchaseInappSharedPrefs = TapDB.Companion.getOptions$tap_db_release().getContext().getSharedPreferences("com.taptap.internal.PURCHASE", 0);

    private IAPEventUtils() {
    }

    @JvmStatic
    @Nullable
    public static final Object asInterface(@NotNull Context context, @Nullable IBinder service) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object[] objectArray = new Object[]{service};
        Object[] args = objectArray;
        return INSTANCE.invokeMethod(context, IN_APP_BILLING_SERVICE_STUB, AS_INTERFACE, null, args);
    }

    @JvmStatic
    @NotNull
    public static final Map<String, String> getSkuDetails(@NotNull Context context, @NotNull ArrayList<String> skuList, @Nullable Object inAppBillingObj, boolean isSubscription) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(skuList, (String)"skuList");
        Map<String, String> skuDetailsMap = INSTANCE.readSkuDetailsFromCache(skuList);
        ArrayList<String> unresolvedSkuList = new ArrayList<String>();
        for (String sku : skuList) {
            if (skuDetailsMap.containsKey(sku)) continue;
            unresolvedSkuList.add(sku);
        }
        skuDetailsMap.putAll(INSTANCE.getSkuDetailsFromGoogle(context, unresolvedSkuList, inAppBillingObj, isSubscription));
        return skuDetailsMap;
    }

    private final Map<String, String> getSkuDetailsFromGoogle(Context context, ArrayList<String> skuList, Object inAppBillingObj, boolean isSubscription) {
        Bundle bundle;
        int response;
        Map skuDetailsMap = new LinkedHashMap();
        if (inAppBillingObj == null || skuList.isEmpty()) {
            return skuDetailsMap;
        }
        Bundle querySkus = new Bundle();
        querySkus.putStringArrayList(ITEM_ID_LIST, skuList);
        Object[] objectArray = new Object[]{3, PACKAGE_NAME, isSubscription ? SUBSCRIPTION : INAPP, querySkus};
        Object[] args = objectArray;
        Object result = this.invokeMethod(context, IN_APP_BILLING_SERVICE, GET_SKU_DETAILS, inAppBillingObj, args);
        if (result != null && (response = (bundle = (Bundle)result).getInt(RESPONSE_CODE)) == 0) {
            ArrayList skuDetailsList = bundle.getStringArrayList(DETAILS_LIST);
            if (skuDetailsList != null && skuList.size() == skuDetailsList.size()) {
                int n = skuList.size();
                for (int i = 0; i < n; ++i) {
                    Object e;
                    String string;
                    Map map2 = skuDetailsMap;
                    Intrinsics.checkNotNullExpressionValue((Object)skuList.get(i), (String)"skuList[i]");
                    Intrinsics.checkNotNullExpressionValue(skuDetailsList.get(i), (String)"skuDetailsList[i]");
                    map2.put(string, e);
                }
            }
            this.writeSkuDetailsToCache(skuDetailsMap);
        }
        return skuDetailsMap;
    }

    private final Map<String, String> readSkuDetailsFromCache(ArrayList<String> skuList) {
        Map skuDetailsMap = new LinkedHashMap();
        long nowSec = System.currentTimeMillis() / 1000L;
        for (String sku : skuList) {
            String rawString = skuDetailSharedPrefs.getString(sku, null);
            if (rawString == null) continue;
            String[] stringArray = new String[]{";"};
            List splitted = StringsKt.split$default((CharSequence)rawString, (String[])stringArray, (boolean)false, (int)2, (int)2, null);
            long timeSec = Long.parseLong((String)splitted.get(0));
            if (nowSec - timeSec >= 43200L) continue;
            Intrinsics.checkNotNullExpressionValue((Object)sku, (String)"sku");
            skuDetailsMap.put(sku, splitted.get(1));
        }
        return skuDetailsMap;
    }

    private final void writeSkuDetailsToCache(Map<String, String> skuDetailsMap) {
        long nowSec = System.currentTimeMillis() / 1000L;
        SharedPreferences.Editor editor = skuDetailSharedPrefs.edit();
        for (Map.Entry<String, String> entry : skuDetailsMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            editor.putString(key, "" + nowSec + ';' + value);
        }
        editor.apply();
    }

    private final boolean isBillingSupported(Context context, Object inAppBillingObj, String type) {
        if (inAppBillingObj == null) {
            return false;
        }
        Object[] objectArray = new Object[]{3, PACKAGE_NAME, type};
        Object[] args = objectArray;
        Object result = this.invokeMethod(context, IN_APP_BILLING_SERVICE, IS_BILLING_SUPPORTED, inAppBillingObj, args);
        return result != null && (Integer)result == 0;
    }

    @JvmStatic
    @NotNull
    public static final ArrayList<String> getPurchasesInapp(@NotNull Context context, @Nullable Object inAppBillingObj) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return INSTANCE.filterPurchases(INSTANCE.getPurchases(context, inAppBillingObj, INAPP));
    }

    @JvmStatic
    @NotNull
    public static final ArrayList<String> getPurchasesSubs(@NotNull Context context, @Nullable Object inAppBillingObj) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return INSTANCE.filterPurchases(INSTANCE.getPurchases(context, inAppBillingObj, SUBSCRIPTION));
    }

    private final ArrayList<String> getPurchases(Context context, Object inAppBillingObj, String type) {
        ArrayList<String> purchases = new ArrayList<String>();
        if (inAppBillingObj == null) {
            return purchases;
        }
        if (this.isBillingSupported(context, inAppBillingObj, type)) {
            String continuationToken = null;
            int queriedPurchaseNum = 0;
            do {
                Bundle purchaseDetails;
                int response;
                Object[] objectArray = new Object[]{3, PACKAGE_NAME, type, continuationToken};
                Object[] args = objectArray;
                Object result = this.invokeMethod(context, IN_APP_BILLING_SERVICE, GET_PURCHASES, inAppBillingObj, args);
                continuationToken = null;
                if (result == null || (response = (purchaseDetails = (Bundle)result).getInt(RESPONSE_CODE)) != 0) continue;
                ArrayList details = purchaseDetails.getStringArrayList(INAPP_PURCHASE_DATA_LIST);
                if (details == null) break;
                queriedPurchaseNum += details.size();
                purchases.addAll(details);
                continuationToken = purchaseDetails.getString(INAPP_CONTINUATION_TOKEN);
            } while (queriedPurchaseNum < 30 && continuationToken != null);
        }
        return purchases;
    }

    public final boolean hasFreeTrialPeirod(@NotNull String skuDetail) {
        Intrinsics.checkNotNullParameter((Object)skuDetail, (String)"skuDetail");
        try {
            JSONObject skuDetailsJson = new JSONObject(skuDetail);
            String freeTrialPeriod = skuDetailsJson.optString("freeTrialPeriod");
            return freeTrialPeriod != null && ((CharSequence)freeTrialPeriod).length() > 0;
        }
        catch (JSONException jSONException) {
            return false;
        }
    }

    @JvmStatic
    @NotNull
    public static final ArrayList<String> getPurchaseHistoryInapp(@NotNull Context context, @Nullable Object inAppBillingObj) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ArrayList<String> purchases = new ArrayList<String>();
        if (inAppBillingObj == null) {
            return purchases;
        }
        Class<?> clazz = INSTANCE.getClass(context, IN_APP_BILLING_SERVICE);
        if (clazz == null) {
            return purchases;
        }
        Class<?> iapClass = clazz;
        if (INSTANCE.getMethod(iapClass, GET_PURCHASE_HISTORY) == null) {
            return purchases;
        }
        purchases = INSTANCE.getPurchaseHistory(context, inAppBillingObj, INAPP);
        return INSTANCE.filterPurchases(purchases);
    }

    private final ArrayList<String> getPurchaseHistory(Context context, Object inAppBillingObj, String type) {
        ArrayList<String> purchases = new ArrayList<String>();
        if (this.isBillingSupported(context, inAppBillingObj, type)) {
            String continuationToken = null;
            int queriedPurchaseNum = 0;
            boolean reachTimeLimit = false;
            do {
                ArrayList details;
                Object[] objectArray = new Object[]{6, PACKAGE_NAME, type, continuationToken, new Bundle()};
                Object[] args = objectArray;
                continuationToken = null;
                Object result = this.invokeMethod(context, IN_APP_BILLING_SERVICE, GET_PURCHASE_HISTORY, inAppBillingObj, args);
                if (result == null) continue;
                long nowSec = System.currentTimeMillis() / 1000L;
                Bundle purchaseDetails = (Bundle)result;
                int response = purchaseDetails.getInt(RESPONSE_CODE);
                if (response != 0 || purchaseDetails.getStringArrayList(INAPP_PURCHASE_DATA_LIST) == null) continue;
                for (String detail : details) {
                    try {
                        JSONObject detailJson = new JSONObject(detail);
                        long purchaseTimeSec = detailJson.getLong("purchaseTime") / 1000L;
                        if (nowSec - purchaseTimeSec > 1200L) {
                            reachTimeLimit = true;
                            break;
                        }
                        purchases.add(detail);
                        ++queriedPurchaseNum;
                    }
                    catch (JSONException jSONException) {}
                }
                continuationToken = purchaseDetails.getString(INAPP_CONTINUATION_TOKEN);
            } while (queriedPurchaseNum < 30 && continuationToken != null && !reachTimeLimit);
        }
        return purchases;
    }

    private final ArrayList<String> filterPurchases(ArrayList<String> purchases) {
        ArrayList<String> filteredPurchase = new ArrayList<String>();
        SharedPreferences.Editor editor = purchaseInappSharedPrefs.edit();
        long nowSec = System.currentTimeMillis() / 1000L;
        for (String purchase : purchases) {
            try {
                String historyPurchaseToken;
                JSONObject purchaseJson = new JSONObject(purchase);
                String sku = purchaseJson.getString("productId");
                long purchaseTimeMillis = purchaseJson.getLong("purchaseTime");
                String purchaseToken = purchaseJson.getString("purchaseToken");
                if (nowSec - purchaseTimeMillis / 1000L > 86400L || Intrinsics.areEqual((Object)(historyPurchaseToken = purchaseInappSharedPrefs.getString(sku, "")), (Object)purchaseToken)) continue;
                editor.putString(sku, purchaseToken);
                filteredPurchase.add(purchase);
            }
            catch (JSONException jSONException) {}
        }
        editor.apply();
        return filteredPurchase;
    }

    private final Method getMethod(Class<?> classObj, String methodName) {
        Method method;
        Class[] classArray;
        Method method2 = methodMap.get(methodName);
        if (method2 != null) {
            return method2;
        }
        Class[] paramTypes = null;
        switch (methodName) {
            case "asInterface": {
                classArray = new Class[]{IBinder.class};
                paramTypes = classArray;
                break;
            }
            case "getSkuDetails": {
                classArray = new Class[4];
                Intrinsics.checkNotNullExpressionValue(Integer.TYPE, (String)"TYPE");
                classArray[1] = String.class;
                classArray[2] = String.class;
                classArray[3] = Bundle.class;
                paramTypes = classArray;
                break;
            }
            case "isBillingSupported": {
                classArray = new Class[3];
                Intrinsics.checkNotNullExpressionValue(Integer.TYPE, (String)"TYPE");
                classArray[1] = String.class;
                classArray[2] = String.class;
                paramTypes = classArray;
                break;
            }
            case "getPurchases": {
                classArray = new Class[4];
                Intrinsics.checkNotNullExpressionValue(Integer.TYPE, (String)"TYPE");
                classArray[1] = String.class;
                classArray[2] = String.class;
                classArray[3] = String.class;
                paramTypes = classArray;
                break;
            }
            case "getPurchaseHistory": {
                classArray = new Class[5];
                Intrinsics.checkNotNullExpressionValue(Integer.TYPE, (String)"TYPE");
                classArray[1] = String.class;
                classArray[2] = String.class;
                classArray[3] = String.class;
                classArray[4] = Bundle.class;
                paramTypes = classArray;
            }
        }
        Class[] parameterTypes = paramTypes;
        if (parameterTypes == null) {
            classArray = new Class[]{null};
            method = InAppPurchaseUtils.getDeclaredMethod$tap_db_release(classObj, methodName, classArray);
        } else {
            method = method2 = InAppPurchaseUtils.getDeclaredMethod$tap_db_release(classObj, methodName, (Class[])Arrays.copyOf(parameterTypes, parameterTypes.length));
        }
        if (method2 != null) {
            ((Map)methodMap).put(methodName, method2);
        }
        return method2;
    }

    private final Class<?> getClass(Context context, String className) {
        Class<?> classObj = classMap.get(className);
        if (classObj != null) {
            return classObj;
        }
        classObj = InAppPurchaseUtils.getClassFromContext$tap_db_release(context, className);
        if (classObj != null) {
            ((Map)classMap).put(className, classObj);
        }
        return classObj;
    }

    private final Object invokeMethod(Context context, String className, String methodName, Object obj, Object[] args) {
        Object obj2 = obj;
        Class<?> clazz = this.getClass(context, className);
        if (clazz == null) {
            return null;
        }
        Class<?> classObj = clazz;
        Method method = this.getMethod(classObj, methodName);
        if (method == null) {
            return null;
        }
        Method method2 = method;
        return InAppPurchaseUtils.invokeMethod(classObj, method2, obj2, Arrays.copyOf(args, args.length));
    }

    @JvmStatic
    public static final void clearSkuDetailsCache() {
        long nowSec = System.currentTimeMillis() / 1000L;
        long lastClearedTimeSec = skuDetailSharedPrefs.getLong(LAST_CLEARED_TIME, 0L);
        if (lastClearedTimeSec == 0L) {
            skuDetailSharedPrefs.edit().putLong(LAST_CLEARED_TIME, nowSec).apply();
        } else if (nowSec - lastClearedTimeSec > 604800L) {
            skuDetailSharedPrefs.edit().clear().putLong(LAST_CLEARED_TIME, nowSec).apply();
        }
    }
}

