/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.db.biz.iap.lib2plus;

import android.content.SharedPreferences;
import android.support.annotation.VisibleForTesting;
import com.taptap.sdk.db.TapDB;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\u0010\t\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00150\u00142\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00150\rH\u0001\u00a2\u0006\u0002\b\u0017J\r\u0010\u0018\u001a\u00020\u0019H\u0001\u00a2\u0006\u0002\b\u001aJC\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00142\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00150\u00142\u0014\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0014H\u0001\u00a2\u0006\u0002\b\u001dJ\b\u0010\u001e\u001a\u00020\u001fH\u0007J>\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00142\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00150\r2\u0014\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0014H\u0007J\b\u0010!\u001a\u00020\u0019H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/taptap/sdk/db/biz/iap/lib2plus/InAppPurchaseLoggerManager;", "", "()V", "CACHE_CLEAR_TIME_LIMIT_SEC", "", "LAST_CLEARED_TIME", "", "LAST_QUERY_PURCHASE_HISTORY_TIME", "PRODUCT_DETAILS_STORE", "PURCHASE_DETAILS_SET", "PURCHASE_IN_CACHE_INTERVAL", "PURCHASE_TIME", "cachedPurchaseMap", "", "", "cachedPurchaseSet", "", "sharedPreferences", "Landroid/content/SharedPreferences;", "cacheDeDupPurchase", "", "Lorg/json/JSONObject;", "purchaseDetailsMap", "cacheDeDupPurchase$tap_db_release", "clearOutdatedProductInfoInCache", "", "clearOutdatedProductInfoInCache$tap_db_release", "constructLoggingReadyMap", "skuDetailsMap", "constructLoggingReadyMap$tap_db_release", "eligibleQueryPurchaseHistory", "", "filterPurchaseLogging", "readPurchaseCache", "tap-db_release"})
public final class InAppPurchaseLoggerManager {
    @NotNull
    public static final InAppPurchaseLoggerManager INSTANCE = new InAppPurchaseLoggerManager();
    private static SharedPreferences sharedPreferences;
    @NotNull
    private static final Set<String> cachedPurchaseSet;
    @NotNull
    private static final Map<String, Long> cachedPurchaseMap;
    @NotNull
    private static final String PURCHASE_TIME = "purchaseTime";
    @NotNull
    private static final String PRODUCT_DETAILS_STORE = "com.taptap.internal.iap.PRODUCT_DETAILS";
    @NotNull
    private static final String LAST_CLEARED_TIME = "LAST_CLEARED_TIME";
    @NotNull
    private static final String PURCHASE_DETAILS_SET = "PURCHASE_DETAILS_SET";
    @NotNull
    private static final String LAST_QUERY_PURCHASE_HISTORY_TIME = "LAST_QUERY_PURCHASE_HISTORY_TIME";
    private static final int CACHE_CLEAR_TIME_LIMIT_SEC = 604800;
    private static final int PURCHASE_IN_CACHE_INTERVAL = 86400;

    private InAppPurchaseLoggerManager() {
    }

    private final void readPurchaseCache() {
        Object object;
        SharedPreferences cachedSkuSharedPref = TapDB.Companion.getOptions$tap_db_release().getContext().getSharedPreferences("com.taptap.internal.SKU_DETAILS", 0);
        SharedPreferences cachedPurchaseSharedPref = TapDB.Companion.getOptions$tap_db_release().getContext().getSharedPreferences("com.taptap.internal.PURCHASE", 0);
        if (cachedSkuSharedPref.contains(LAST_CLEARED_TIME)) {
            cachedSkuSharedPref.edit().clear().apply();
            cachedPurchaseSharedPref.edit().clear().apply();
        }
        SharedPreferences sharedPreferences = TapDB.Companion.getOptions$tap_db_release().getContext().getSharedPreferences(PRODUCT_DETAILS_STORE, 0);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"TapDB.options.context.ge\u2026RE, Context.MODE_PRIVATE)");
        InAppPurchaseLoggerManager.sharedPreferences = sharedPreferences;
        SharedPreferences sharedPreferences2 = InAppPurchaseLoggerManager.sharedPreferences;
        if (sharedPreferences2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sharedPreferences");
            sharedPreferences2 = null;
        }
        cachedPurchaseSet.addAll((object = sharedPreferences2.getStringSet(PURCHASE_DETAILS_SET, (Set)new HashSet())) == null ? (Collection)new HashSet() : (Collection)object);
        for (String purchaseHistory : cachedPurchaseSet) {
            String[] stringArray = new String[]{";"};
            List splitPurchase = StringsKt.split$default((CharSequence)purchaseHistory, (String[])stringArray, (boolean)false, (int)2, (int)2, null);
            cachedPurchaseMap.put((String)splitPurchase.get(0), Long.parseLong((String)splitPurchase.get(1)));
        }
        this.clearOutdatedProductInfoInCache$tap_db_release();
    }

    @JvmStatic
    @NotNull
    public static final Map<String, String> filterPurchaseLogging(@NotNull Map<String, JSONObject> purchaseDetailsMap, @NotNull Map<String, ? extends JSONObject> skuDetailsMap) {
        Intrinsics.checkNotNullParameter(purchaseDetailsMap, (String)"purchaseDetailsMap");
        Intrinsics.checkNotNullParameter(skuDetailsMap, (String)"skuDetailsMap");
        INSTANCE.readPurchaseCache();
        return INSTANCE.constructLoggingReadyMap$tap_db_release(INSTANCE.cacheDeDupPurchase$tap_db_release(purchaseDetailsMap), skuDetailsMap);
    }

    @VisibleForTesting(otherwise=2)
    @NotNull
    public final Map<String, JSONObject> cacheDeDupPurchase$tap_db_release(@NotNull Map<String, JSONObject> purchaseDetailsMap) {
        Intrinsics.checkNotNullParameter(purchaseDetailsMap, (String)"purchaseDetailsMap");
        long nowSec = System.currentTimeMillis() / 1000L;
        Map tempPurchaseDetailsMap = MapsKt.toMap(purchaseDetailsMap);
        for (Map.Entry entry : tempPurchaseDetailsMap.entrySet()) {
            String key = (String)entry.getKey();
            JSONObject purchaseJson = (JSONObject)entry.getValue();
            try {
                if (!purchaseJson.has("purchaseToken")) continue;
                String purchaseToken = purchaseJson.getString("purchaseToken");
                if (cachedPurchaseMap.containsKey(purchaseToken)) {
                    purchaseDetailsMap.remove(key);
                    continue;
                }
                cachedPurchaseSet.add(purchaseToken + ';' + nowSec);
            }
            catch (Exception exception) {}
        }
        SharedPreferences sharedPreferences = InAppPurchaseLoggerManager.sharedPreferences;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sharedPreferences");
            sharedPreferences = null;
        }
        sharedPreferences.edit().putStringSet(PURCHASE_DETAILS_SET, cachedPurchaseSet).apply();
        return new HashMap<String, JSONObject>(purchaseDetailsMap);
    }

    @VisibleForTesting(otherwise=2)
    public final void clearOutdatedProductInfoInCache$tap_db_release() {
        long lastClearedTimeSec;
        long nowSec = System.currentTimeMillis() / 1000L;
        SharedPreferences sharedPreferences = InAppPurchaseLoggerManager.sharedPreferences;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sharedPreferences");
            sharedPreferences = null;
        }
        if ((lastClearedTimeSec = sharedPreferences.getLong(LAST_CLEARED_TIME, 0L)) == 0L) {
            SharedPreferences sharedPreferences2 = InAppPurchaseLoggerManager.sharedPreferences;
            if (sharedPreferences2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"sharedPreferences");
                sharedPreferences2 = null;
            }
            sharedPreferences2.edit().putLong(LAST_CLEARED_TIME, nowSec).apply();
        } else if (nowSec - lastClearedTimeSec > 604800L) {
            Map tempPurchaseMap = MapsKt.toMap(cachedPurchaseMap);
            for (Map.Entry entry : tempPurchaseMap.entrySet()) {
                String purchaseToken = (String)entry.getKey();
                long historyPurchaseTime = ((Number)entry.getValue()).longValue();
                if (nowSec - historyPurchaseTime <= 86400L) continue;
                cachedPurchaseSet.remove(purchaseToken + ';' + historyPurchaseTime);
                cachedPurchaseMap.remove(purchaseToken);
            }
            SharedPreferences sharedPreferences3 = InAppPurchaseLoggerManager.sharedPreferences;
            if (sharedPreferences3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"sharedPreferences");
                sharedPreferences3 = null;
            }
            sharedPreferences3.edit().putStringSet(PURCHASE_DETAILS_SET, cachedPurchaseSet).putLong(LAST_CLEARED_TIME, nowSec).apply();
        }
    }

    @JvmStatic
    public static final boolean eligibleQueryPurchaseHistory() {
        long lastQueryPurchaseHistoryTime;
        INSTANCE.readPurchaseCache();
        long nowSec = System.currentTimeMillis() / 1000L;
        SharedPreferences sharedPreferences = InAppPurchaseLoggerManager.sharedPreferences;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sharedPreferences");
            sharedPreferences = null;
        }
        if ((lastQueryPurchaseHistoryTime = sharedPreferences.getLong(LAST_QUERY_PURCHASE_HISTORY_TIME, 0L)) != 0L && nowSec - lastQueryPurchaseHistoryTime < 86400L) {
            return false;
        }
        SharedPreferences sharedPreferences2 = InAppPurchaseLoggerManager.sharedPreferences;
        if (sharedPreferences2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sharedPreferences");
            sharedPreferences2 = null;
        }
        sharedPreferences2.edit().putLong(LAST_QUERY_PURCHASE_HISTORY_TIME, nowSec).apply();
        return true;
    }

    @VisibleForTesting(otherwise=2)
    @NotNull
    public final Map<String, String> constructLoggingReadyMap$tap_db_release(@NotNull Map<String, ? extends JSONObject> purchaseDetailsMap, @NotNull Map<String, ? extends JSONObject> skuDetailsMap) {
        Intrinsics.checkNotNullParameter(purchaseDetailsMap, (String)"purchaseDetailsMap");
        Intrinsics.checkNotNullParameter(skuDetailsMap, (String)"skuDetailsMap");
        long nowSec = System.currentTimeMillis() / 1000L;
        Map purchaseResultMap = new LinkedHashMap();
        for (Map.Entry<String, ? extends JSONObject> entry : purchaseDetailsMap.entrySet()) {
            String key = entry.getKey();
            JSONObject purchaseDetail = entry.getValue();
            JSONObject skuDetail = skuDetailsMap.get(key);
            if (purchaseDetail == null || !purchaseDetail.has(PURCHASE_TIME)) continue;
            try {
                String string;
                String string2;
                long purchaseTime = purchaseDetail.getLong(PURCHASE_TIME);
                if (nowSec - purchaseTime / 1000L > 86400L || skuDetail == null) continue;
                Map map2 = purchaseResultMap;
                Intrinsics.checkNotNullExpressionValue((Object)purchaseDetail.toString(), (String)"purchaseDetail.toString()");
                Intrinsics.checkNotNullExpressionValue((Object)skuDetail.toString(), (String)"skuDetail.toString()");
                map2.put(string2, string);
            }
            catch (Exception exception) {}
        }
        return purchaseResultMap;
    }

    static {
        cachedPurchaseSet = new CopyOnWriteArraySet();
        cachedPurchaseMap = new ConcurrentHashMap();
    }
}

