/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.db.biz.iap.lib2plus;

import android.content.Context;
import com.taptap.sdk.db.biz.iap.common.IIAPTracker;
import com.taptap.sdk.db.biz.iap.common.InAppPurchaseUtils;
import com.taptap.sdk.db.biz.iap.lib2plus.InAppPurchaseBillingClientWrapper;
import com.taptap.sdk.db.biz.iap.lib2plus.InAppPurchaseLoggerManager;
import com.taptap.sdk.kit.internal.TapLogger;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0007H\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\tH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/taptap/sdk/db/biz/iap/lib2plus/BillingLib2PlusTracker;", "Lcom/taptap/sdk/db/biz/iap/common/IIAPTracker;", "()V", "BILLING_CLIENT_PURCHASE_NAME", "", "TAG", "listener", "Lcom/taptap/sdk/db/biz/iap/common/IIAPTracker$ILogPurchaseListener;", "logPurchase", "", "setOnLogPurchaseListener", "l", "startTracker", "context", "Landroid/content/Context;", "stopTracker", "tap-db_release"})
public final class BillingLib2PlusTracker
implements IIAPTracker {
    @NotNull
    public static final BillingLib2PlusTracker INSTANCE = new BillingLib2PlusTracker();
    @NotNull
    private static final String TAG = "BillingLib2PlusTracker";
    @NotNull
    private static final String BILLING_CLIENT_PURCHASE_NAME = "com.android.billingclient.api.Purchase";
    @Nullable
    private static IIAPTracker.ILogPurchaseListener listener;

    private BillingLib2PlusTracker() {
    }

    @Override
    public void startTracker(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        TapLogger.logd((String)TAG, (String)"BillingLib2PlusTracker startTracker");
        if (InAppPurchaseUtils.getClass(BILLING_CLIENT_PURCHASE_NAME) == null) {
            return;
        }
        TapLogger.logd((String)TAG, (String)"BillingLib2PlusTracker purchase class enabled");
        InAppPurchaseBillingClientWrapper inAppPurchaseBillingClientWrapper = InAppPurchaseBillingClientWrapper.Companion.getOrCreateInstance(context);
        if (inAppPurchaseBillingClientWrapper == null) {
            return;
        }
        InAppPurchaseBillingClientWrapper billingClientWrapper = inAppPurchaseBillingClientWrapper;
        TapLogger.logd((String)TAG, (String)"BillingLib2PlusTracker billingClientWrapper enabled");
        if (InAppPurchaseBillingClientWrapper.Companion.isServiceConnected().get()) {
            if (InAppPurchaseLoggerManager.eligibleQueryPurchaseHistory()) {
                billingClientWrapper.queryPurchaseHistory("inapp", BillingLib2PlusTracker::startTracker$lambda$0);
            } else {
                billingClientWrapper.queryPurchase("inapp", BillingLib2PlusTracker::startTracker$lambda$1);
            }
        }
    }

    @Override
    public void stopTracker() {
    }

    @Override
    public void setOnLogPurchaseListener(@NotNull IIAPTracker.ILogPurchaseListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        listener = l;
    }

    private final void logPurchase() {
        Map<String, String> logMap = InAppPurchaseLoggerManager.filterPurchaseLogging(InAppPurchaseBillingClientWrapper.Companion.getPurchaseDetailsMap(), InAppPurchaseBillingClientWrapper.Companion.getSkuDetailsMap());
        for (Map.Entry<String, String> entry : logMap.entrySet()) {
            String purchaseDetails = entry.getKey();
            String skuDetails = entry.getValue();
            if (purchaseDetails == null || skuDetails == null) continue;
            IIAPTracker.ILogPurchaseListener iLogPurchaseListener = listener;
            if (iLogPurchaseListener == null) continue;
            iLogPurchaseListener.onLogPurchase(purchaseDetails, skuDetails, false);
        }
        InAppPurchaseBillingClientWrapper.Companion.getPurchaseDetailsMap().clear();
    }

    private static final void startTracker$lambda$0() {
        INSTANCE.logPurchase();
    }

    private static final void startTracker$lambda$1() {
        INSTANCE.logPurchase();
    }
}

