/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.db.interceptor;

import com.taptap.sdk.db.data.model.Event;
import com.taptap.sdk.db.data.model.WrapEvent;
import com.taptap.sdk.db.interceptor.Interceptor;
import com.taptap.sdk.db.utils.JSONObjectUtils;
import com.taptap.sdk.db.utils.MapUtils2;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \t2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0004J%\u0010\u0005\u001a\u00020\u00032\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0007H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\b\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\n"}, d2={"Lcom/taptap/sdk/db/interceptor/EventVerifyInterceptor;", "Lcom/taptap/sdk/db/interceptor/Interceptor;", "Lcom/taptap/sdk/db/data/model/WrapEvent;", "Lcom/taptap/sdk/db/data/model/Event;", "()V", "intercept", "chain", "Lcom/taptap/sdk/db/interceptor/Interceptor$Chain;", "(Lcom/taptap/sdk/db/interceptor/Interceptor$Chain;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "tap-db_release"})
public final class EventVerifyInterceptor
implements Interceptor<WrapEvent, Event> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int EVENT_NAME_MAX_LENGTH = 256;
    public static final int PROPERTIES_MAX_LENGTH = 256;

    @Override
    @Nullable
    public Object intercept(@NotNull Interceptor.Chain<WrapEvent, Event> chain, @NotNull Continuation<? super Event> $completion) {
        WrapEvent wrapEvent = chain.getRequest();
        if (wrapEvent == null) {
            String string2 = "Required value was null.";
            throw new IllegalArgumentException(string2.toString());
        }
        WrapEvent wrapEvent2 = wrapEvent;
        String eventName = wrapEvent2.getEvent().getName();
        if (wrapEvent2.isCustomEvent()) {
            CharSequence charSequence = eventName;
            if (charSequence == null || charSequence.length() == 0) {
                throw new IllegalArgumentException("Event name is null or empty");
            }
            if (eventName.length() > 256) {
                throw new IllegalStateException("EventName is too long, max length is 256");
            }
        }
        Map eventProperties = MapUtils2.filterRecursively$default(MapUtils2.INSTANCE, JSONObjectUtils.INSTANCE.toMap(wrapEvent2.getEvent().getProperties()), null, 1, null);
        return chain.process(wrapEvent2.newBuilder((Function1<? super WrapEvent.Builder, Unit>)((Function1)new Function1<WrapEvent.Builder, Unit>((Map<String, ? extends Object>)eventProperties){
            final /* synthetic */ Map<String, Object> $eventProperties;
            {
                this.$eventProperties = $eventProperties;
                super(1);
            }

            public final void invoke(@NotNull WrapEvent.Builder $this$newBuilder) {
                Intrinsics.checkNotNullParameter((Object)$this$newBuilder, (String)"$this$newBuilder");
                Event event = $this$newBuilder.getEvent$tap_db_release();
                if (event == null) {
                    String string2 = "Required value was null.";
                    throw new IllegalStateException(string2.toString());
                }
                $this$newBuilder.setEvent(event.reduce((Function1<? super Event, Event>)((Function1)new Function1<Event, Event>(this.$eventProperties){
                    final /* synthetic */ Map<String, Object> $eventProperties;
                    {
                        this.$eventProperties = $eventProperties;
                        super(1);
                    }

                    @NotNull
                    public final Event invoke(@NotNull Event $this$reduce) {
                        Intrinsics.checkNotNullParameter((Object)$this$reduce, (String)"$this$reduce");
                        return Event.copy$default($this$reduce, null, null, null, 0L, new JSONObject(this.$eventProperties), 15, null);
                    }
                })));
            }
        })), $completion);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/taptap/sdk/db/interceptor/EventVerifyInterceptor$Companion;", "", "()V", "EVENT_NAME_MAX_LENGTH", "", "PROPERTIES_MAX_LENGTH", "tap-db_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

