/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.db.repository;

import android.util.Log;
import com.taptap.sdk.common.network.throwable.TapNetworkException;
import com.taptap.sdk.db.data.model.Event;
import com.taptap.sdk.db.data.request.TrackEventRequest;
import com.taptap.sdk.db.repository.EventApi;
import com.taptap.sdk.db.repository.EventRepository;
import com.taptap.sdk.db.storage.PersistentQueue;
import com.taptap.sdk.db.utils.JSONObjectUtils;
import com.taptap.sdk.db.utils.MapUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bH\u0002J\u0019\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010J\u0006\u0010\u0011\u001a\u00020\u000fJ\u0019\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0004H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0016"}, d2={"Lcom/taptap/sdk/db/repository/EventRepository;", "", "eventQueue", "Lcom/taptap/sdk/db/storage/PersistentQueue;", "Lcom/taptap/sdk/db/data/model/Event;", "eventApi", "Lcom/taptap/sdk/db/repository/EventApi;", "(Lcom/taptap/sdk/db/storage/PersistentQueue;Lcom/taptap/sdk/db/repository/EventApi;)V", "buildTrackEventRequest", "Lcom/taptap/sdk/db/data/request/TrackEventRequest;", "events", "", "flushEvents", "", "maxSendEventCount", "", "(ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getEventQueueSize", "submitEvent", "event", "(Lcom/taptap/sdk/db/data/model/Event;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "tap-db_release"})
public final class EventRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PersistentQueue<Event> eventQueue;
    @NotNull
    private final EventApi eventApi;
    @NotNull
    private static final String TAG = "EventRepository";

    public EventRepository(@NotNull PersistentQueue<Event> eventQueue, @NotNull EventApi eventApi) {
        Intrinsics.checkNotNullParameter(eventQueue, (String)"eventQueue");
        Intrinsics.checkNotNullParameter((Object)eventApi, (String)"eventApi");
        this.eventQueue = eventQueue;
        this.eventApi = eventApi;
    }

    @Nullable
    public final Object submitEvent(@NotNull Event event, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.eventQueue.enqueue(event, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object flushEvents(int var1_1, @NotNull Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof flushEvents.1)) ** GOTO lbl-1000
        var6_3 = var2_2;
        if ((var6_3.label & -2147483648) != 0) {
            var6_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ EventRepository this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.flushEvents(0, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                pendingEvents = this.eventQueue.peek((int)maxSendEventCount);
                if (pendingEvents.isEmpty()) {
                    Log.d((String)"EventRepository", (String)"No pending events");
                    return Unit.INSTANCE;
                }
                trackEventRequest = this.buildTrackEventRequest(pendingEvents);
                $continuation.L$0 = this;
                $continuation.L$1 = pendingEvents;
                $continuation.label = 1;
                v0 = this.eventApi.sendEvents(trackEventRequest, (Continuation<? super Unit>)$continuation);
                ** if (v0 != var7_5) goto lbl26
lbl25:
                // 1 sources

                return var7_5;
lbl26:
                // 1 sources

                ** GOTO lbl34
            }
            case 1: {
                pendingEvents = (List<Event>)$continuation.L$1;
                this = (EventRepository)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl34:
                // 2 sources

                $continuation.L$0 = this;
                $continuation.L$1 = pendingEvents;
                $continuation.label = 2;
                v1 = this.eventQueue.removeAll(pendingEvents, (Continuation<Unit>)$continuation);
                ** if (v1 != var7_5) goto lbl40
lbl39:
                // 1 sources

                return var7_5;
lbl40:
                // 1 sources

                ** GOTO lbl48
            }
            case 2: {
                pendingEvents = (List)$continuation.L$1;
                this = (EventRepository)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl48:
                    // 2 sources

                    Log.i((String)"EventRepository", (String)("send events success, " + pendingEvents + " removed from queue, " + this.eventQueue.getQueueSize() + " left"));
                    ** GOTO lbl68
                }
                catch (Throwable error) {
                    if (error instanceof TapNetworkException && ((TapNetworkException)error).getErr().getCode() == 400) {
                        Log.i((String)"EventRepository", (String)("send events fail, remove invalid events: " + pendingEvents));
                        $continuation.L$0 = error;
                        $continuation.L$1 = null;
                        $continuation.label = 3;
                        v2 = this.eventQueue.removeAll(pendingEvents, (Continuation<Unit>)$continuation);
                        if (v2 == var7_5) {
                            return var7_5;
                        }
                    }
                    ** GOTO lbl66
                }
            }
            case 3: {
                error = (Throwable)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl66:
                // 2 sources

                Log.i((String)"EventRepository", (String)"send events fail", (Throwable)error);
lbl68:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final int getEventQueueSize() {
        return this.eventQueue.getQueueSize();
    }

    /*
     * WARNING - void declaration
     */
    private final TrackEventRequest buildTrackEventRequest(List<Event> events) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = events;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void event;
            Event event2 = (Event)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(MapUtils.INSTANCE.toJsonElement(JSONObjectUtils.INSTANCE.toMap(event.getProperties())));
        }
        List list = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        return new TrackEventRequest(list);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/taptap/sdk/db/repository/EventRepository$Companion;", "", "()V", "TAG", "", "tap-db_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

