/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.db.service;

import com.taptap.sdk.core.DBService;
import com.taptap.sdk.core.TapTapPurchasedEvent;
import com.taptap.sdk.db.TapDB;
import com.taptap.sdk.db.event.DeviceLoginEvent;
import com.taptap.sdk.db.event.PurchasedEvent;
import com.taptap.sdk.initializer.api.option.TapTapSdkOptions;
import com.taptap.sdk.servicemanager.annotation.Service;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0016J\n\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u00020\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/taptap/sdk/db/service/DBServiceImpl;", "Lcom/taptap/sdk/core/DBService;", "()V", "getCurrentGAID", "", "getCurrentOAID", "sendDeviceLoginEvent", "", "option", "Lcom/taptap/sdk/initializer/api/option/TapTapSdkOptions;", "trackPaymentPurchase", "event", "Lcom/taptap/sdk/core/TapTapPurchasedEvent;", "tap-db_release"})
@Service
public final class DBServiceImpl
implements DBService {
    @Nullable
    public String getCurrentOAID() {
        if (!TapDB.Companion.checkEnable()) {
            return null;
        }
        return TapDB.Companion.getInstance().getCurrentOAID();
    }

    @Nullable
    public String getCurrentGAID() {
        if (!TapDB.Companion.checkEnable()) {
            return null;
        }
        return TapDB.Companion.getInstance().getCurrentGAID();
    }

    public void sendDeviceLoginEvent(@NotNull TapTapSdkOptions option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        if (!TapDB.Companion.checkEnable()) {
            return;
        }
        new DeviceLoginEvent.Builder(option.getProperties()).isAutomatically(true).build().submitNow();
    }

    public void trackPaymentPurchase(@Nullable TapTapPurchasedEvent event) {
        block1: {
            if (!TapDB.Companion.checkEnable()) {
                return;
            }
            TapTapPurchasedEvent tapTapPurchasedEvent = event;
            if (tapTapPurchasedEvent == null) break block1;
            TapTapPurchasedEvent value = tapTapPurchasedEvent;
            boolean bl = false;
            new PurchasedEvent.Builder(value.getProperties()).isAutomatically(false).setOrderId(value.getOrderId()).setProductName(value.getProductName()).setAmount(event.getAmount()).setCurrencyType(value.getCurrencyType()).setPaymentMethod(value.getPaymentMethod()).build().submit();
        }
    }
}

