/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.db.utils;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/taptap/sdk/db/utils/UserIdVerifyTools;", "", "()V", "PATTERN", "Lkotlin/text/Regex;", "verify", "", "userId", "", "tap-db_release"})
public final class UserIdVerifyTools {
    @NotNull
    public static final UserIdVerifyTools INSTANCE = new UserIdVerifyTools();
    @NotNull
    private static final Regex PATTERN = new Regex("^[a-zA-Z0-9_\\-+/=.,:]{1,160}$");

    private UserIdVerifyTools() {
    }

    public final void verify(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        if (((CharSequence)userId).length() == 0) {
            throw new IllegalStateException("userId is empty, userId: " + userId);
        }
        if (!PATTERN.matches((CharSequence)userId)) {
            throw new IllegalStateException("userId is invalid, userId: " + userId);
        }
        if (userId.length() > 160) {
            throw new IllegalStateException("userId is too long, userId: " + userId);
        }
    }
}

