/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.db.biz.iap;

import android.app.Activity;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Bundle;
import com.taptap.sdk.base.utils.lifecycle.TapActivityLifecycleCallbacks;
import com.taptap.sdk.base.utils.lifecycle.TapActivityLifecycleTracker;
import com.taptap.sdk.db.TapDB;
import com.taptap.sdk.db.biz.iap.InAppPurchaseManager;
import com.taptap.sdk.db.biz.iap.common.AutomaticAnalyticsLogger;
import com.taptap.sdk.db.biz.iap.common.IIAPTracker;
import com.taptap.sdk.db.biz.iap.lib2minus.BillingLib2MinusTracker;
import com.taptap.sdk.db.biz.iap.lib2plus.BillingLib2PlusTracker;
import com.taptap.sdk.kit.internal.TapLogger;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00005\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004*\u0001\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\b\u0010\u0011\u001a\u00020\u000eH\u0007J\b\u0010\u0012\u001a\u00020\u000eH\u0007J\b\u0010\u0013\u001a\u00020\u0010H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/taptap/sdk/db/biz/iap/InAppPurchaseManager;", "", "()V", "GOOGLE_BILLINGCLIENT_VERSION", "", "TAG", "enabled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "lifecycleCallbacks", "com/taptap/sdk/db/biz/iap/InAppPurchaseManager$lifecycleCallbacks$1", "Lcom/taptap/sdk/db/biz/iap/InAppPurchaseManager$lifecycleCallbacks$1;", "tracker", "Lcom/taptap/sdk/db/biz/iap/common/IIAPTracker;", "setEnableAutoLogging", "", "enable", "", "startTracking", "stopTracking", "usingBillingLib2Plus", "tap-db_release"})
public final class InAppPurchaseManager {
    @NotNull
    public static final InAppPurchaseManager INSTANCE = new InAppPurchaseManager();
    @NotNull
    private static final String TAG = "InAppPurchaseManager";
    @NotNull
    private static final String GOOGLE_BILLINGCLIENT_VERSION = "com.google.android.play.billingclient.version";
    @NotNull
    private static final AtomicBoolean enabled = new AtomicBoolean(false);
    private static IIAPTracker tracker;
    @NotNull
    private static final lifecycleCallbacks.1 lifecycleCallbacks;

    private InAppPurchaseManager() {
    }

    @JvmStatic
    public static final void setEnableAutoLogging(boolean enable) {
        enabled.set(enable);
        TapLogger.logd((String)TAG, (String)("InAppPurchaseManager setEnableAutoLogging enable=" + enable));
        if (enable) {
            TapActivityLifecycleTracker.INSTANCE.registerActivityLifecycleCallbacks((TapActivityLifecycleCallbacks)lifecycleCallbacks);
            INSTANCE.startTracking();
        } else {
            TapActivityLifecycleTracker.INSTANCE.unregisterActivityLifecycleCallbacks((TapActivityLifecycleCallbacks)lifecycleCallbacks);
            INSTANCE.stopTracking();
        }
    }

    @JvmStatic
    public static final void startTracking() {
        if (enabled.get()) {
            IIAPTracker iIAPTracker;
            if (tracker == null) {
                tracker = INSTANCE.usingBillingLib2Plus() ? (IIAPTracker)BillingLib2PlusTracker.INSTANCE : (IIAPTracker)BillingLib2MinusTracker.INSTANCE;
                IIAPTracker iIAPTracker2 = tracker;
                if (iIAPTracker2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"tracker");
                    iIAPTracker2 = null;
                }
                iIAPTracker2.setOnLogPurchaseListener(new IIAPTracker.ILogPurchaseListener(){

                    public void onLogPurchase(@NotNull String purchase, @NotNull String skuDetails, boolean isSubscription) {
                        Intrinsics.checkNotNullParameter((Object)purchase, (String)"purchase");
                        Intrinsics.checkNotNullParameter((Object)skuDetails, (String)"skuDetails");
                        AutomaticAnalyticsLogger.logPurchase(purchase, skuDetails, isSubscription);
                    }
                });
            }
            if ((iIAPTracker = tracker) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"tracker");
                iIAPTracker = null;
            }
            iIAPTracker.startTracker(TapDB.Companion.getOptions$tap_db_release().getContext());
        }
    }

    @JvmStatic
    public static final void stopTracking() {
        if (tracker != null) {
            IIAPTracker iIAPTracker = tracker;
            if (iIAPTracker == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"tracker");
                iIAPTracker = null;
            }
            iIAPTracker.stopTracker();
        }
    }

    private final boolean usingBillingLib2Plus() {
        try {
            String version;
            Context context = TapDB.Companion.getOptions$tap_db_release().getContext();
            ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"context.packageManager.g\u2026TA_DATA\n                )");
            ApplicationInfo info = applicationInfo;
            String string2 = version = info.metaData.getString(GOOGLE_BILLINGCLIENT_VERSION);
            if (string2 == null) {
                return false;
            }
            String[] stringArray = new String[]{"."};
            List versionArray = StringsKt.split$default((CharSequence)string2, (String[])stringArray, (boolean)false, (int)3, (int)2, null);
            return Integer.parseInt((String)versionArray.get(0)) >= 2;
        }
        catch (Exception e) {
            return false;
        }
    }

    static {
        lifecycleCallbacks = new TapActivityLifecycleCallbacks(){

            public void onActivityCreated(@NotNull Activity activity, @Nullable Bundle savedInstanceState) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            }

            public void onActivityStarted(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            }

            public void onActivityResumed(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                InAppPurchaseManager.startTracking();
            }

            public void onActivityPaused(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            }

            public void onActivityStopped(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            }

            public void onActivitySaveInstanceState(@NotNull Activity activity, @NotNull Bundle outState) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
            }

            public void onActivityDestroyed(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            }

            public void onBackground(@NotNull Context context) {
                TapActivityLifecycleCallbacks.DefaultImpls.onBackground((TapActivityLifecycleCallbacks)this, (Context)context);
            }

            public void onForeground(@NotNull Context context) {
                TapActivityLifecycleCallbacks.DefaultImpls.onForeground((TapActivityLifecycleCallbacks)this, (Context)context);
            }
        };
    }
}

