/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.db.biz.iap.lib2minus;

import android.app.Activity;
import android.app.Application;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.util.Log;
import com.taptap.sdk.base.utils.lifecycle.TapActivityLifecycleCallbacks;
import com.taptap.sdk.base.utils.lifecycle.TapActivityLifecycleTracker;
import com.taptap.sdk.db.TapDB;
import com.taptap.sdk.db.biz.iap.common.IAPEventUtils;
import com.taptap.sdk.db.biz.iap.common.IIAPTracker;
import com.taptap.sdk.db.biz.iap.common.InAppPurchaseUtils;
import com.taptap.sdk.db.biz.iap.lib2minus.BillingLib2MinusTracker;
import com.taptap.sdk.kit.internal.executor.TapNetExecutor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0002J0\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0016\u0010\u001d\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u001ej\b\u0012\u0004\u0012\u00020\u0004`\u001f2\u0006\u0010 \u001a\u00020\u000bH\u0002J\u0010\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u0015H\u0016J\u0010\u0010#\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010$\u001a\u00020\u0019H\u0002J\b\u0010%\u001a\u00020\u0019H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0007*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\fR\u0012\u0010\r\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\fR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/taptap/sdk/db/biz/iap/lib2minus/BillingLib2MinusTracker;", "Lcom/taptap/sdk/db/biz/iap/common/IIAPTracker;", "()V", "BILLING_ACTIVITY_NAME", "", "SERVICE_INTERFACE_NAME", "TAG", "kotlin.jvm.PlatformType", "callbacks", "Lcom/taptap/sdk/base/utils/lifecycle/TapActivityLifecycleCallbacks;", "hasBillingActivity", "", "Ljava/lang/Boolean;", "hasBillingService", "inAppBillingObj", "", "intent", "Landroid/content/Intent;", "isTracking", "Ljava/util/concurrent/atomic/AtomicBoolean;", "listener", "Lcom/taptap/sdk/db/biz/iap/common/IIAPTracker$ILogPurchaseListener;", "serviceConnection", "Landroid/content/ServiceConnection;", "initializeIfNotInitialized", "", "logPurchase", "context", "Landroid/content/Context;", "purchases", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "isSubscription", "setOnLogPurchaseListener", "l", "startTracker", "startTracking", "stopTracker", "tap-db_release"})
public final class BillingLib2MinusTracker
implements IIAPTracker {
    @NotNull
    public static final BillingLib2MinusTracker INSTANCE = new BillingLib2MinusTracker();
    private static final String TAG = BillingLib2MinusTracker.class.getCanonicalName();
    @NotNull
    private static final String SERVICE_INTERFACE_NAME = "com.android.vending.billing.IInAppBillingService$Stub";
    @NotNull
    private static final String BILLING_ACTIVITY_NAME = "com.android.billingclient.api.ProxyBillingActivity";
    @NotNull
    private static final AtomicBoolean isTracking = new AtomicBoolean(false);
    @Nullable
    private static Boolean hasBillingService;
    @Nullable
    private static Boolean hasBillingActivity;
    private static ServiceConnection serviceConnection;
    private static TapActivityLifecycleCallbacks callbacks;
    private static Intent intent;
    @Nullable
    private static Object inAppBillingObj;
    @Nullable
    private static IIAPTracker.ILogPurchaseListener listener;

    private BillingLib2MinusTracker() {
    }

    @Override
    public void startTracker(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.initializeIfNotInitialized();
        if (Intrinsics.areEqual((Object)hasBillingService, (Object)false)) {
            return;
        }
        this.startTracking();
    }

    @Override
    public void stopTracker() {
        TapActivityLifecycleCallbacks tapActivityLifecycleCallbacks = callbacks;
        if (tapActivityLifecycleCallbacks == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"callbacks");
            tapActivityLifecycleCallbacks = null;
        }
        TapActivityLifecycleTracker.INSTANCE.unregisterActivityLifecycleCallbacks(tapActivityLifecycleCallbacks);
        Context context = TapDB.Companion.getOptions$tap_db_release().getContext();
        if (context instanceof Application) {
            BillingLib2MinusTracker billingLib2MinusTracker = this;
            try {
                BillingLib2MinusTracker $this$stopTracker_u24lambda_u240 = billingLib2MinusTracker;
                boolean bl = false;
                if (inAppBillingObj != null && serviceConnection != null) {
                    ServiceConnection serviceConnection = BillingLib2MinusTracker.serviceConnection;
                    if (serviceConnection == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"serviceConnection");
                        serviceConnection = null;
                    }
                    context.unbindService(serviceConnection);
                }
                Object object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable) {
                Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
        }
    }

    @Override
    public void setOnLogPurchaseListener(@NotNull IIAPTracker.ILogPurchaseListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        listener = l;
    }

    private final void initializeIfNotInitialized() {
        if (hasBillingService != null) {
            return;
        }
        hasBillingService = InAppPurchaseUtils.getClass(SERVICE_INTERFACE_NAME) != null;
        if (Intrinsics.areEqual((Object)hasBillingService, (Object)false)) {
            return;
        }
        hasBillingActivity = InAppPurchaseUtils.getClass(BILLING_ACTIVITY_NAME) != null;
        IAPEventUtils.clearSkuDetailsCache();
        Intent intent = new Intent("com.android.vending.billing.InAppBillingService.BIND").setPackage("com.android.vending");
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"Intent(\"com.android.vend\u2026ge(\"com.android.vending\")");
        BillingLib2MinusTracker.intent = intent;
        serviceConnection = new ServiceConnection(){

            public void onServiceConnected(@NotNull ComponentName name, @NotNull IBinder service) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)service, (String)"service");
                BillingLib2MinusTracker.access$setInAppBillingObj$p(IAPEventUtils.asInterface(TapDB.Companion.getOptions$tap_db_release().getContext(), service));
            }

            public void onServiceDisconnected(@NotNull ComponentName name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            }
        };
        callbacks = new TapActivityLifecycleCallbacks(){

            public void onActivityResumed(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                try {
                    TapNetExecutor.getExecutor().execute(initializeIfNotInitialized.2::onActivityResumed$lambda$0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            public void onActivityCreated(@NotNull Activity activity, @Nullable Bundle savedInstanceState) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            }

            public void onActivityStarted(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            }

            public void onActivityPaused(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            }

            public void onActivityStopped(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                try {
                    if (Intrinsics.areEqual((Object)BillingLib2MinusTracker.access$getHasBillingActivity$p(), (Object)true) && Intrinsics.areEqual((Object)activity.getLocalClassName(), (Object)"com.android.billingclient.api.ProxyBillingActivity")) {
                        TapNetExecutor.getExecutor().execute(initializeIfNotInitialized.2::onActivityStopped$lambda$1);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            public void onActivitySaveInstanceState(@NotNull Activity activity, @NotNull Bundle outState) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
            }

            public void onActivityDestroyed(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            }

            public void onBackground(@NotNull Context context) {
                TapActivityLifecycleCallbacks.DefaultImpls.onBackground((TapActivityLifecycleCallbacks)this, (Context)context);
            }

            public void onForeground(@NotNull Context context) {
                TapActivityLifecycleCallbacks.DefaultImpls.onForeground((TapActivityLifecycleCallbacks)this, (Context)context);
            }

            private static final void onActivityResumed$lambda$0() {
                Context context = TapDB.Companion.getOptions$tap_db_release().getContext();
                ArrayList<String> purchasesInapp = IAPEventUtils.getPurchasesInapp(context, BillingLib2MinusTracker.access$getInAppBillingObj$p());
                BillingLib2MinusTracker.access$logPurchase(BillingLib2MinusTracker.INSTANCE, context, purchasesInapp, false);
            }

            private static final void onActivityStopped$lambda$1() {
                Context context = TapDB.Companion.getOptions$tap_db_release().getContext();
                ArrayList<String> purchases = IAPEventUtils.getPurchasesInapp(context, BillingLib2MinusTracker.access$getInAppBillingObj$p());
                if (purchases.isEmpty()) {
                    purchases = IAPEventUtils.getPurchaseHistoryInapp(context, BillingLib2MinusTracker.access$getInAppBillingObj$p());
                }
                BillingLib2MinusTracker.access$logPurchase(BillingLib2MinusTracker.INSTANCE, context, purchases, false);
            }
        };
    }

    private final void startTracking() {
        if (!isTracking.compareAndSet(false, true)) {
            return;
        }
        TapActivityLifecycleCallbacks tapActivityLifecycleCallbacks = callbacks;
        if (tapActivityLifecycleCallbacks == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"callbacks");
            tapActivityLifecycleCallbacks = null;
        }
        TapActivityLifecycleTracker.INSTANCE.registerActivityLifecycleCallbacks(tapActivityLifecycleCallbacks);
        Context context = TapDB.Companion.getOptions$tap_db_release().getContext();
        if (context instanceof Application) {
            ServiceConnection serviceConnection;
            Intent intent = BillingLib2MinusTracker.intent;
            if (intent == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"intent");
                intent = null;
            }
            if ((serviceConnection = BillingLib2MinusTracker.serviceConnection) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"serviceConnection");
                serviceConnection = null;
            }
            context.bindService(intent, serviceConnection, 1);
        }
    }

    private final void logPurchase(Context context, ArrayList<String> purchases, boolean isSubscription) {
        if (purchases.isEmpty()) {
            return;
        }
        HashMap purchaseMap = new HashMap();
        ArrayList<String> skuList = new ArrayList<String>();
        for (String purchase : purchases) {
            try {
                JSONObject purchaseJson = new JSONObject(purchase);
                String sku = purchaseJson.getString("productId");
                Map map2 = purchaseMap;
                Intrinsics.checkNotNullExpressionValue((Object)sku, (String)"sku");
                Intrinsics.checkNotNullExpressionValue((Object)purchase, (String)"purchase");
                map2.put(sku, purchase);
                skuList.add(sku);
            }
            catch (JSONException e) {
                Log.e((String)TAG, (String)"Error parsing in-app purchase data.", (Throwable)e);
            }
        }
        Map<String, String> skuDetailsMap = IAPEventUtils.getSkuDetails(context, skuList, inAppBillingObj, isSubscription);
        for (Map.Entry<String, String> entry : skuDetailsMap.entrySet()) {
            String it;
            String key = entry.getKey();
            String value = entry.getValue();
            if ((String)purchaseMap.get(key) == null) continue;
            boolean bl = false;
            IIAPTracker.ILogPurchaseListener iLogPurchaseListener = listener;
            if (iLogPurchaseListener == null) continue;
            iLogPurchaseListener.onLogPurchase(it, value, isSubscription);
        }
    }

    public static final /* synthetic */ void access$setInAppBillingObj$p(Object object) {
        inAppBillingObj = object;
    }

    public static final /* synthetic */ Boolean access$getHasBillingActivity$p() {
        return hasBillingActivity;
    }

    public static final /* synthetic */ Object access$getInAppBillingObj$p() {
        return inAppBillingObj;
    }

    public static final /* synthetic */ void access$logPurchase(BillingLib2MinusTracker $this, Context context, ArrayList purchases, boolean isSubscription) {
        $this.logPurchase(context, purchases, isSubscription);
    }
}

