/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.gid.internal;

import android.content.Context;
import android.os.Build;
import android.os.Environment;
import android.os.Process;
import com.taptap.sdk.gid.internal.util.TapOpenlogHelper;
import com.taptap.sdk.kit.internal.TapLogger;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\n\u001a\u00020\u000b2\b\u0010\t\u001a\u0004\u0018\u00010\u0004J\u0018\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u0010\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/taptap/sdk/gid/internal/FileUtil;", "", "()V", "TAG", "", "createFile", "", "fileByte", "", "filePath", "deleteFile", "", "hasReadWritePermission", "context", "Landroid/content/Context;", "readOrWritePermission", "returnFileByte", "tap-gid_release"})
public final class FileUtil {
    @NotNull
    public static final FileUtil INSTANCE = new FileUtil();
    @NotNull
    private static final String TAG = "TapGidFileUtil";

    private FileUtil() {
    }

    @NotNull
    public final byte[] returnFileByte(@Nullable String filePath) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(new File(filePath));
        FileChannel channel = fileInputStream.getChannel();
        ByteBuffer byteBuffer = ByteBuffer.allocate((int)channel.size());
        channel.read(byteBuffer);
        byte[] byArray = byteBuffer.array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"byteBuffer.array()");
        return byArray;
    }

    public final void createFile(@Nullable byte[] fileByte, @Nullable String filePath) {
        BufferedOutputStream bufferedOutputStream = null;
        FileOutputStream fileOutputStream = null;
        File file = new File(filePath);
        try {
            fileOutputStream = new FileOutputStream(file);
            bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            bufferedOutputStream.write(fileByte);
            bufferedOutputStream.close();
            fileOutputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public final boolean deleteFile(@Nullable String filePath) {
        File file = new File(filePath);
        return file.exists() ? file.delete() : false;
    }

    public final boolean hasReadWritePermission(@NotNull Context context, @Nullable String readOrWritePermission) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Pair[] pairArray = (Pair[])readOrWritePermission;
        if (pairArray == null || pairArray.length() == 0) {
            return false;
        }
        pairArray = new Pair[]{TuplesKt.to((Object)"readOrWritePermission", (Object)String.valueOf(readOrWritePermission)), TuplesKt.to((Object)"Build.VERSION.SDK", (Object)String.valueOf(Build.VERSION.SDK_INT))};
        TapOpenlogHelper.INSTANCE.reportTechnicalLog("check_has_read_write_permission", MapsKt.mapOf((Pair[])pairArray));
        TapLogger.logd((String)TAG, (String)("check hasReadWritePermission, readOrWritePermission = " + readOrWritePermission + ", Build.VERSION.SDK = " + Build.VERSION.SDK_INT));
        try {
            int permission;
            return Build.VERSION.SDK_INT < 30 ? (permission = context.checkPermission(readOrWritePermission, Process.myPid(), Process.myUid())) == 0 : Environment.isExternalStorageManager();
        }
        catch (Throwable e) {
            TapLogger.logd((String)TAG, (Throwable)e);
            return false;
        }
    }
}

