/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.gid.internal;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.ResultReceiver;
import android.text.TextUtils;
import com.taptap.sdk.gid.internal.FileUtil;
import com.taptap.sdk.gid.internal.util.TapOpenlogHelper;
import com.taptap.sdk.gid.service.TapGidIntentService;
import com.taptap.sdk.kit.internal.TapLogger;
import java.io.File;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00042\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00042\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\u001a\u0010\u000f\u001a\u00020\u00102\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0004J\u001a\u0010\u0012\u001a\u00020\u00102\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0004J\u001a\u0010\u0013\u001a\u00020\u00102\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/taptap/sdk/gid/internal/GidStorage;", "", "()V", "SAVE_GID_FILE_NAME", "", "SAVE_GID_FILE_PATH", "TAP_DEVICE_ID_SAVED_PARAM", "TAP_GID_SHARE_PREFERENCE", "getSDCardGid", "context", "Landroid/content/Context;", "getSpGid", "receiverForSending", "Landroid/os/ResultReceiver;", "actualReceiver", "saveSDCardGid", "", "deviceId", "saveSpGid", "saveTapGidIntentService", "tap-gid_release"})
public final class GidStorage {
    @NotNull
    public static final GidStorage INSTANCE = new GidStorage();
    @NotNull
    private static final String TAP_GID_SHARE_PREFERENCE = "tap_gid_share_preference";
    @NotNull
    private static final String TAP_DEVICE_ID_SAVED_PARAM = "taptap_device_id_saved_param";
    @NotNull
    private static final String SAVE_GID_FILE_NAME = "taptapgid.tmp";
    @NotNull
    private static final String SAVE_GID_FILE_PATH = Environment.getExternalStorageDirectory().toString() + "/taptap_gid";

    private GidStorage() {
    }

    public final void saveSpGid(@Nullable Context context, @Nullable String deviceId) {
        if (TextUtils.isEmpty((CharSequence)deviceId) || context == null) {
            return;
        }
        try {
            SharedPreferences sp = context.getSharedPreferences(TAP_GID_SHARE_PREFERENCE, 0);
            SharedPreferences.Editor editor = sp.edit();
            editor.putString(TAP_DEVICE_ID_SAVED_PARAM, deviceId);
            editor.commit();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Nullable
    public final String getSpGid(@Nullable Context context) {
        if (context == null) {
            return null;
        }
        SharedPreferences sp = context.getSharedPreferences(TAP_GID_SHARE_PREFERENCE, 0);
        return sp.getString(TAP_DEVICE_ID_SAVED_PARAM, null);
    }

    public final void saveSDCardGid(@Nullable Context context, @Nullable String deviceId) {
        if (TextUtils.isEmpty((CharSequence)deviceId) || context == null) {
            return;
        }
        try {
            if (FileUtil.INSTANCE.hasReadWritePermission(context, "android.permission.WRITE_EXTERNAL_STORAGE")) {
                File file = new File(SAVE_GID_FILE_PATH);
                boolean fileExist = true;
                if (!file.exists()) {
                    fileExist = file.mkdirs();
                }
                if (fileExist) {
                    String string = deviceId;
                    Intrinsics.checkNotNull((Object)string);
                    String string2 = string;
                    byte[] byArray = string2.getBytes(Charsets.UTF_8);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                    FileUtil.INSTANCE.createFile(byArray, SAVE_GID_FILE_PATH + "/taptapgid.tmp");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Nullable
    public final String getSDCardGid(@Nullable Context context) {
        if (context == null) {
            return null;
        }
        if (FileUtil.INSTANCE.hasReadWritePermission(context, "android.permission.READ_EXTERNAL_STORAGE")) {
            try {
                return new String(FileUtil.INSTANCE.returnFileByte(SAVE_GID_FILE_PATH + "/taptapgid.tmp"), Charsets.UTF_8);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public final void saveTapGidIntentService(@Nullable Context context, @Nullable String deviceId) {
        if (TextUtils.isEmpty((CharSequence)deviceId) || context == null) {
            return;
        }
        try {
            Intent intent2;
            boolean bl = false;
            Intent intent3 = intent2 = TapGidIntentService.Companion.getNewSetIdIntent(context, deviceId);
            if (intent3 != null) {
                Handler handler = new Handler(Looper.getMainLooper());
                intent3.putExtra("receiver", (Parcelable)INSTANCE.receiverForSending(new ResultReceiver(handler){

                    protected void onReceiveResult(int resultCode, @NotNull Bundle resultData) {
                        Intrinsics.checkNotNullParameter((Object)resultData, (String)"resultData");
                        super.onReceiveResult(resultCode, resultData);
                        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"resultCode", (Object)String.valueOf(resultCode)), TuplesKt.to((Object)"resultData", (Object)resultData.getString("unified_gid_result_param"))};
                        TapOpenlogHelper.INSTANCE.reportTechnicalLog("save_taptap_gid_callback", MapsKt.mapOf((Pair[])pairArray));
                        TapLogger.logd((String)"TapGidIntentService", (String)("resultCode = " + resultCode + ", resultData = " + resultData.getString("unified_gid_result_param")));
                    }
                }));
            }
            Object object = Result.constructor-impl((Object)context.startService(intent2));
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    private final ResultReceiver receiverForSending(ResultReceiver actualReceiver) {
        Parcel parcel = Parcel.obtain();
        Intrinsics.checkNotNullExpressionValue((Object)parcel, (String)"obtain()");
        Parcel parcel2 = parcel;
        actualReceiver.writeToParcel(parcel2, 0);
        parcel2.setDataPosition(0);
        ResultReceiver receiverForSending = (ResultReceiver)ResultReceiver.CREATOR.createFromParcel(parcel2);
        parcel2.recycle();
        Intrinsics.checkNotNullExpressionValue((Object)receiverForSending, (String)"receiverForSending");
        return receiverForSending;
    }
}

